/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm;

import com.sun.ut.vdm.Dialog;
import com.sun.ut.vdm.I18N;
import com.sun.ut.vdm.VdmClient;
import com.sun.ut.vdm.api.ClientException;
import com.sun.ut.vdm.api.Desktop;
import com.sun.ut.vdm.api.DesktopConnectException;
import com.sun.ut.vdm.api.VDMException;
import com.sun.ut.vdm.util.TimedLabel;
import com.sun.ut.vdm.util.Utils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopPicker
extends JPanel
implements AWTEventListener,
ActionListener,
Dialog,
I18N.LocaleListener {
    private VdmClient vdmclient;
    private List<Desktop> desktops = new LinkedList<Desktop>();
    private DesktopTableModel tableModel;
    private TimedLabel statusLabel;
    private int timeOut;
    private Timer timer;
    private JButton bCancel;
    private JButton bConnect;
    private JTable table;
    private JLabel label1;
    private JLabel label2;
    private long mostRecentEventTime = -1L;

    DesktopPicker(VdmClient vdmclient, List<Desktop> desktops, int timeOut) {
        super(new GridBagLayout());
        this.timeOut = timeOut * 1000;
        this.vdmclient = vdmclient;
        GridBagConstraints c = new GridBagConstraints();
        JLabel Lbanner = new JLabel();
        Lbanner.setIcon(new ImageIcon(this.getClass().getResource("/aurelia12-banner2.png")));
        Lbanner.setVerticalAlignment(3);
        c.fill = 2;
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)Lbanner, c);
        JLabel LvdmIcon = new JLabel();
        LvdmIcon.setIcon(new ImageIcon(this.getClass().getResource("/aurelia12-vdm_logo.png")));
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.insets = new Insets(15, 20, 15, 0);
        this.add((Component)LvdmIcon, c);
        Insets labelInsets = new Insets(5, 10, 5, 10);
        JPanel titlePanel = new JPanel(new GridLayout(2, 1));
        this.label1 = new JLabel("");
        this.label2 = new JLabel(I18N.get("SELECTOR_MSG2"));
        titlePanel.add(this.label1);
        titlePanel.add(this.label2);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.insets = labelInsets;
        this.add((Component)titlePanel, c);
        JScrollPane jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        jScrollPane2.setViewportView(this.table);
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 2;
        c.weighty = 0.9;
        c.insets = (Insets)labelInsets.clone();
        c.insets.right = 20;
        this.add((Component)jScrollPane2, c);
        c.gridx = 0;
        c.gridy = 3;
        c.weighty = 0.1;
        c.gridwidth = 1;
        this.statusLabel = new TimedLabel(this, c, labelInsets, labelInsets);
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        this.bConnect = new JButton(I18N.get("CONNECT"));
        bottomPanel.add(this.bConnect);
        this.bCancel = new JButton(I18N.get("LOGOUT"));
        bottomPanel.add(this.bCancel);
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 4;
        c.weighty = 0.0;
        c.insets = (Insets)labelInsets.clone();
        c.insets.bottom = 10;
        this.add((Component)bottomPanel, c);
        this.tableModel = new DesktopTableModel();
        this.setDesktops(desktops);
        this.table.setModel(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(0);
        TableColumn column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(250);
        this.table.setAutoResizeMode(2);
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        if (vdmclient.getAutoPickDesktop()) {
            Desktop disconnected = null;
            int n = 0;
            int row = 0;
            for (int i = 0; i < desktops.size(); ++i) {
                if (desktops.get((int)i).session != 1) continue;
                disconnected = desktops.get(i);
                ++n;
                row = i;
            }
            if (n == 1) {
                this.table.setRowSelectionInterval(row, row);
                this.connect(disconnected);
            }
        }
        this.initListeners();
        I18N.addLocaleListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        this.mostRecentEventTime = System.currentTimeMillis();
    }

    @Override
    public void localeChanged() {
        this.label2.setText(I18N.get("SELECTOR_MSG2"));
        this.bConnect.setText(I18N.get("CONNECT"));
        this.bCancel.setText(I18N.get("LOGOUT"));
        Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn c = columns.nextElement();
            c.setHeaderValue(this.tableModel.getColumnName(c.getModelIndex()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long currTime = System.currentTimeMillis();
        if (this.mostRecentEventTime > -1L && currTime - this.mostRecentEventTime > (long)this.timeOut) {
            Utils.log(I18N.get("SESSION_TIMEOUT"));
            this.logout();
        }
    }

    public Desktop getSelected() {
        int n = this.table.getSelectedRow();
        if (n >= 0 && n < this.desktops.size()) {
            return this.desktops.get(n);
        }
        return null;
    }

    public void update(String msg, List<Desktop> desktops, int timeout) {
        this.timeOut = timeout * 1000;
        this.setDesktops(desktops);
        this.label1.setText(msg);
        this.timer = new Timer(1000, this);
        this.timer.setInitialDelay(1000);
        this.timer.start();
        this.getToolkit().addAWTEventListener(this, 56L);
    }

    public void setDesktops(List<Desktop> newDesktops) {
        this.tableModel.setDesktops(newDesktops);
        this.desktops = newDesktops;
        if (newDesktops.isEmpty()) {
            this.statusLabel.setPermanentText(I18N.get("NO_DESKTOPS"), 3);
            this.bConnect.setEnabled(false);
            this.bCancel.requestFocus();
        } else {
            this.statusLabel.clear();
            this.bConnect.setEnabled(true);
            this.table.addRowSelectionInterval(0, 0);
            this.bConnect.requestFocus();
        }
    }

    private void initListeners() {
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesktopPicker.this.tableMouseClicked(evt);
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                DesktopPicker.this.tableKeyPressed(evt);
            }
        });
        this.bConnect.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesktopPicker.this.bConnectMouseClicked(evt);
            }
        });
        this.bConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DesktopPicker.this.bConnectActionPerformed(evt);
            }
        });
        this.bConnect.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                DesktopPicker.this.bConnectKeyPressed(evt);
            }
        });
        this.bCancel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesktopPicker.this.bCancelMouseClicked(evt);
            }
        });
        this.bCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DesktopPicker.this.bCancelActionPerformed(evt);
            }
        });
        this.bCancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                DesktopPicker.this.bCancelKeyPressed(evt);
            }
        });
    }

    public void connect(final Desktop desktop) {
        if (desktop == null) {
            return;
        }
        this.statusLabel.setPermanentText(I18N.get("CONNECTING_TO_DESKTOP"), 0);
        this.timer.stop();
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DesktopPicker.this.disableForm();
                boolean enableConnect = true;
                try {
                    DesktopPicker.this.vdmclient.connectToDesktop(desktop);
                    DesktopPicker.this.statusLabel.clear();
                    DesktopPicker.this.statusLabel.setText(I18N.get("UPDATING_DESKTOPS"), 0);
                    DesktopPicker.this.setDesktops(DesktopPicker.this.vdmclient.getDesktops());
                    DesktopPicker.this.statusLabel.clear();
                }
                catch (DesktopConnectException ex) {
                    DesktopPicker.this.showError(ex.getMessage());
                }
                catch (ClientException ex) {
                    DesktopPicker.this.showError(ex.getMessage());
                }
                catch (VDMException ex) {
                    if (ex.getErrorCode().equals("NOT_AUTHENTICATED")) {
                        DesktopPicker.this.statusLabel.setPermanentText(I18N.get("SESSION_TIMEOUT"), 0);
                        enableConnect = false;
                    } else {
                        DesktopPicker.this.showError(ex.getMessage());
                    }
                }
                catch (Exception ex) {
                    DesktopPicker.this.showError(ex.toString() + ": " + ex.getMessage());
                }
                finally {
                    DesktopPicker.this.enableForm();
                    if (!enableConnect) {
                        DesktopPicker.this.bConnect.setEnabled(false);
                    }
                    DesktopPicker.this.timer.restart();
                }
            }
        });
    }

    private void logout() {
        Utils.logout(this, this.vdmclient);
    }

    @Override
    public void showError(String s) {
        this.statusLabel.setText(s, 3);
    }

    @Override
    public void showText(String mesg) {
        this.statusLabel.setText(mesg, 0);
    }

    @Override
    public void clearText() {
        this.statusLabel.setText("", 0);
    }

    private void cancelPressed() {
        this.logout();
    }

    @Override
    public void disableForm() {
        this.bCancel.setEnabled(false);
        this.bConnect.setEnabled(false);
        this.table.setEnabled(false);
    }

    @Override
    public void enableForm() {
        this.table.setEnabled(true);
        this.bCancel.setEnabled(true);
        this.bConnect.setEnabled(true);
    }

    private void bConnectMouseClicked(MouseEvent evt) {
        this.connect(this.getSelected());
    }

    private void bCancelMouseClicked(MouseEvent evt) {
        this.cancelPressed();
    }

    private void bConnectKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.connect(this.getSelected());
        }
    }

    private void bCancelKeyPressed(KeyEvent evt) {
        int keycode = evt.getKeyCode();
        if (keycode == 10 || keycode == 27) {
            this.cancelPressed();
        }
    }

    private void tableKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.connect(this.getSelected());
        }
    }

    private void tableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.connect(this.getSelected());
        }
    }

    private void bCancelActionPerformed(ActionEvent evt) {
    }

    private void bConnectActionPerformed(ActionEvent evt) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DesktopTableModel
    extends AbstractTableModel {
        private static String[] columnNames = new String[]{"DESKTOP", "STATUS"};
        List<Desktop> desktops = new LinkedList<Desktop>();

        public void setDesktops(List<Desktop> newDesktops) {
            if (newDesktops == null) {
                throw new IllegalArgumentException("Desktops cannot be null");
            }
            this.desktops = newDesktops;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.desktops.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < columnNames.length) {
                return I18N.get(columnNames[columnIndex]);
            }
            return super.getColumnName(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.desktops.get((int)rowIndex).name;
                }
                case 1: {
                    switch (this.desktops.get((int)rowIndex).session) {
                        case 0: {
                            return I18N.get("NO_SESSION");
                        }
                        case 1: {
                            return I18N.get("DISCONNECTED");
                        }
                        case 2: {
                            return I18N.get("CONNECTED");
                        }
                    }
                }
            }
            return null;
        }
    }
}

