/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18N {
    private static final String RESOURCE_BUNDLE = "com.sun.ut.vdm.UtVdmStrings";
    private static final Locale[] LOCALES = new Locale[]{Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH, new Locale("es"), Locale.JAPANESE, Locale.KOREAN, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};
    private static final String[] LANGUAGE_KEYS = new String[]{"en", "de", "fr", "es", "ja", "ko", "zh", "zh_tw"};
    private static final Map<Locale, String> locales = new Hashtable<Locale, String>();
    private static Locale uilocale = null;
    private static List<LocaleListener> listeners;

    public static Map<String, Locale> getLocales() {
        TreeMap<String, Locale> result = new TreeMap<String, Locale>();
        for (Locale l : locales.keySet()) {
            result.put(I18N.get("language_" + locales.get(l)), l);
        }
        return result;
    }

    public static boolean isCurrent(Locale l) {
        return uilocale.equals(l);
    }

    public static void setLocale(Locale l) {
        if (l != null && !I18N.isCurrent(l)) {
            uilocale = l;
            Locale.setDefault(l);
            JComponent.setDefaultLocale(l);
            for (LocaleListener listener : listeners) {
                listener.localeChanged();
            }
        }
    }

    public static String getResource(ResourceBundle bundle, String key, Object[] args) {
        String resource = null;
        try {
            if (key != null) {
                resource = bundle.getString(key);
                if (args != null) {
                    MessageFormat formatter = new MessageFormat(resource);
                    resource = formatter.format(args).toString();
                }
            }
        }
        catch (MissingResourceException e) {
            resource = key;
        }
        return resource;
    }

    private static ResourceBundle getBundle(Locale l) {
        return ResourceBundle.getBundle(RESOURCE_BUNDLE, l);
    }

    public static String get(String key) {
        return I18N.getResource(I18N.getBundle(uilocale), key, null);
    }

    public static String get(String key, Object[] args) {
        return I18N.getResource(I18N.getBundle(uilocale), key, args);
    }

    private I18N() {
    }

    public static void addLocaleListener(LocaleListener listener) {
        listeners.add(listener);
    }

    static {
        Locale syslocale = Locale.getDefault();
        for (int i = 0; i < LOCALES.length; ++i) {
            Locale l = LOCALES[i];
            locales.put(l, LANGUAGE_KEYS[i]);
            if (!syslocale.equals(l)) continue;
            uilocale = l;
        }
        if (uilocale == null) {
            uilocale = LOCALES[0];
        }
        Locale.setDefault(uilocale);
        JComponent.setDefaultLocale(uilocale);
        listeners = new ArrayList<LocaleListener>();
    }

    public static interface LocaleListener {
        public void localeChanged();
    }
}

