/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm;

import com.sun.ut.vdm.Dialog;
import com.sun.ut.vdm.I18N;
import com.sun.ut.vdm.VdmClient;
import com.sun.ut.vdm.api.ClientException;
import com.sun.ut.vdm.api.VDMException;
import com.sun.ut.vdm.util.TimedLabel;
import com.sun.ut.vdm.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginDialog
extends JPanel
implements Dialog,
I18N.LocaleListener {
    private final ImageIcon BANNER_ICON = new ImageIcon(this.getClass().getResource("/aurelia12-banner.png"));
    private final ImageIcon LANGUAGE_ICON = new ImageIcon(this.getClass().getResource("/language.png"));
    private final ImageIcon TICK_ICON = new ImageIcon(this.getClass().getResource("/tick.png"));
    private final ImageIcon EMPTY_ICON = new ImageIcon(this.getClass().getResource("/empty.png"));
    VdmClient vdmclient;
    TimedLabel statusLabel;
    JLabel LTitle;
    JLabel Lusername;
    JLabel Lpassword;
    JLabel Ldomain;
    JTextField TFusername;
    JPasswordField TFpassword;
    JComboBox CBdomain;
    JButton bOK;
    JButton bLanguage;
    JPopupMenu popup;

    LoginDialog(String username, String password, List<String> domains, String domain, VdmClient vdmclient) {
        super(new GridBagLayout());
        this.vdmclient = vdmclient;
        GridBagConstraints c = new GridBagConstraints();
        JLabel banner = new JLabel();
        banner.setIcon(this.BANNER_ICON);
        banner.setVerticalAlignment(3);
        c.fill = 2;
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)banner, c);
        this.LTitle = new JLabel("<html>" + I18N.get("LOGIN_MSG") + "</html>");
        this.LTitle.setHorizontalAlignment(2);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(15, 20, 15, 0);
        this.add((Component)this.LTitle, c);
        Insets labelInsets = new Insets(5, 60, 5, 10);
        Insets fieldInsets = new Insets(5, 20, 5, 80);
        this.Lusername = new JLabel(I18N.get("USERNAME"));
        this.Lusername.setHorizontalTextPosition(2);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.insets = labelInsets;
        this.add((Component)this.Lusername, c);
        this.TFusername = new JTextField(username);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.insets = fieldInsets;
        this.add((Component)this.TFusername, c);
        this.Lpassword = new JLabel(I18N.get("PASSWORD"));
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 3;
        c.insets = labelInsets;
        this.add((Component)this.Lpassword, c);
        this.TFpassword = new JPasswordField();
        this.TFpassword.setText(password);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 3;
        c.insets = fieldInsets;
        this.add((Component)this.TFpassword, c);
        this.Ldomain = new JLabel(I18N.get("DOMAIN"));
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 4;
        c.insets = labelInsets;
        this.add((Component)this.Ldomain, c);
        this.CBdomain = new JComboBox();
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 4;
        c.insets = fieldInsets;
        if (domains != null) {
            this.setDomain(domains, domain);
        }
        this.add((Component)this.CBdomain, c);
        c.gridx = 0;
        c.gridy = 5;
        c.weighty = 1.0;
        c.gridwidth = 1;
        Insets textInsets = (Insets)fieldInsets.clone();
        textInsets.right = 10;
        this.statusLabel = new TimedLabel(this, c, labelInsets, textInsets);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.bOK = new JButton(I18N.get("OK"));
        this.bOK.setPreferredSize(new Dimension(100, 25));
        bottomPanel.add((Component)this.bOK, "West");
        this.createLanguagePopup();
        this.bLanguage = new JButton(this.LANGUAGE_ICON);
        this.bLanguage.setContentAreaFilled(false);
        this.bLanguage.setBorderPainted(false);
        this.bLanguage.setToolTipText(I18N.get("LANGUAGE"));
        bottomPanel.add((Component)this.bLanguage, "East");
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 6;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = (Insets)fieldInsets.clone();
        c.insets.right = 0;
        c.insets.bottom = 10;
        this.add((Component)bottomPanel, c);
        this.initListeners();
        I18N.addLocaleListener(this);
    }

    @Override
    public void localeChanged() {
        this.LTitle.setText("<html>" + I18N.get("LOGIN_MSG") + "</html>");
        this.Lusername.setText(I18N.get("USERNAME"));
        this.Lpassword.setText(I18N.get("PASSWORD"));
        this.Ldomain.setText(I18N.get("DOMAIN"));
        this.bOK.setText(I18N.get("OK"));
        this.bLanguage.setToolTipText(I18N.get("LANGUAGE"));
        this.createLanguagePopup();
    }

    public void update(String username, String password, List<String> domains, String domain) {
        this.setUsername(username);
        this.setPassword(password);
        this.setDomain(domains, domain);
        if (!Utils.empty(username)) {
            this.TFpassword.requestFocus();
        } else {
            this.TFusername.requestFocus();
        }
    }

    @Override
    public void showError(String text) {
        this.statusLabel.setText(text, 3);
        this.TFpassword.requestFocus();
        this.TFpassword.selectAll();
    }

    @Override
    public void showText(String mesg) {
        this.statusLabel.setText(mesg, 0);
    }

    @Override
    public void clearText() {
        this.statusLabel.setText("", 0);
    }

    public void hideError() {
        this.statusLabel.clear();
    }

    public void selectPassword() {
        this.TFpassword.selectAll();
    }

    public String getUsername() {
        return this.TFusername.getText();
    }

    public String getPassword() {
        return new String(this.TFpassword.getPassword());
    }

    public List<String> getDomains() {
        int count = this.CBdomain.getItemCount();
        LinkedList<String> domains = new LinkedList<String>();
        for (int i = 0; i < count; ++i) {
            domains.add((String)this.CBdomain.getItemAt(i));
        }
        return domains;
    }

    public String getDomain() {
        return (String)this.CBdomain.getSelectedItem();
    }

    public void setUsername(String username) {
        this.TFusername.setText(username);
        this.checkUserName();
    }

    public void setPassword(String password) {
        this.TFpassword.setText(password);
    }

    public void setDomain(List<String> domains, String domain) {
        this.CBdomain.removeAllItems();
        for (String dom : domains) {
            this.CBdomain.addItem(dom);
        }
        if (domain != null && !domain.equals("")) {
            this.CBdomain.setSelectedItem(domain);
        }
    }

    private void showLanguagePopup(JComponent source) {
        int width = (int)this.popup.getPreferredSize().getWidth();
        width = source.getWidth() > width ? source.getWidth() : width;
        int height = source.getHeight() * this.popup.getComponentCount();
        this.popup.setPopupSize(width, height);
        this.popup.show(source, 0, source.getHeight());
    }

    private void createLanguagePopup() {
        final Map<String, Locale> locales = I18N.getLocales();
        this.popup = new JPopupMenu();
        Iterator<String> i$ = locales.keySet().iterator();
        while (i$.hasNext()) {
            String label;
            JMenuItem item = new JMenuItem(label, I18N.isCurrent(locales.get(label = i$.next())) ? this.TICK_ICON : this.EMPTY_ICON);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LoginDialog.this.vdmclient.setLocale(((Locale)locales.get(label)).toString());
                    I18N.setLocale((Locale)locales.get(label));
                }
            });
            this.popup.add(item);
        }
    }

    private void initListeners() {
        this.bLanguage.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LoginDialog.this.showLanguagePopup(LoginDialog.this.bLanguage);
            }
        });
        this.bLanguage.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 32) {
                    LoginDialog.this.showLanguagePopup(LoginDialog.this.bLanguage);
                }
            }
        });
        this.bOK.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LoginDialog.this.bOKMouseClicked(evt);
            }
        });
        this.bOK.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                LoginDialog.this.bOKKeyPressed(evt);
            }
        });
        this.TFpassword.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LoginDialog.this.TFpasswordFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                LoginDialog.this.TFpasswordFocusLost(evt);
            }
        });
        this.TFpassword.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                LoginDialog.this.TFpasswordKeyPressed(evt);
            }
        });
        this.CBdomain.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                LoginDialog.this.CBdomainKeyPressed(evt);
            }
        });
        this.TFusername.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LoginDialog.this.TFusernameMouseClicked(evt);
            }
        });
        this.TFusername.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LoginDialog.this.TFusernameFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                LoginDialog.this.TFusernameFocusLost(evt);
            }
        });
        this.TFusername.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                LoginDialog.this.TFusernameKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                LoginDialog.this.TFusernameKeyReleased(evt);
            }
        });
    }

    private void ok() {
        if (!Utils.empty(this.getUsername())) {
            this.showText(I18N.get("CONNECTING"));
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    LoginDialog.this.disableForm();
                    Utils.useWaitCursor(LoginDialog.this);
                    try {
                        LoginDialog.this.vdmclient.submitAuth(LoginDialog.this.getUsername(), LoginDialog.this.getPassword(), LoginDialog.this.getDomain());
                    }
                    catch (ClientException ex) {
                        LoginDialog.this.showError(ex.getMessage());
                    }
                    catch (VDMException ex) {
                        LoginDialog.this.showError(ex.getMessage());
                    }
                    catch (Exception ex) {
                        LoginDialog.this.showError(ex.toString() + ": " + ex.getMessage());
                    }
                    Utils.useDefaultCursor(LoginDialog.this);
                    LoginDialog.this.enableForm();
                }
            });
        }
    }

    @Override
    public void enableForm() {
        this.bOK.setEnabled(true);
        this.bLanguage.setEnabled(true);
    }

    @Override
    public void disableForm() {
        this.bOK.setEnabled(false);
        this.bLanguage.setEnabled(false);
    }

    private void checkUserName() {
        this.bOK.setEnabled(!Utils.empty(this.getUsername()));
    }

    private void bOKKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 32) {
            this.ok();
        }
    }

    private void TFpasswordFocusGained(FocusEvent evt) {
        this.TFpassword.selectAll();
    }

    private void TFpasswordKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.ok();
        }
    }

    private void CBdomainKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.ok();
        }
    }

    private void TFusernameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.ok();
        }
    }

    private void TFusernameMouseClicked(MouseEvent evt) {
        this.checkUserName();
    }

    private void TFusernameKeyReleased(KeyEvent evt) {
        this.checkUserName();
    }

    private void bOKMouseClicked(MouseEvent evt) {
        this.ok();
    }

    private void TFusernameFocusGained(FocusEvent evt) {
        this.TFusername.selectAll();
        this.checkUserName();
    }

    private void TFusernameFocusLost(FocusEvent evt) {
        this.TFusername.select(0, 0);
        this.checkUserName();
    }

    private void TFpasswordFocusLost(FocusEvent evt) {
        this.TFpassword.select(0, 0);
    }
}

