/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm;

import com.sun.ut.vdm.Background;
import com.sun.ut.vdm.I18N;
import com.sun.ut.vdm.Settings;
import com.sun.ut.vdm.api.AuthenticationResponse;
import com.sun.ut.vdm.api.ClientException;
import com.sun.ut.vdm.api.Desktop;
import com.sun.ut.vdm.api.DesktopConnectException;
import com.sun.ut.vdm.api.DesktopConnection;
import com.sun.ut.vdm.api.VDMException;
import com.sun.ut.vdm.api.VdmAPI;
import com.sun.ut.vdm.util.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VdmClient {
    private final URL waitImg = Utils.load("/aurelia12-wait.png");
    private final URL errorImg = Utils.load("/error.png");
    private VdmAPI vdmApi;
    private Background bg;
    private Settings settings;
    private boolean changingPassword = false;
    private boolean alreadyAuthenticated = false;
    private int numDesktops = 0;
    public static final String[][] replacementMessages = new String[][]{{"Unknown user name or bad password.", "USER_PASSWORD_INCORRECT"}};

    public static void main(String[] args) {
        VdmClient client = new VdmClient(args);
        client.connect();
        System.out.flush();
    }

    public VdmClient(String[] args) {
        try {
            this.settings = new Settings(args);
        }
        catch (ClientException ce) {
            Utils.log(I18N.get("LOG_MESG") + ce.getMessage());
            this.quit(2);
        }
    }

    public void connect() {
        try {
            this.vdmApi = new VdmAPI(this.settings.url);
            this.bg = new Background(this, this.settings);
            this.bg.setVisible(true);
            this.login();
        }
        catch (Exception e) {
            if (!(e instanceof ClientException) && !(e instanceof VDMException)) {
                e.printStackTrace();
            }
            Utils.log(I18N.get("LOG_MESG") + e.getMessage());
            this.quit(2);
        }
    }

    private void login() throws ClientException, VDMException {
        if (this.settings.username != null && !this.settings.username.equals("") && this.settings.password != null && !this.settings.password.equals("") && this.settings.domain != null) {
            this.handleAuth(this.vdmApi.doSubmitWindowsAuth(this.settings.username, this.settings.password, this.settings.domain));
        } else {
            this.bg.setWaitDialog(this.waitImg, I18N.get("CONNECTING_TO_VDM_SERVER") + this.settings.server);
            this.handleAuth(this.vdmApi.getAuthConfiguration());
        }
    }

    private void handleAuth(AuthenticationResponse authResp) throws ClientException, VDMException {
        String errMessage;
        AuthenticationResponse.AuthResult result = authResp.getResult();
        if (result == AuthenticationResponse.AuthResult.DONE) {
            this.alreadyAuthenticated = true;
            this.pickDesktop();
            return;
        }
        if (result == AuthenticationResponse.AuthResult.FAILED) {
            errMessage = authResp.getErrorMessage();
            if (Utils.empty(errMessage)) {
                errMessage = I18N.get("ERROR_AUTHENTICATING");
            }
            Utils.showWordWrappedMessageDialog(null, errMessage, I18N.get("ERROR"), 0, 80);
            this.quit(1);
        }
        if (!Utils.empty(errMessage = Utils.join(authResp.getParam("error"), "\n"))) {
            errMessage = this.replaceVdmErrorMessage(errMessage);
            this.bg.showError(errMessage);
        } else {
            this.bg.clearText();
        }
        AuthenticationResponse.AuthType type = authResp.getType();
        if (type == AuthenticationResponse.AuthType.DISCLAIMER) {
            boolean ok = this.bg.showDisclaimer(Utils.join(authResp.getParam("text"), ""));
            if (!ok) {
                this.quit(1);
            }
            this.handleAuth(this.vdmApi.submitDisclaimer());
        } else if (type == AuthenticationResponse.AuthType.WINDOWS_PASSWORD) {
            if (!this.changingPassword) {
                this.bg.closeWaitDialog();
                this.settings.domains = new LinkedList<String>(authResp.getParam("domain"));
                this.bg.showLoginDialog(this.settings.username, this.settings.password, this.settings.domains, this.settings.domain);
            } else if (this.changingPassword && !Utils.empty(errMessage)) {
                this.bg.disableChangePasswordOk();
            }
        } else if (type == AuthenticationResponse.AuthType.WINDOWS_PASSWORD_EXPIRED) {
            this.bg.showChangePasswordDialog(this.settings.username);
            this.changingPassword = true;
        } else {
            throw new ClientException(I18N.get("UNSUPPORTED_AUTH_TYPE") + (Object)((Object)type));
        }
    }

    public void submitAuth(String username, String password, String domain) throws ClientException, VDMException {
        if (this.alreadyAuthenticated) {
            try {
                this.vdmApi.logout();
                this.alreadyAuthenticated = false;
            }
            catch (Exception e) {
                Utils.showWordWrappedMessageDialog(null, I18N.get("AUTH_RESTART"), "", 0, 80);
                Utils.logout(null, this);
            }
        }
        this.settings.username = username;
        this.settings.domain = domain;
        this.settings.password = password;
        this.handleAuth(this.vdmApi.doSubmitWindowsAuth(username, password, domain));
    }

    public void changePassword(String pass1, String pass2) throws ClientException, VDMException {
        this.handleAuth(this.vdmApi.doSubmitNewPassword(this.settings.password, pass1, pass2));
    }

    private void pickDesktop() throws ClientException, VDMException {
        List<Desktop> desktops = this.getDesktops();
        this.numDesktops = desktops.size();
        if (desktops.size() == 1 && this.getAutoPickDesktop()) {
            try {
                this.connectToDesktop(desktops.get(0));
                Utils.logout(null, this);
            }
            catch (Exception ex) {
                Utils.log(I18N.get("LOG_MESG") + ex.getMessage());
                Utils.showWordWrappedMessageDialog(null, ex.getMessage(), I18N.get("ERROR"), 0, 80);
                this.quit(2);
            }
        } else {
            String msg = String.format(I18N.get("SELECTOR_MSG"), this.settings.username);
            this.bg.showDesktopPicker(msg, desktops, this.settings.timeOut);
        }
    }

    public List<Desktop> getDesktops() throws ClientException, VDMException {
        return this.vdmApi.getDesktopList();
    }

    public void connectToDesktop(Desktop desktop) throws DesktopConnectException, ClientException, VDMException {
        DesktopConnection conn = this.vdmApi.getDesktopConnection(desktop);
        if (!Utils.iCompare(conn.protocol, "RDP")) {
            throw new DesktopConnectException(I18N.get("UNSUPPORTED_RDP_PROTOCOL") + conn.protocol);
        }
        int exitCode = 0;
        try {
            exitCode = Utils.startRDP(this.settings.uttsc, conn.address, conn.port, conn.username, conn.password, conn.domain, this.settings.uttscArgs);
        }
        catch (IOException e) {
            throw new DesktopConnectException(I18N.get("ERROR_CONNECTING_TO_DESKTOP") + e.getMessage());
        }
        if (exitCode != 0) {
            Utils.log(I18N.get("UTTSC_EXITCODE_NON_ZERO") + exitCode);
        }
    }

    public void quit(int status) {
        if (this.vdmApi != null) {
            try {
                this.vdmApi.logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.exit(status);
    }

    public void setLocale(String code) {
        try {
            this.vdmApi.setLocale(code);
        }
        catch (VDMException ve) {
            Utils.log(I18N.get("LOG_MESG") + "VDMException: " + ve.getMessage());
        }
        catch (ClientException ce) {
            Utils.log(I18N.get("LOG_MESG") + "ClientException: " + ce.getMessage());
        }
    }

    private String replaceVdmErrorMessage(String err) {
        for (String[] pair : replacementMessages) {
            if (!pair[0].equals(err)) continue;
            return I18N.get(pair[1]);
        }
        return err;
    }

    public boolean usingToken() {
        return !Utils.empty(this.settings.token);
    }

    public boolean getAutoPickDesktop() {
        return this.settings.autoPickDesktop;
    }
}

