/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm.util;

import com.sun.ut.vdm.Dialog;
import com.sun.ut.vdm.I18N;
import com.sun.ut.vdm.VdmClient;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String UTTSC_PATH = "/opt/SUNWuttsc/bin/uttsc";
    public static final String SUN_RAY_TOKEN = "SUN_SUNRAY_TOKEN";
    public static final int RDP_PORT = 3389;
    public static final String HTTPS_PROTOCOL = "https";
    public static final String HTTP_PROTOCOL = "http";
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final String HTTP_HEADER_CONTENT_TYPE = "Content-type";
    public static final String HTTP_HEADER_ACCEPT = "Accept";
    public static final String HTTP_HEADER_COOKIE = "Cookie";
    public static final String HTTP_HEADER_LOCATION = "Location";
    public static final String HTTP_HEADER_SET_COOKIE = "Set-Cookie";
    public static final String CONTENT_TYPE_XML = "text/xml";
    public static final int HTTP_TEMP_REDIRECT = 307;
    public static final String HTTP_COOKIE_SEP = ";";
    public static final String XML_AMPERSAND = "&amp;";
    public static final String XML_GT = "&gt;";
    public static final String XML_LT = "&lt;";

    public static int startRDP(String uttsc, String host, String username, String password, String domain, List<String> args) throws IOException {
        return Utils.startRDP(uttsc, host, 3389, username, password, domain, args);
    }

    public static int startRDP(String uttsc, String host, int port, String username, String password, String domain, List<String> args) throws IOException {
        String[] cmd = new String[]{uttsc, "--", "-i", "-u", username, "-P", port + ""};
        LinkedList<String> command = new LinkedList<String>(Arrays.asList(cmd));
        command.addAll(args);
        boolean needLanguage = true;
        boolean needDomain = true;
        for (String s : command) {
            if (s.equals("-l")) {
                needLanguage = false;
                continue;
            }
            if (!s.equals("-d")) continue;
            needDomain = false;
        }
        if (needLanguage) {
            command.add("-l");
            command.add(Locale.getDefault().toString());
        }
        if (needDomain && !Utils.empty(domain)) {
            command.add("-d");
            command.add(domain);
        }
        command.add(host);
        ProcessBuilder pb = new ProcessBuilder(command);
        try {
            final Process process = pb.start();
            BufferedWriter pStdin = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            pStdin.write(password + "\n");
            pStdin.flush();
            pStdin.close();
            final String prefix = "Desktop of user '" + username + "': ";
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    BufferedReader pStderr = null;
                    try {
                        pStderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        String message = pStderr.readLine();
                        while (message != null) {
                            Utils.log(prefix + message);
                            message = pStderr.readLine();
                        }
                    }
                    catch (IOException io) {
                        Utils.log(prefix + "IO Error reading output of RDP session: " + io.getMessage());
                    }
                    finally {
                        if (pStderr != null) {
                            try {
                                pStderr.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
            t.run();
            process.waitFor();
            return process.exitValue();
        }
        catch (InterruptedException e) {
            return 0;
        }
    }

    public static void showWordWrappedMessageDialog(Component parent, Object message, String title, int messageType, int maxLineLength) {
        WordWrappedOptionPane pane = new WordWrappedOptionPane(maxLineLength);
        pane.setMessage(message);
        pane.setMessageType(messageType);
        JDialog dialog = pane.createDialog(parent, title);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    public static int showWordWrappedOptionDialog(Component parent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, int maxLineLength) {
        WordWrappedOptionPane pane = new WordWrappedOptionPane(maxLineLength);
        pane.setMessage(message);
        pane.setMessageType(messageType);
        pane.setOptionType(optionType);
        pane.setIcon(icon);
        pane.setOptions(options);
        pane.setInitialValue(initialValue);
        JDialog dialog = pane.createDialog(parent, title);
        dialog.setModal(true);
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals(selectedValue)) continue;
            return i;
        }
        return -1;
    }

    public static void logout(Dialog dialog, VdmClient vdmclient) {
        if (dialog != null) {
            dialog.disableForm();
            dialog.showText(I18N.get("LOGGING_OUT"));
        }
        if (vdmclient != null) {
            try {
                vdmclient.quit(1);
            }
            catch (Exception e) {
                System.exit(1);
            }
        } else {
            System.exit(1);
        }
    }

    public static void center(Component c) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Utils.center(c, screenSize.width, screenSize.height);
    }

    public static void centerFirstMonitor(Component c) {
        int[][] ratios;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width;
        int height = screenSize.height;
        for (int[] ratio : ratios = new int[][]{{4, 3}, {5, 4}, {8, 5}, {5, 3}, {16, 9}, {17, 9}}) {
            if (width / ratio[0] != height / ratio[1]) continue;
            Utils.center(c, width, height);
            return;
        }
        Utils.center(c, width / 2, height);
    }

    private static void center(Component c, int width, int height) {
        int x = (width - c.getWidth()) / 2;
        int y = (height - c.getHeight()) / 2;
        c.setLocation(x, y);
    }

    public static void useWaitCursor(JDialog dialog) {
        Utils.useWaitCursor(dialog.getContentPane());
    }

    public static void useWaitCursor(JComponent component) {
        Utils.useWaitCursor(component.getTopLevelAncestor());
    }

    public static void useWaitCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void useDefaultCursor(JDialog dialog) {
        Utils.useDefaultCursor(dialog.getContentPane());
    }

    public static void useDefaultCursor(JComponent component) {
        Utils.useDefaultCursor(component.getTopLevelAncestor());
    }

    public static void useDefaultCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    public static void log(String s) {
        System.err.println(s);
        System.err.flush();
    }

    public static String join(Collection<String> c, String sep) {
        StringBuilder s = new StringBuilder();
        Iterator<String> iter = c.iterator();
        if (c.size() >= 1) {
            for (int i = 0; i < c.size() - 1; ++i) {
                s.append(iter.next());
                s.append(sep);
            }
            s.append(iter.next());
        }
        return s.toString();
    }

    public static boolean iCompare(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(a, b) == 0;
    }

    public static String xmlEscape(String s) {
        if (s == null) {
            return "";
        }
        s = s.replaceAll("&", XML_AMPERSAND);
        s = s.replaceAll(">", XML_GT);
        s = s.replaceAll("<", XML_LT);
        return s;
    }

    public static String getEnv(String k) {
        String v = System.getenv(k);
        if (v == null) {
            v = "";
        }
        return v;
    }

    public static Node getElement(Document doc, String tag) {
        if (doc == null || Utils.empty(tag)) {
            return null;
        }
        NodeList nl = doc.getElementsByTagName(tag);
        if (nl.getLength() < 1) {
            return null;
        }
        return nl.item(0);
    }

    public static Node getElement(Node n, String tag) {
        if (n == null) {
            return null;
        }
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals(tag)) continue;
            return nl.item(i);
        }
        return null;
    }

    public static List<Node> getChildNodes(Node n, String tag) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(tag)) continue;
            nodes.add(child);
        }
        return nodes;
    }

    public static String getElementText(Document doc, String tag) {
        Node n = Utils.getElement(doc, tag);
        if (n == null) {
            return null;
        }
        return n.getTextContent();
    }

    public static String getElementText(Node n, String tag) {
        Node child = Utils.getElement(n, tag);
        if (child == null) {
            return null;
        }
        return child.getTextContent();
    }

    public static NodeList XPathEvaluateSet(XPath xpath, Document doc, String query) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(query, doc, XPathConstants.NODESET);
    }

    public static String XPathEvaluateStr(XPath xpath, Document doc, String query) throws XPathExpressionException {
        return (String)xpath.evaluate(query, doc, XPathConstants.STRING);
    }

    public static NodeList XPathEvaluateSet(XPath xpath, Node doc, String query) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(query, doc, XPathConstants.NODESET);
    }

    public static String XpathEvaluateStr(XPath xpath, Node doc, String query) throws XPathExpressionException {
        return (String)xpath.evaluate(query, doc, XPathConstants.STRING);
    }

    public static List<Node> toList(NodeList nl) {
        LinkedList<Node> v = new LinkedList<Node>();
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                v.add(nl.item(i));
            }
        }
        return v;
    }

    public static boolean toBool(String s) {
        if (s == null) {
            return false;
        }
        return Utils.iCompare(s, "true");
    }

    public static int toInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static URL load(String name) {
        return new Object().getClass().getResource(name);
    }

    private static class WordWrappedOptionPane
    extends JOptionPane {
        int maxLineLength;

        WordWrappedOptionPane(int maxLineLength) {
            this.maxLineLength = maxLineLength;
        }

        public int getMaxCharactersPerLineCount() {
            return this.maxLineLength;
        }
    }
}

