/*
 * Decompiled with CFR 0.152.
 */
package auth.module.TerminalGroup;

import auth.module.TerminalGroup.TerminalGroupClient;
import auth.protocol.RegisterKeys;
import auth.sdk.AccessControl;
import auth.sdk.Authentication;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import auth.utauthd.GroupManager;
import java.util.Hashtable;

public class TerminalGroup
implements Authentication {
    private String instanceName;
    private static String version = new String("@(#) TerminalGroup.java 1.8@(#)");
    private static String name = new String("TerminalGroup");

    public static Authentication getAuthenticationObject(String instanceName, String opt) {
        TerminalGroup za = new TerminalGroup(instanceName, opt);
        return za;
    }

    public TerminalGroup() {
    }

    private static void usage(String message) {
        System.exit(1);
    }

    public TerminalGroup(String instanceName, String arg) {
        this.instanceName = instanceName;
    }

    public String getName() {
        return new String(this.instanceName);
    }

    public String getVersion() {
        if (version.equals("%A%")) {
            version = "Development";
        }
        return version;
    }

    public AuthenticationClient isMyTokenType(Hashtable attrib, AccessControl access) {
        Hashtable<String, String> message = new Hashtable<String, String>();
        String event = (String)attrib.get("event");
        String cause = (String)attrib.get("cause");
        String ipa = (String)attrib.get("terminalIPA");
        String type = (String)attrib.get("type");
        if (type == null) {
            type = "noType";
        }
        String tid = (String)attrib.get("id");
        Log.debug((String)("TerminalGroup: isMyTokenType: tid=" + tid));
        String id = access.getTerminalId();
        if (id == null) {
            return null;
        }
        Log.debug((String)("TerminalGroup: isMyTokenType: id=" + id));
        if (!event.equals("insert")) {
            return null;
        }
        String primary = access.getPrimaryId();
        if (primary == null) {
            return null;
        }
        if (primary.equals(id)) {
            attrib.put("isTerminalGroupPrimary", "true");
            return null;
        }
        TerminalGroupClient client = new TerminalGroupClient(access, this, id, primary);
        if (client == null) {
            Log.notice((String)"TerminalGroup: could not instantiate client");
            return null;
        }
        Log.debug((String)(this.instanceName + ": accept " + id));
        boolean islocal = false;
        try {
            islocal = access.addSecondary(primary, id);
        }
        catch (Exception e) {
            Log.notice((String)e.getMessage());
            access.disconnect("destroy");
        }
        if (!islocal) {
            if (!access.isGroupManagerEnabled()) {
                client.isOrphan();
            } else {
                String where = GroupManager.findPrimary((String)primary, (String)ipa);
                Log.notice((String)("findTerminal " + id + ": " + where));
                if (where == null || where.length() == 0) {
                    client.isOrphan();
                } else if (where.equals("localhost")) {
                    client.isOrphan();
                } else {
                    client.isRedir();
                    message.put("authipa", where);
                    message.put("authport", access.getAuthPort().toString());
                    message.put("realType", type);
                    message.put("realId", tid);
                    message.put("redirectProps", RegisterKeys.subCauseKey + "=" + "waitForPrimary");
                    access.cleanUpOnRedirect();
                    access.send("redirectInf", message);
                }
            }
        }
        Log.debug((String)(this.instanceName + ": accept " + type + "." + id));
        return client;
    }
}

