/*
 * ident	"@(#)utdisk.h	1.5	11/03/02 Oracle"
 *
 * Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved.
 */

#ifndef _UTDISK_H
#define	_UTDISK_H


#ifdef	SCCSID
static char *_SCCSid_ = "@(#)utdisk.h	1.5 11/03/02 Oracle";
#endif	/* defined _SCCSID */

/*
 * UTDISK: This header file describes the interface between
 * Sun Ray mass storage controller, utdiskctl, and the utdisk block driver
 */

#ifdef  __cplusplus
extern "C" {
#endif

/* includes */
#include <linux/types.h>			/* integer types */
#include <linux/version.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,26)
#include <asm/semaphore.h>			/* struct semaphore */
#else
#include <linux/semaphore.h>			/* struct semaphore */
#endif
#include <linux/blkdev.h>			/* make_request_fn */
#include <linux/cdev.h>				/* struct cdev */
#include <linux/wait.h>				/* wait_queue_head_t */
#include "utdiskctl.h"				/* minor_t */

/* macro and constant definitions */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,24)
# define bio_endio(b, s, e) bio_endio((b), (s), (e));
#else
# define bio_endio(b, s, e) bio_endio((b), (e));
#endif

#ifdef	UTDEBUG
#define	utprintf(args...)	printk(KERN_INFO args)
#define	utvalidate_dsp(dsp)	((dsp)->selfp == (dsp))
#else
#define utprintf(args...)
#define	utvalidate_dsp(dsp)	1
#endif	/* UTDEBUG */

/* main controller instance */
#define	UTDISK_MASTER_INSTANCE	0

/* minor number state flags */
#define	UTDISK_STATE_FREE	0x00
#define	UTDISK_STATE_IN_USE	0x01
#define	UTDISK_STATE_READY	0x02
#define	UTDISK_STATE_OPEN	0x04
#define	UTDISK_STATE_STALE	0x08
#define	UTDISK_STATE_CHANGED	0x10
#define	UTDISK_STATE_WRPROT	0x20

/* state access modes */
#define	UTDISK_STATE_VALIDATE         0x1
#define	UTDISK_STATE_FORCE            0x2

/* typedefs, structs and unions */

/*
 * utdisk state structure
 */
typedef struct utdisk_state_s {
	minor_t			ctlmin;		/* controller minor number */
	uint32_t		nblocks;	/* UTDISK_HARDSECT blocks */
	struct semaphore	lock;		/* lock */
	uint_t			opens;		/* # of open references */
	struct request_queue	*rqp;		/* only used by gendisk */
	struct gendisk		*gdiskp;	/* gendisk */
	struct cdev		*cdevp;		/* controller's devops */
	wait_queue_head_t	io_wq;		/* waiting for I/O requests */
	struct bio		*bio_headp;	/* I/O request list begin .. */
	struct bio		*bio_tailp;	/* .. end */
	uint_t			flags;		/* state flags */
	uid_t			owner;		/* device owner */
#ifdef	UTDEBUG
	void			*selfp;		/* ptr to self */
#endif	/* UTDEBUG */
} utdisk_state_t;


/* public function prototypes */

void		utstk_set_disk_major(major_t num);
void		utstk_set_disk_makereq(make_request_fn *mrfp);
void		utstk_set_disk_bdops(struct block_device_operations *bdopsp);
int		utstk_add_bio(struct bio *biop, utdisk_state_t *dsp);
void		utstk_free_state(utdisk_state_t *dsp);
void		utstk_check_media(utdisk_state_t *dsp,
			struct block_device *bdevp);
void		utstk_eject_media(utdisk_state_t *dsp,
			struct block_device *bdevp);
int		utstk_uscsi_cmd(utdisk_state_t *dsp,
			struct block_device *bdevp, ut_uscsi_cmd_t *cmd);

/* external variable declarations */


#ifdef __cplusplus
}
#endif	/* defined __cplusplus */

#endif	/* _UTDISK_H */
