<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id: Kiosk.jsp 1498 2011-03-08 20:25:58Z shefali $ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Kiosk.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p1:_id16:edit"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="kiosk"/>

                        <ui:pageAlert id="a1" title="#{kioskHandler.alert}" type="info"
                            detail="#{kioskHandler.alertSummary}"
                            rendered="#{kioskHandler.alertRendered}"
                            escape="false">
                            <f:facet name="pageAlertButtons">
                                <ui:button id="edit" 
                                           text="#{msg.edit_button}"
                                           primary="true"
                                           action="kioskEdit"
                                           immediate="true" 
                                           rendered="#{kioskHandler.editButtonRendered}"
                                           toolTip="#{msg.kiosk_edit_tooltip}"
                                           alt="#{msg.edit_button_alt}"/>
                            </f:facet>
                        </ui:pageAlert> 
                        
                        <ui:panelGroup rendered="#{!kioskHandler.alertRendered}">
                            <ui:alert binding ="#{kioskHandler.statusMessage.alert}"/>

                            <ui:contentPageTitle id="p1" 
                                                 title="#{msg.kiosk_pageTitle}">

                                <ui:markup tag="div" styleClass="TtlHlpDiv">
                                    <ui:helpInline id="h1" type="page"
                                                   text="#{msg.kiosk_pageHelpText}">
                                        <ui:helpWindow windowTitle="#{msg.helpWindow_title}" 
                                                       pageTitle="#{msg.helpWindow_pageTitle}"
                                                       mastheadImageUrl="/images/productName.png"
                                                       mastheadImageHeight="23"
                                                       mastheadImageWidth="420"   
                                                       helpFile="kiosk.html"
                                                       toolTip="#{msg.helpWindow_link_tooltip}"
                                                       linkIcon="true" linkText="#{msg.kiosk_help_link}" />
                                    </ui:helpInline>
                                </ui:markup> 
                                                     
                                <f:facet name="pageButtonsTop">
                                    <ui:panelGroup> 
                                        <ui:button id="edit" 
                                                   text="#{msg.edit_button}"
                                                   primary="true"
                                                   action="kioskEdit"
                                                   immediate="true" 
                                                   toolTip="#{msg.kiosk_edit_tooltip}"
                                                   alt="#{msg.edit_button_alt}"/>
                                        <ui:button id="delete" 
                                                   text="#{msg.delete_button}"
                                                   onClick="#{kioskHandler.deleteOnClick}"
                                                   action="#{kioskHandler.delete}"
                                                   immediate="true" 
                                                   toolTip="#{msg.kiosk_delete_tooltip}"
                                                   alt="#{msg.delete_button_alt}"/>
                                    </ui:panelGroup> 
                                </f:facet> 
                                <f:facet name="pageButtonsBottom">
                                    <ui:panelGroup> 
                                        <ui:button id="edit"
                                                   text="#{msg.edit_button}"
                                                   primary="true"
                                                   action="kioskEdit"
                                                   immediate="true" 
                                                   toolTip="#{msg.kiosk_edit_tooltip}"
                                                   alt="#{msg.edit_button_alt}"/>
                                        <ui:button id="delete" 
                                                   text="#{msg.delete_button}"
                                                   onClick="#{kioskHandler.deleteOnClick}"
                                                   action="#{kioskHandler.delete}"
                                                   immediate="true" 
                                                   toolTip="#{msg.kiosk_delete_tooltip}"
                                                   alt="#{msg.delete_button_alt}"/>
                                    </ui:panelGroup> 
                                </f:facet> 
                                <ui:propertySheet id="ps">
                                    <ui:propertySheetSection id="pss">
                                        <ui:property id="p1" label="#{msg.kiosk_sessionLabel}" labelAlign="right">
                                            <ui:staticText id="s1" text="#{kioskHandler.kiosk.descriptor.label}"/>
                                        </ui:property>
                                        <ui:property id="p2" label="#{msg.kiosk_timeoutLabel}" labelAlign="right">
                                            <ui:staticText id="s2" text="#{kioskHandler.kiosk.timeout}"/>
                                            <ui:staticText id="s2u" text="&#160;&#160;#{msg.kiosk_secondsUnit}" rendered="#{kioskHandler.kiosk.timeoutSet}" style="color:#999; font-size:11px;"/>
                                        </ui:property>
                                        <ui:property id="p3" label="#{msg.kiosk_maxCPULabel}" labelAlign="right">
                                            <ui:staticText id="s3" text="#{kioskHandler.kiosk.maxCPU}"/>
                                            <ui:staticText id="s3u" text="&#160;&#160;#{msg.kiosk_secondsUnit}" rendered="#{kioskHandler.kiosk.maxCPUSet}" style="color:#999; font-size:11px;"/>
                                        </ui:property>
                                        <ui:property id="p4" label="#{msg.kiosk_maxVMLabel}" labelAlign="right">
                                            <ui:staticText id="s4" text="#{kioskHandler.kiosk.maxVM}"/>
                                            <ui:staticText id="s4u" text="&#160;&#160;#{msg.kiosk_kbUnit}" rendered="#{kioskHandler.kiosk.maxVMSet}" style="color:#999; font-size:11px;"/>
                                        </ui:property>
                                        <ui:property id="p5" label="#{msg.kiosk_maxFilesLabel}" labelAlign="right">
                                            <ui:staticText id="s5" text="#{kioskHandler.kiosk.maxFiles}"/>
                                        </ui:property>
                                        <ui:property id="p6" label="#{msg.kiosk_maxFileSizeLabel}" labelAlign="right">
                                            <ui:staticText id="s6" text="#{kioskHandler.kiosk.maxFileSize}"/>
                                            <ui:staticText id="s6u" text="&#160;&#160;#{msg.kiosk_blocksUnit}" rendered="#{kioskHandler.kiosk.maxFileSizeSet}" style="color:#999; font-size:11px;"/>
                                        </ui:property>
                                        <ui:property id="p7" label="#{msg.kiosk_localeLabel}" labelAlign="right">
                                            <ui:staticText id="s7" text="#{kioskHandler.kiosk.locale}"/>
                                        </ui:property>
                                        <ui:property id="p8" label="#{msg.kiosk_argsLabel}" labelAlign="right">
                                            <ui:staticText id="s8" text="#{kioskHandler.kiosk.args}"/>
                                        </ui:property>
                                        <ui:property id="p9" label="#{msg.kiosk_applicationsLabel}" labelAlign="right" rendered="#{kioskHandler.kiosk.descriptor.launcher}">
                                            <ui:table id="t1"
                                                lite="true"
                                                selectMultipleButton="true"
                                                selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                                deselectMultipleButton="true"
                                                deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                                clearSortButton="true"
                                                summary="#{msg.kiosk_apps_table_summary}"
                                                toolTip="#{msg.kiosk_apps_table_summary}">
                                                <ui:tableRowGroup 
                                                    sourceData="#{kioskHandler.applications}"
                                                    sourceVar="kioskRowGroup"
                                                    binding="#{kioskHandler.tableRowGroup}"
                                                    selected="#{kioskHandler.selectHelper.selectedState}">
                                                    <ui:tableColumn
                                                        extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                                        <ui:checkbox 
                                                            id="select" onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                            selected="#{kioskHandler.selectHelper.selected}"
                                                            selectedValue="#{kioskHandler.selectHelper.selectedValue}"/>
                                                    </ui:tableColumn>

                                                    <!-- Application column -->
                                                    <ui:tableColumn headerText="#{msg.kiosk_application_header}" 
                                                                    rowHeader="true" 
                                                                    sort="id"
                                                                    style="width: 10em;">
                                                        <ui:hyperlink text="#{kioskRowGroup.value.label}"
                                                                      action="#{kioskHandler.selectApplication}"
                                                                      immediate="true"
                                                                      toolTip="#{msg.kiosk_apps_link_tooltip}">
                                                            <f:param name="selectedId" value="#{kioskRowGroup.value.id}"/>
                                                        </ui:hyperlink>
                                                    </ui:tableColumn>

                                                    <!-- Type column -->
                                                    <ui:tableColumn headerText="#{msg.kiosk_type_header}"
                                                                    rowHeader="true"
                                                                    sort="typeLabel"
                                                                    style="width: 2em;">
                                                        <ui:staticText text="#{kioskRowGroup.value.typeLabel}"/>
                                                        <!--ui:staticText text="#{kioskHandler.typeLabels.exec}"/-->
                                                    </ui:tableColumn>

                                                    <!-- Mode column -->
                                                    <ui:tableColumn headerText="#{msg.kiosk_mode_header}" 
                                                                    rowHeader="true" 
                                                                    sort="modeLabel"
                                                                    style="width: 2em;">
                                                        <ui:staticText text="#{kioskRowGroup.value.modeLabel}"/>
                                                        <!--ui:staticText text="#{kioskHandler.modeLabels.auto}"/-->
                                                    </ui:tableColumn>

                                                    <!-- Arguments column -->
                                                    <ui:tableColumn headerText="#{msg.kiosk_arguments_header}" 
                                                                    rowHeader="true" 
                                                                    sort="args"
                                                                    style="width: 25em;">
                                                        <ui:staticText text="#{kioskRowGroup.value.args}"/>
                                                    </ui:tableColumn>
                                                </ui:tableRowGroup>
                                                <f:facet name="actionsTop">
                                                    <f:subview id="actionsTop">
                                                        <ui:button id="new"
                                                                   disabled="false"
                                                                   text="#{msg.new_button}"
                                                                   action="kioskApplicationNew"
                                                                   immediate="true"
                                                                   toolTip="#{msg.kiosk_apps_new_tooltip}"
                                                                   alt="#{msg.new_button_alt}"/>
                                                        <ui:button id="delete"
                                                                   disabled="true"
                                                                   text="#{msg.delete_button}"
                                                                   action="#{kioskHandler.deleteApplication}"
                                                                   toolTip="#{msg.kiosk_apps_delete_tooltip}"
                                                                   alt="#{msg.delete_button_alt}"/>
                                                    </f:subview>
                                                </f:facet>
                                            </ui:table>
                                        </ui:property>

                                    </ui:propertySheetSection>
                                </ui:propertySheet>
                            </ui:contentPageTitle>
                        </ui:panelGroup>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 


