<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id: Password.jsp 1498 2011-03-08 20:25:58Z shefali $ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Util.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p1:a1:s1:p1:i1_editable_required"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="password"/>
                        <ui:alert binding ="#{passwordHandler.statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1"
                                             title="#{msg.password_pageTitle}">

                            <ui:markup tag="div" styleClass="TtlHlpDiv">
                                <ui:helpInline id="h1" type="page"
                                               text="#{msg.password_pageHelpText}">
                                    <ui:helpWindow windowTitle="#{msg.helpWindow_title}" 
                                                   pageTitle="#{msg.helpWindow_pageTitle}"
                                                   mastheadImageUrl="/images/productName.png"
                                                   mastheadImageHeight="23"
                                                   mastheadImageWidth="420"   
                                                   helpFile="password.html"
                                                   toolTip="#{msg.helpWindow_link_tooltip}"
                                                   linkIcon="true" linkText="#{msg.password_help_link}" />
                                </ui:helpInline>
                            </ui:markup> 
                                                 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup> 
                                    <ui:button 
                                        id="save_submit" 
                                        text="#{msg.save_button}" 
                                        primary="true" 
                                        action="#{passwordHandler.modify}"
                                        onClick="#{passwordHandler.onClick}"
                                        toolTip="#{msg.password_save_tooltip}"
                                        alt="#{msg.save_button_alt}"/>
                                    <ui:button 
                                        id="reset_clear" 
                                        text="#{msg.reset_button}" 
                                        reset="true"
                                        onClick="javascript: disableEditButtons(); disableClearButtons();"
                                        toolTip="#{msg.password_reset_tooltip}"
                                        alt="#{msg.reset_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <ui:propertySheet id="a1" jumpLinks="false" requiredFields="true">
                                <ui:propertySheetSection id="s1">
                                    <ui:property id="p1"
                                                 label="#{msg.password_current}" 
                                                 labelAlign="right">
                                        <ui:passwordField id="i1_editable_required"
                                                          password="#{passwordHandler.password}" 
                                                          columns="50" 
                                                          required="true"
                                                          trim="false"
                                                          onKeyUp="javascript: setTimeout('toggleNewButtons(); toggleClearButtons();', 0);"
                                                          onChange="javascript: setTimeout('toggleNewButtons(); toggleClearButtons();', 0);"
                                                          toolTip="#{msg.password_current_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p2"
                                                 label="#{msg.password_new}" 
                                                 labelAlign="right">
                                        <ui:passwordField id="i2_editable_required"
                                                          password="#{passwordHandler.newPassword}" 
                                                          columns="50" 
                                                          required="true"
                                                          trim="false"
                                                          onKeyUp="javascript: setTimeout('toggleNewButtons(); toggleClearButtons();', 0);"
                                                          onChange="javascript: setTimeout('toggleNewButtons(); toggleClearButtons();', 0);"
                                                          toolTip="#{msg.password_new_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p3"
                                                 label="#{msg.password_confirmed}" 
                                                 labelAlign="right">
                                        <ui:passwordField id="i3_editable_required"
                                                          password="#{passwordHandler.confirmPassword}" 
                                                          columns="50" 
                                                          required="true"
                                                          trim="false"
                                                          onKeyUp="javascript: setTimeout('toggleNewButtons(); toggleClearButtons();', 0);"
                                                          onChange="javascript: setTimeout('toggleNewButtons(); toggleClearButtons();', 0);"
                                                          toolTip="#{msg.password_confirmed_tooltip}"/>
                                    </ui:property>
                                </ui:propertySheetSection>
                            </ui:propertySheet>
                        </ui:contentPageTitle>
                        <ui:script>
                            <f:verbatim>
                                initValues();
                                toggleNewButtons();
                                toggleClearButtons();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root>


