<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id: Policy.jsp 1498 2011-03-08 20:25:58Z shefali $ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}" />
                    <ui:script url="../../js/Policy.js"/>
                    <ui:script url="../../js/Util.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                    <f:verbatim>
                        <style type="text/css">
                            .RbGrp label {vertical-align: -2px;}
                        </style>
                    </f:verbatim>
                </ui:head>
                <ui:body focus="f1:p1:policyTabPropSheet:cardSection:accessCardProp:accessCard_editable:accessCard_editable_0"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="policy"/>
                        <ui:alert binding ="#{policyHandler.statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.policy_title}">

                            <ui:markup tag="div" styleClass="TtlHlpDiv">
                                <ui:helpInline id="h1" type="page"
                                               text="#{msg.policy_title_help}">
                                    <ui:helpWindow windowTitle="#{msg.helpWindow_title}" 
                                                   pageTitle="#{msg.helpWindow_pageTitle}"
                                                   mastheadImageUrl="/images/productName.png"
                                                   mastheadImageHeight="23"
                                                   mastheadImageWidth="420"   
                                                   helpFile="policy.html"
                                                   toolTip="#{msg.helpWindow_link_tooltip}"
                                                   linkIcon="true" linkText="#{msg.policy_help_link}" />
                                </ui:helpInline>
                            </ui:markup> 
                                                 
                             <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="save_submit"
                                               text="#{msg.save_button}" 
                                               primary="true"
                                               action="#{policyHandler.modify}"
                                               toolTip="#{msg.policy_save_tooltip}"
                                               alt="#{msg.save_button_alt}"/>
                                    <ui:button id="reset_submit"
                                               text="#{msg.reset_button}"
                                               onClick="resetValues(); disableElements(); initValues(); toggleEditButtons(); return false"
                                               toolTip="#{msg.policy_reset_tooltip}"
                                               alt="#{msg.reset_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                           <f:facet name="pageButtonsBottom">
                                <ui:panelGroup> 
                                    <ui:button id="save_submit"
                                               text="#{msg.save_button}"
                                               primary="true"
                                               action="#{policyHandler.modify}"
                                               toolTip="#{msg.policy_save_tooltip}"
                                               alt="#{msg.save_button_alt}"/>
                                    <ui:button id="reset_submit"
                                               text="#{msg.reset_button}"
                                               onClick="resetValues(); disableElements(); initValues(); toggleEditButtons(); return false"
                                               toolTip="#{msg.policy_reset_tooltip}"
                                               alt="#{msg.reset_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            
                            <ui:propertySheet id="policyTabPropSheet" 
                                              jumpLinks="false" >
                                
                                <!-- Card user section -->
                                <ui:propertySheetSection id="cardSection" 
                                                         label="#{msg.policy_card_section}">
                                    <ui:property id="accessCardProp" 
                                                 label="#{msg.policy_access_label}"
                                                 labelAlign="right"
                                                 noWrap="true"
                                                 overlapLabel="false">                                        
                                        <ui:radioButtonGroup id="accessCard_editable"
                                                             style="vertical-align: 3px !important;"
                                                             items="#{policyHandler.accessOptions}"
                                                             columns="1"
                                                             selected="#{policyHandler.smartCardAccess}"
                                                             onClick="javascript: disableElements(); toggleEditButtons();"
                                                             toolTip="#{msg.policy_card_access_tooltip}"/>
                                        <ui:staticText text="&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;" escape="false"/>                                      
                                        <ui:checkbox id="selfRegistrationAllowedCard_editable"
                                                     label="#{msg.policy_selfreg_allowed_label}"
                                                     selected="#{policyHandler.smartCardSelfRegistration}"
                                                     onClick="javascript: syncUnixAuthByParent(); disableElements(); toggleEditButtons();"
                                                     toolTip="#{msg.policy_selfreg_card_allowed_tooltip}"/>
                                        <f:verbatim><br /></f:verbatim>
                                        <ui:staticText text="&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;" escape="false"/>
                                        <ui:staticText text="&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;" escape="false"/>
                                        <ui:checkbox id="unixAuthenticationRequired_editable"
                                                     label="#{msg.policy_selfreg_auth_required_label_post}"
                                                     selected="#{policyHandler.cardUnixAuthentication}"
                                                     onClick="javascript: syncUnixAuth(this.checked); disableElements(); toggleEditButtons();"
                                                     toolTip="#{msg.policy_selfreg_auth_required_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="softclientCardProp"
                                                 noWrap="true"
                                                 label="#{msg.policy_softclient_label}"
                                                 labelAlign="right"
                                                 overlapLabel="false"
                                                 helpText="#{msg.policy_softclient_help}">
                                        <ui:checkbox id="softclientCard_editable"
                                                     label="#{msg.server_LAN_enabled}"
                                                     selected="#{policyHandler.smartCardSoftclientEnabled}"
                                                     onClick="disableElements(); toggleEditButtons();"
                                                     toolTip="#{msg.policy_card_softclient_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="kioskCardProp"
                                                 noWrap="true"
                                                 label="#{msg.policy_kiosk_label}"
                                                 labelAlign="right"
                                                 rendered="#{policyHandler.kioskConfigured}"
                                                 helpText="#{msg.policy_kiosk_help}">
                                        <ui:checkbox id="kioskCard_editable"
                                            label="#{msg.server_LAN_enabled}"
                                            selected="#{policyHandler.smartCardKiosk}"
                                            onClick="disableElements(); toggleEditButtons();" 
                                            toolTip="#{msg.policy_card_kiosk_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="cardBreak" noWrap="true" overlapLabel="false">
                                        <f:verbatim><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>

                                <!-- Non-card user section -->
                                <ui:propertySheetSection id="nonCardSection"
                                                         label="#{msg.policy_noncard_section}">
                                    <ui:property id="accessPseudoProp"
                                                 noWrap="true"
                                                 label="#{msg.policy_access_label}"
                                                 labelAlign="right"
                                                 overlapLabel="false">
                                        <ui:radioButtonGroup id="accessPseudo_editable"
                                                             items="#{policyHandler.accessOptions}"
                                                             columns="1"
                                                             selected="#{policyHandler.nonSmartCardAccess}"
                                                             onClick="javascript: disableElements(); toggleEditButtons();"
                                                             toolTip="#{msg.policy_noncard_access_tooltip}"/>
                                        <ui:staticText text="&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;" escape="false"/>
                                        <ui:checkbox id="selfRegistrationAllowedPseudo_editable"
                                                     label="#{msg.policy_selfreg_allowed_label}" 
                                                     selected="#{policyHandler.nonSmartCardSelfRegistration}"
                                                     onClick="syncUnixAuthByParent(); disableElements(); toggleEditButtons();"
                                                     toolTip="#{msg.policy_selfreg_noncard_allowed_tooltip}"/> 
                                        <f:verbatim><br /></f:verbatim>
                                        <ui:staticText text="&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;" escape="false"/>
                                        <ui:staticText text="&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;" escape="false"/>
                                        <ui:checkbox id="unixAuthenticationRequired_editable"
                                                     label="#{msg.policy_selfreg_auth_required_label_post}"
                                                     selected="#{policyHandler.nonCardUnixAuthentication}"
                                                     onClick="syncUnixAuth(this.checked); disableElements(); toggleEditButtons();"
                                                     toolTip="#{msg.policy_selfreg_auth_required_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="softclientPseudoProp"
                                                 noWrap="true"
                                                 label="#{msg.policy_softclient_label}"
                                                 labelAlign="right"
                                                 overlapLabel="false"
                                                 helpText="#{msg.policy_softclient_help}">
                                        <ui:checkbox id="softclientPseudo_editable"
                                                     label="#{msg.server_LAN_enabled}"
                                                     selected="#{policyHandler.nonSmartCardSoftclientEnabled}"
                                                     onClick="disableElements(); toggleEditButtons();"
                                                     toolTip="#{msg.policy_noncard_softclient_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="kioskPseudoProp"
                                                 noWrap="true"
                                                 label="#{msg.policy_kiosk_label}"
                                                 labelAlign="right"
                                                 rendered="#{policyHandler.kioskConfigured}"
                                                 overlapLabel="false"
                                                 helpText="#{msg.policy_kiosk_help}">
                                        <ui:checkbox id="kioskPseudo_editable"
                                                     label="#{msg.server_LAN_enabled}"
                                                     selected="#{policyHandler.nonSmartCardKiosk}"
                                                     onClick="disableElements(); toggleEditButtons();"
                                                     toolTip="#{msg.policy_noncard_kiosk_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="mobileSessionsEnabledProp"
                                                 noWrap="true"
                                                 label="#{msg.policy_noncard_mobile_sessions_label}"
                                                 labelAlign="right"
                                                 rendered="#{policyHandler.nscmSupported}"
                                                 overlapLabel="false"
                                                 helpText="#{msg.policy_kiosk_help}">
                                        <ui:checkbox id="mobileSessionsEnabled_editable"
                                                     label="#{msg.server_LAN_enabled}"
                                                     selected="#{policyHandler.nscmEnabled}"
                                                     onClick="disableElements(); handleMobileSessionsChange(); toggleEditButtons();"
                                                     toolTip="#{msg.policy_noncard_mobile_sessions_tooltip}"/>
                                        <f:verbatim><br /></f:verbatim>
                                        <ui:staticText id="helpExitEnabled" styleClass="HlpFldTxt" text="#{msg.policy_noncard_exit_mobile_sessions_help}" />
                                    </ui:property>
                                    <ui:property id="exitMobileSessionsAllowedProp"
                                                 noWrap="true"
                                                 rendered="#{policyHandler.nscmSupported}" overlapLabel="false">
                                        <ui:staticText text="&#160;&#160;&#160;&#160;&#160;&#160;" escape="false"/>
                                        <ui:checkbox id="exitMobileSessionsAllowed_editable"
                                                     label="#{msg.policy_noncard_exit_mobile_sessions_label}"
                                                     selected="#{policyHandler.nscmExitAllowed}"
                                                     onClick="disableElements(); toggleEditButtons();"
                                                     toolTip="#{msg.policy_noncard_exit_mobile_sessions_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="noncardBreak" noWrap="true" overlapLabel="false">
                                        <f:verbatim><br /></f:verbatim>
                                    </ui:property>  
                                </ui:propertySheetSection>
                                
                                <!-- Client authentication access section -->
                                <ui:propertySheetSection id="clientAuthAccessSection"
                                                         label="#{msg.policy_client_auth_access_section}">
                                    <ui:property id="clientAuthAccessProp"
                                                 noWrap="true"
                                                 label="#{msg.policy_client_auth_access_label}"
                                                 labelAlign="right"
                                                 overlapLabel="false">
                                        <ui:checkbox id="clientAuthAccess_editable"
                                                     label="#{msg.policy_client_auth_access_confirm}" 
                                                     selected="#{policyHandler.clientAuthConfirmRequired}"
                                                     onClick="toggleEditButtons();"
                                                     toolTip="#{msg.policy_client_auth_access_confirm_tooltip}"/>
                                        <f:verbatim><br/><br/></f:verbatim>                                                     
                                    </ui:property>
                                </ui:propertySheetSection>
                                
                                <!-- Multihead section -->
                                <ui:propertySheetSection id="multiheadSection"
                                                         label="#{msg.policy_multihead_section}">
                                    <ui:property id="multiheadAllowedProp"
                                                 noWrap="true"
                                                 label="#{msg.policy_multihead_allowed_label}"
                                                 labelAlign="right"
                                                 overlapLabel="false">
                                        <ui:checkbox id="multiheadAllowed_editable"
                                                     label="#{msg.server_LAN_enabled}" 
                                                     selected="#{policyHandler.multiheadEnabled}"
                                                     onClick="toggleEditButtons();"
                                                     toolTip="#{msg.policy_multihead_allowed_tooltip}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>
                                
                                <!-- Legacy direct session access section -->
                                <ui:propertySheetSection id="directAccessSection"
                                                         label="#{msg.policy_directAccess_section}">
                                    <ui:property id="directAccessProp"
                                                 noWrap="true"
                                                 label="#{msg.policy_directAccess_allowed_label}"
                                                 labelAlign="right"
                                                 overlapLabel="false"
                                                 helpText="#{msg.policy_directAccess_help}">
                                        <ui:checkbox id="directAccess_editable"
                                                     label="#{msg.policy_directAccess_enabled}" 
                                                     selected="#{policyHandler.directSessionAccessEnabled}"
                                                     onClick="toggleEditButtons();"
                                                     toolTip="#{msg.policy_directAccess_allowed_tooltip}"/>
                                    </ui:property>
                                </ui:propertySheetSection> 
                            </ui:propertySheet> 
                            <ui:hiddenField id="originalValues" value="" />
                        </ui:contentPageTitle>
                        <f:verbatim><br/><br/><br/><br/></f:verbatim>
                        <ui:script>
                            <f:verbatim>
                                disableElements();
                                setOriginalValues();
                                initValues();
                                toggleEditButtons();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root>


