<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id: ServerDetails.jsp 1501 2011-04-04 23:10:54Z shefali $ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:meta httpEquiv="REFRESH" content="2" rendered="#{serverDetails.restartInProgress}"/>
                    <ui:script url="../../js/Servers.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p1:_id32:back"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="servers"/>
                        <ui:alert binding ="#{serverDetails.statusMessage.alert}"/>
                         
                        <ui:breadcrumbs>
                            <ui:hyperlink text="#{msg.breadcrump_link_all_servers}" 
                                          action="viewServers" 
                                          immediate="true"
                                          toolTip="#{msg.dtu_breadcrump_all_servers_tooltip}"/>
                            <ui:hyperlink text="#{serverDetails.name}"
                                          toolTip="#{msg.dtu_id_link_tooltip}"/>
                        </ui:breadcrumbs>
                        <ui:panelGroup rendered="#{serverDetails.host.restartStatus == 'restarting'}">               
                            <ui:markup tag="table" extraAttributes="cellpadding='2' width='100%'">
                               <ui:markup tag="tr">
                                    <ui:markup tag="td" extraAttributes="align='center'">
                                        <ui:staticText text="#{msg.server_restart_in_progress}"/>
                                    </ui:markup>
                               </ui:markup>
                               <ui:markup tag="tr">
                                    <ui:markup tag="td" extraAttributes="align='center'">
                                        <ui:image id="progressBar" 
                                                  url="/images/barberpole.gif" 
                                                  alt="#{msg.server_restart_in_progress_image}" 
                                                  width="192"
                                                  height="16"
                                                  toolTip="#{msg.server_restart_in_progress_image}" />
                                    </ui:markup>
                               </ui:markup>
                               <ui:markup tag="tr">
                                    <ui:markup tag="td" extraAttributes="align='center'">
                                        <ui:staticText text="#{msg.server_restart_elapsed_time} "/>
                                        <ui:staticText text="#{serverDetails.elapsedTime}"/>  
                                        <ui:staticText text=" #{msg.server_restart_elapsed_time_unit}"/>
                                    </ui:markup>
                               </ui:markup>
                            </ui:markup>
                        </ui:panelGroup>                      
                        <ui:contentPageTitle id="p1" 
                                             title="#{serverDetails.name} - #{msg.serverDetails_pageTitle}"
                                             helpText="#{msg.serverDetails_pageHelpText}">
                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="back"
                                               text="#{msg.server_back_button}"
                                               action="viewServers"
                                               immediate="true"
                                               toolTip="#{msg.server_back_to_server_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup>
                                    <ui:button id="back" 
                                               text="#{msg.server_back_button}"
                                               action="viewServers" 
                                               immediate="true"
                                               toolTip="#{msg.server_back_to_server_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet>
                            <ui:markup tag="div" styleClass="ConMgn">
                                <f:verbatim><br/></f:verbatim>
                                <ui:button id="warmRestart"
                                           text="#{msg.server_warm_restart_button}"
                                           primary="true"
                                           onClick="#{serverDetails.warmRestartOnClick}"
                                           action="#{serverDetails.warmRestart}"
                                           disabled="#{serverDetails.host.restartStatus == 'restarting'}"
                                           toolTip="#{msg.server_warm_restart_tooltip}"
                                           alt="#{msg.server_warm_restart_alt}"/>
                                <ui:button id="coldRestart"
                                           text="#{msg.server_cold_restart_button}"
                                           onClick="#{serverDetails.coldRestartOnClick}"
                                           action="#{serverDetails.coldRestart}"
                                           disabled="#{serverDetails.host.restartStatus == 'restarting'}"
                                           toolTip="#{msg.server_cold_restart_tooltip}"
                                           alt="#{msg.server_cold_restart_alt}"/>
                            </ui:markup>  
                            
                            <ui:propertySheet id="a1" jumpLinks="false">

                                <!-- General section -->
                                <ui:propertySheetSection id="s1" 
                                                         label="#{msg.serverDetails_general_section}">
                                    <ui:property id="p1"
                                                 label="#{productInfo.softwareName}:"
                                                 labelAlign="right"
                                                 rendered="#{serverDetails.localHost}">
                                        <ui:staticText id="i0" text="#{msg.serverDetails_version_label}"/> 
                                        <ui:staticText text="&#160;" escape="false"/>
                                        <ui:staticText id="i1" text="#{productInfo.softwareVersion}"/>
                                        <ui:staticText text="&#160;&#160;" escape="false"/>
                                        <ui:hyperlink id="l1" 
                                                      toolTip="#{msg.serverDetails_package_link_tooltip}"
                                                      action="viewInstalledPackages"
                                                      immediate="true"> 
                                            <ui:image icon="HREF_LINK"/>
                                            <ui:staticText text="&#160;" escape="false"/> 
                                            <ui:staticText text="#{msg.serverDetails_package_link}"/>
                                        </ui:hyperlink>
                                    </ui:property>
                                    <ui:property id="p2"
                                                 label="#{msg.serverDetails_IP_address}"
                                                 labelAlign="right">
                                        <ui:staticText id="i2"
                                                       text="#{serverDetails.host.primaryAddress}"/>
                                    </ui:property>
                                    <ui:property id="p3"
                                                 label="#{msg.serverDetails_type}"
                                                 labelAlign="right">
                                        <ui:staticText id="i3" 
                                                       text="#{serverDetails.host.type}"/>
                                    </ui:property>
                                    <ui:property id="p4"
                                                 label="#{msg.serverDetails_mode}"
                                                 labelAlign="right">
                                        <ui:staticText id="i4"
                                                       text="#{msg.server_online_mode}"
                                                       rendered="#{!serverDetails.host.offline}"/>
                                        <ui:staticText id="i41"
                                                       text="#{msg.server_offline_mode}"
                                                       rendered="#{serverDetails.host.offline}"/> 
                                    </ui:property>
                                    <ui:property id="p5"
                                                 label="#{msg.serverDetails_LAN}"
                                                 labelAlign="right">
                                        <ui:staticText id="i5"
                                                       text="#{msg.server_LAN_enabled}" 
                                                       rendered="#{serverDetails.host.enabledLAN}"/>
                                        <ui:staticText id="i51"
                                                       text="#{msg.server_LAN_disabled}" 
                                                       rendered="#{!serverDetails.host.enabledLAN}"/>
                                    </ui:property>
                                    <ui:property id="pc"
                                                 label="#{msg.serverDetails_network_label2}"
                                                 labelAlign="right">
                                        <ui:hyperlink id="l2" 
                                                      toolTip="#{msg.serverDetails_network_link_tooltip}"
                                                      action="viewNetworkStatus"
                                                      immediate="true">
                                            <ui:image icon="HREF_LINK"/>
                                            <ui:staticText text="&#160;" escape="false"/> 
                                            <ui:staticText text="#{msg.serverDetails_network_link}"/>
                                        </ui:hyperlink>
                                    </ui:property>
                                    <ui:property id="p6"
                                                 label="#{msg.serverDetails_start}"
                                                 labelAlign="right">
                                        <ui:staticText id="i6"
                                                       text="#{serverDetails.host.startTime}" />
                                        <f:verbatim><br/><br/></f:verbatim>               
                                    </ui:property>
                                </ui:propertySheetSection>

                                <!-- Status section -->    
                                <ui:propertySheetSection id="s2"
                                                         label="#{msg.serverDetails_status_section}">
                                    <ui:property id="p1"
                                                 label="#{msg.serverDetails_dtus}"
                                                 labelAlign="right">
                                        <ui:staticText id="i1"
                                                       text="#{serverDetails.totalDtus}"/>
                                        <ui:staticText text="&#160;&#160;" escape="false"/>
                                        <ui:hyperlink id="l1"
                                                      toolTip="#{msg.serverDetails_dtus_link_tooltip}"
                                                      action="#{serverDetails.showDTUs}"
                                                      immediate="true"
                                                      rendered="#{serverDetails.totalDtus > 0}">
                                            <ui:image icon="HREF_LINK"/>
                                            <ui:staticText text="&#160;" escape="false"/> 
                                            <ui:staticText text="#{msg.serverDetails_dtus_link}"/>
                                        </ui:hyperlink>
                                    </ui:property>
                                    <ui:property id="p2" 
                                                 label="#{msg.serverDetails_sessions}"
                                                 labelAlign="right">
                                        <ui:staticText id="i2"
                                                       text="#{serverDetails.totalUserSessions}"/>
                                        <ui:staticText text="&#160;&#160;" escape="false"/>
                                        <ui:hyperlink id="l1"
                                                      toolTip="#{msg.serverDetails_sessions_link_tooltip}"
                                                      action="viewServerSessions"
                                                      immediate="true"
                                                      rendered="#{serverDetails.totalUserSessions > 0}">
                                            <ui:image icon="HREF_LINK"/>
                                            <ui:staticText text="&#160;" escape="false"/> 
                                            <ui:staticText text="#{msg.serverDetails_sessions_link}"/>
                                        </ui:hyperlink>
                                    </ui:property>
                                    <ui:property id="p3"
                                                 label="#{msg.serverDetails_users}"
                                                 labelAlign="right">
                                        <ui:staticText id="i3"
                                                       text="#{serverDetails.userSessions}"/>
                                    </ui:property>

                                    <ui:property id="p4"
                                                 label="#{msg.serverDetails_idle_sessions}"
                                                 labelAlign="right">
                                        <ui:staticText id="i4" 
                                                       text="#{serverDetails.totalGreeterSessions}"/>
                                        <ui:staticText text="&#160;&#160;" escape="false"/>
                                        <ui:hyperlink id="l1"
                                                      toolTip="#{msg.serverDetails_sessions_link_tooltip}"
                                                      action="viewServerSessions"
                                                      immediate="true"
                                                      rendered="#{(serverDetails.totalUserSessions == 0) 
                                                                and (serverDetails.totalGreeterSessions > 0)}">
                                            <ui:image icon="HREF_LINK"/>
                                            <ui:staticText text="&#160;" escape="false"/> 
                                            <ui:staticText text="#{msg.serverDetails_sessions_link}"/>
                                        </ui:hyperlink>               
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>

                                <!-- System section -->
                                <ui:propertySheetSection id="s3" 
                                                         label="#{msg.serverDetails_sysinfo}"
                                                         rendered="#{serverDetails.localHost}">
                                    <ui:property id="p1"
                                                 label="#{msg.serverDetails_os}"
                                                 labelAlign="right">
                                        <ui:staticText id="i1"
                                                       text="#{serverDetails.operatingSystem}"/>
                                    </ui:property>
                                    <ui:property id="p2"
                                                 label="#{msg.serverDetails_disk_space}"
                                                 labelAlign="right">
                                        <ui:table id="t1" lite="true"
                                                  summary="#{msg.server_disk_space_table_summary}"
                                                  toolTip="#{msg.server_disk_space_table_tooltip}">
                                            <ui:tableRowGroup sourceData="#{serverDetails.diskSpaceInfo}"
                                                              sourceVar="spaceInfo">
                                                <ui:tableColumn headerText="#{msg.serverDetails_description_header}" 
                                                                rowHeader="true"
                                                                style="width: 15em;">
                                                    <ui:staticText text="#{spaceInfo.value.description}"/>
                                                </ui:tableColumn>
                                                <ui:tableColumn headerText="#{msg.serverDetails_total_header}" 
                                                                rowHeader="true"
                                                                style="width: 8em;">
                                                    <ui:staticText text="#{spaceInfo.value.total}"/>
                                                </ui:tableColumn>
                                                <ui:tableColumn headerText="#{msg.serverDetails_used_header}" 
                                                                rowHeader="true"
                                                                style="width: 8em;">
                                                    <ui:staticText text="#{spaceInfo.value.used}"/>
                                                </ui:tableColumn>
                                                <ui:tableColumn headerText="#{msg.serverDetails_available_header}" 
                                                                rowHeader="true"
                                                                style="width: 8em;">
                                                    <ui:staticText text="#{spaceInfo.value.available}"/>
                                                </ui:tableColumn>
                                                <ui:tableColumn headerText="#{msg.serverDetails_graph_column}"
                                                                rowHeader="false"
                                                                style="width: 20em;">

                                                    <ui:staticText text="#{spaceInfo.value.chart}"
                                                                   escape="false"/>
                                                </ui:tableColumn>
                                            </ui:tableRowGroup>
                                        </ui:table>
                                    </ui:property>

                                </ui:propertySheetSection>
                            </ui:propertySheet>
                        </ui:contentPageTitle>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 
