<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id$ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. -->
  
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Sessions.js"/>            
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p1:z1"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="sessions"/>
                        <ui:alert binding ="#{searchedSessions.statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.sessions_search_pageTitle}" 
                                             helpText="#{msg.sessions_search_pageHelpText}">

                            <ui:markup tag="div" styleClass="ConMgn">

                                <f:verbatim><br/></f:verbatim>
                                <ui:dropDown id="z1"
                                             items="#{sessionSearchCriteria.options}" 
                                             selected="#{sessionSearchCriteria.filter}"
                                             toolTip="#{msg.dtu_searchCriteria_options_tooltip}"/>
                                <ui:textField id="z2"
                                              text="#{sessionSearchCriteria.searchString}" 
                                              columns="40"
                                              toolTip="#{msg.dtu_searchCriteria_searchString_tooltip}"/>
                                <ui:staticText text="&#160;" escape="false"/>
                                <ui:button id="search"
                                           text="#{msg.search_button}"
                                           action="#{searchedSessions.search}"
                                           primary="true"
                                           toolTip="#{msg.dtu_search_button_tooltip}"
                                           alt="#{msg.search_button_alt}"/>
                                <f:verbatim><br/><br/></f:verbatim>
                                <ui:label text="#{msg.search_criteria}"/>
                                <ui:staticText id="s1" text="#{sessionSearchCriteria.description}"/> 
                                <ui:staticText text="&#160;" escape="false"/>
                                <ui:button id="b1"
                                           text="#{msg.reset_search_button}"
                                           action="viewSessions"
                                           toolTip="#{msg.dtu_reset_search_tooltip}"
                                           alt="#{msg.reset_search_button_alt}"/>
                                <f:verbatim><br/><br/></f:verbatim>

                                <ui:table id="t1"
                                          title="#{searchedSessions.title}"
                                          selectMultipleButton="true"
                                          selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          deselectMultipleButton="true"
                                          deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          clearSortButton="true"
                                          summary="#{msg.sessions_search_table_summary}"
                                          toolTip="#{msg.sessions_search_table_tooltip}">

                                    <ui:tableRowGroup headerText="#{msg.sessions_user_header}"
                                                      groupToggleButton="true"
                                                      collapsed="false"
                                                      emptyDataMsg="#{msg.sessions_no_user_sessions}"
                                                      sourceData="#{searchedSessions.userSessions}"
                                                      sourceVar="sessionRowGroup"
                                                      binding="#{searchedSessions.userSessionRowGroup}"
                                                      selected="#{searchedSessions.userSessionSelectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select" 
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{searchedSessions.userSessionSelectHelper.selected}"
                                                         selectedValue="#{searchedSessions.userSessionSelectHelper.selectedValue}"
                                                         toolTip="#{msg.sessions_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Session columns -->
                                        <jsp:directive.include file="UserSessions.jsp"/>

                                    </ui:tableRowGroup>

                                    <ui:tableRowGroup headerText="#{msg.sessions_idle_header}"
                                                      groupToggleButton="true"  
                                                      collapsed="false"
                                                      emptyDataMsg="#{msg.sessions_no_idle_sessions}"
                                                      binding="#{searchedSessions.idleSessionRowGroup}"
                                                      sourceData="#{searchedSessions.idleSessions}"
                                                      sourceVar="sessionRowGroup"
                                                      selected="#{searchedSessions.idleSessionSelectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select"
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{searchedSessions.idleSessionSelectHelper.selected}"
                                                         selectedValue="#{searchedSessions.idleSessionSelectHelper.selectedValue}"
                                                         toolTip="#{msg.sessions_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Session columns -->
                                        <jsp:directive.include file="IdleSessions.jsp"/>

                                    </ui:tableRowGroup>

                                    <f:facet name="actionsTop">
                                        <f:subview id="actionsTop">
                                            <ui:button id="terminate" 
                                                       disabled="true" 
                                                       text="#{msg.sessions_terminate_button}" 
                                                       onClick="#{searchedSessions.terminateOnClick}"
                                                       action="#{searchedSessions.terminate}"
                                                       toolTip="#{msg.sessions_terminate_button_tooltip}"
                                                       alt="#{msg.sessions_terminate_button_tooltip}"/>
                                        </f:subview>
                                    </f:facet>

                                </ui:table>

                            </ui:markup>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 


