<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id$ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">    
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>                        
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Sessions.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p1:_id20:back"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="servers"/>
                        <ui:alert binding ="#{serverSessions.statusMessage.alert}"/>
        
                        <ui:breadcrumbs>
                            <ui:hyperlink text="#{msg.breadcrump_link_all_servers}"
                                          action="viewServers"
                                          immediate="true"
                                          toolTip="#{msg.dtu_breadcrump_all_servers_tooltip}"/>
                            <ui:hyperlink text="#{serverSessions.serverName}"
                                          action="viewServerDetails"
                                          immediate="true"
                                          toolTip="#{msg.dtu_breadcrump_server_name_tooltip}"/>
                            <ui:hyperlink text="#{msg.sessions_breadcrump_link}"
                                          toolTip="#{msg.sessions_session_link_tooltip}"/>
                        </ui:breadcrumbs>
                        
                        
                        <ui:contentPageTitle id="p1" 
                                             title="#{serverSessions.serverName} #{msg.sessions_server_pageTitle}"
                                             helpText="#{msg.sessions_server_pageHelpText}">
                            
                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="back"
                                               text="#{serverSessions.backToLabel}"
                                               action="viewServerDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_back_to_server_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup>
                                    <ui:button id="back"
                                               text="#{serverSessions.backToLabel}" 
                                               action="viewServerDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_back_to_server_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet>

                            <f:verbatim><br/></f:verbatim>
                            <ui:markup tag="div" styleClass="ConMgn">

                                <ui:table id="t1"
                                          title="#{serverSessions.title}"
                                          selectMultipleButton="true"
                                          selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          deselectMultipleButton="true"
                                          deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          clearSortButton="true"
                                          summary="#{msg.sessions_server_table_summary}"

                                          toolTip="#{msg.sessions_server_table_summary}">

                                    <ui:tableRowGroup headerText="#{msg.sessions_user_header}"
                                                      groupToggleButton="true"
                                                      collapsed="false"
                                                      emptyDataMsg="#{msg.sessions_no_user_sessions}"
                                                      sourceData="#{serverSessions.userSessions}"
                                                      sourceVar="sessionRowGroup"
                                                      binding="#{serverSessions.userSessionRowGroup}"
                                                      selected="#{serverSessions.userSessionSelectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select" 
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{serverSessions.userSessionSelectHelper.selected}"
                                                         selectedValue="#{serverSessions.userSessionSelectHelper.selectedValue}"
                                                         toolTip="#{msg.sessions_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>
                                        
                                        <!-- Session columns -->
                                        <jsp:directive.include file="UserSessions.jsp"/>

                                    </ui:tableRowGroup>

                                    <ui:tableRowGroup headerText="#{msg.sessions_idle_header}"
                                                      groupToggleButton="true"  
                                                      collapsed="false"
                                                      emptyDataMsg="#{msg.sessions_no_idle_sessions}"
                                                      binding="#{serverSessions.idleSessionRowGroup}"
                                                      sourceData="#{serverSessions.idleSessions}"
                                                      sourceVar="sessionRowGroup"
                                                      selected="#{serverSessions.idleSessionSelectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select"
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{serverSessions.idleSessionSelectHelper.selected}"
                                                         selectedValue="#{serverSessions.idleSessionSelectHelper.selectedValue}"
                                                         toolTip="#{msg.sessions_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Session columns -->
                                        <jsp:directive.include file="IdleSessions.jsp"/>
                                        
                                    </ui:tableRowGroup>

                                    <f:facet name="actionsTop">
                                        <f:subview id="actionsTop">
                                            <ui:button id="terminate" 
                                                       disabled="true" 
                                                       text="#{msg.sessions_terminate_button}" 
                                                       onClick="#{serverSessions.terminateOnClick}"
                                                       action="#{serverSessions.terminate}"
                                                       toolTip="#{msg.sessions_terminate_button_tooltip}"
                                                       alt="#{msg.sessions_terminate_button_tooltip}"/>
                                        </f:subview>
                                    </f:facet>

                                </ui:table>

                            </ui:markup>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 


