<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id$ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Sessions.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p1:z1"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="sessions"/>
                        <ui:alert binding ="#{sessionList.statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.sessions_pageTitle}">
                                                 
                            <ui:markup tag="div" styleClass="TtlHlpDiv">
                                <ui:helpInline id="h1" type="page"
                                               text="#{msg.sessions_pageHelpText}">
                                    <ui:helpWindow windowTitle="#{msg.helpWindow_title}" 
                                                   pageTitle="#{msg.helpWindow_pageTitle}"
                                                   mastheadImageUrl="/images/productName.png"
                                                   mastheadImageHeight="23"
                                                   mastheadImageWidth="420"   
                                                   helpFile="sessions.html"
                                                   toolTip="#{msg.helpWindow_link_tooltip}"
                                                   linkIcon="true" linkText="#{msg.sessions_help_link}" />
                                </ui:helpInline>
                            </ui:markup>
                            
                            <ui:markup tag="div" styleClass="ConMgn">

                                <f:verbatim><br/></f:verbatim>
                                <ui:dropDown id="z1"
                                             items="#{sessionList.searchCriteria.options}" 
                                             selected="#{sessionList.searchCriteria.filter}"
                                             toolTip="#{msg.dtu_searchCriteria_options_tooltip}"/>
                                <ui:textField id="z2"
                                              text="#{sessionList.searchCriteria.searchString}" 
                                              columns="40"
                                              toolTip="#{msg.dtu_searchCriteria_searchString_tooltip}"/>
                                <ui:staticText text="&#160;" escape="false"/>
                                <ui:button id="search"
                                           text="#{msg.search_button}" 
                                           primary="true"
                                           action="#{sessionList.search}"
                                           toolTip="#{msg.dtu_search_button_tooltip}"
                                           alt="#{msg.search_button_alt}"/>
                                <f:verbatim><br/><br/></f:verbatim>

                                <ui:table id="t1"
                                          title="#{sessionList.title}"
                                          selectMultipleButton="true"
                                          selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          deselectMultipleButton="true"
                                          deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          clearSortButton="true"
                                          summary="#{msg.sessions_table_summary}"
                                          toolTip="#{msg.sessions_table_summary}">

                                    <ui:tableRowGroup headerText="#{msg.sessions_user_header}"
                                                      groupToggleButton="true"
                                                      collapsed="false"
                                                      emptyDataMsg="#{msg.sessions_no_user_sessions}"
                                                      sourceData="#{sessionList.userSessions}"
                                                      sourceVar="sessionRowGroup"
                                                      binding="#{sessionList.userSessionRowGroup}"
                                                      selected="#{sessionList.userSessionSelectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select" 
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{sessionList.userSessionSelectHelper.selected}"
                                                         selectedValue="#{sessionList.userSessionSelectHelper.selectedValue}"
                                                         toolTip="#{msg.sessions_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>
                                        
                                        <!-- Session columns -->
                                        <jsp:directive.include file="UserSessions.jsp"/>

                                    </ui:tableRowGroup>

                                    <ui:tableRowGroup headerText="#{msg.sessions_idle_header}"
                                                      groupToggleButton="true"  
                                                      collapsed="false"
                                                      emptyDataMsg="#{msg.sessions_no_idle_sessions}"
                                                      binding="#{sessionList.idleSessionRowGroup}"
                                                      sourceData="#{sessionList.idleSessions}"
                                                      sourceVar="sessionRowGroup"
                                                      selected="#{sessionList.idleSessionSelectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select"
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{sessionList.idleSessionSelectHelper.selected}"
                                                         selectedValue="#{sessionList.idleSessionSelectHelper.selectedValue}"
                                                         toolTip="#{msg.sessions_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Session columns -->
                                        <jsp:directive.include file="IdleSessions.jsp"/>
                                        
                                    </ui:tableRowGroup>

                                    <f:facet name="actionsTop">
                                        <f:subview id="actionsTop">
                                            <ui:button id="terminate" 
                                                       disabled="true" 
                                                       text="#{msg.sessions_terminate_button}" 
                                                       onClick="#{sessionList.terminateOnClick}"
                                                       action="#{sessionList.terminate}"
                                                       toolTip="#{msg.sessions_terminate_button_tooltip}"
                                                       alt="#{msg.sessions_terminate_button_tooltip}"/>
                                        </f:subview>
                                    </f:facet>

                                </ui:table>

                            </ui:markup>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 


