/*
 * Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved.
 */

/*
 * utio module Public Interface
 */
#include <linux/version.h>
#if defined(CONFIG_COMPAT) || defined(CONFIG_SPARC64) || defined(CONFIG_X86_64) || defined(CONFIG_PPC64)
#include <asm/uaccess.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,22)
#include <linux/ioctl32.h>
#endif
#include <linux/compat.h>
#endif	/* CONFIG_COMPAT */

#ifndef UTIO_H_
#define	UTIO_H__

#pragma ident	"@(#)utio.h	1.10 11/03/07 Oracle"

#ifdef _SCCSID
static char __attribute__ ((unused)) *_SCCSid_UTIO_H = "@(#)utio.h	1.10 11/03/07 Oracle";
#endif	/* defined _SCCSID */

#ifdef __cplusplus
extern "C" {
#endif	/* defined __cplusplus */

/* SLES9 doesn't have this.  Remove it when SLES9 is no longer supported. */
#ifndef DEFINE_SPINLOCK
#define DEFINE_SPINLOCK(x) spinlock_t x = SPIN_LOCK_UNLOCKED
#endif

#define	UTIO_MAGIC		0x5554494F	/* UTIO */
/* #define	PMSG_SEQ_DEBUGGING */
#ifdef	PMSG_SEQ_DEBUGGING
#define	UTIO_VERSION	0x11		/* v1.1 */
#else	/* ifndef PMSG_SEQ_DEBUGGING */
#define	UTIO_VERSION	0x10		/* v1.0 */
#endif	/* PMSG_SEQ_DEBUGGING */

/* version interpretation */
#define	UTIO_VER_MAJOR(x)	(((x) & 0xf0) >> 4)
#define	UTIO_VER_MINOR(x)	(((x) & 0x0f))

/* fixed minor numbers */
#define	UTSERIALD_MINOR		1
#define	UTPARALLELD_MINOR	2

/*
 * protocol message format - sent to/from kernel & daemon
 */

typedef union {
	struct termio tio;
	struct termios tios;
	struct winsize twsz;
	struct timeval tval;
	int intval;
	unsigned char charval;
} utio_args;

typedef struct {
	uint32_t magic;		/* UTIO magic number */
	uint32_t version;	/* UTIO_VERSION of the module */
	uint32_t msgtype;	/* UTIO_MSG_{OPEN,CLOSE,IOCTL,READ,WRITE} */
	uint32_t cmd;		/* This will contain device specific ioctls */
	utio_args args;		/* args for device specific ioctls */
	uid_t uid;		/* effective uid. only valid on open */
	uint32_t datasize;	/* No. of bytes available to read/write */
	uint32_t response;	/* Response(ACK/NACK) from the deamon for the */
				/* pending open/close/ioctl */
#ifdef	PMSG_SEQ_DEBUGGING
	uint32_t seq;		/* unique sequence number identifying msg */
#endif	/* PMSG_SEQ_DEBUGGING */
} utio_pmsg_t;

#if defined(CONFIG_COMPAT) || defined(CONFIG_SPARC64) || defined(CONFIG_X86_64) || defined(CONFIG_PPC64)

typedef struct {
	uint32_t magic;
	uint32_t version;
	uint32_t msgtype;
	uint32_t cmd;
	union compat_utio_args {
	    struct termio tio;		/* all shorts and chars - no 64-bit changes */
	    struct termios tios;	/* all ints and chars - no 64-bit changes */
	    struct winsize twsz;	/* all shorts - no 64-bit changes */
	    struct compat_timeval tval;
	    int intval;
	    unsigned char charval;
	} args;
	compat_uid_t uid;
	uint32_t datasize;
	uint32_t response;
#ifdef	PMSG_SEQ_DEBUGGING
	uint32_t seq;
#endif	/* PMSG_SEQ_DEBUGGING */
} compat_utio_pmsg_t;

/*	union compat_utio_args {		type 32/64	*/
/*	    struct termio tio;			size 18		*/
/*	    struct termios tios;		size 36		*/
/*	    struct winsize twsz;		size 8		*/
/*	    struct compat_timeval tval;		size 8/16	*/
/*	    int intval;				size 4		*/
/*	    unsigned char charval;		size 1		*/
/*	} args;					size 36/40	*/

#ifdef	PMSG_SEQ_DEBUGGING
#define	COPY_UTIO_PMSG_T(left, right)					\
		left.magic		= right.magic;			\
		left.version		= right.version;		\
		left.msgtype		= right.msgtype;		\
		left.cmd		= right.cmd;			\
		left.uid		= (compat_uid_t) right.uid;	\
		left.datasize		= right.datasize;		\
		left.response		= right.response;		\
		left.seq		= right.seq;			\
		memcpy(&left.args, &right.args,				\
		    (sizeof(left.args) < sizeof(right.args) ?  sizeof(left.args) : sizeof(right.args)));
#else	/* PMSG_SEQ_DEBUGGING */
#define	COPY_UTIO_PMSG_T(left, right)					\
		left.magic		= right.magic;			\
		left.version		= right.version;		\
		left.msgtype		= right.msgtype;		\
		left.cmd		= right.cmd;			\
		left.uid		= (compat_uid_t) right.uid;	\
		left.datasize		= right.datasize;		\
		left.response		= right.response;		\
		memcpy(&left.args, &right.args,				\
		    (sizeof(left.args) < sizeof(right.args) ?  sizeof(left.args) : sizeof(right.args)));
#endif	/* PMSG_SEQ_DEBUGGING */

#define	COPY_UTIO_PMSG_TVAL(left, right)				\
		left.tval.tv_sec	= right.tval.tv_sec;		\
		left.tval.tv_usec	= right.tval.tv_usec;

#ifdef	PMSG_SEQ_DEBUGGING
#define	DPRINTF_UTIO_PMSG(level, left, msg)				\
		DPRINTF(level,						\
		"pmsg %s(magic=0x%x, version=%d, msgtype=%d, cmd=%d, uid=%d, datasize=%d, response=%d, seq=%d)\n", \
		msg, left.magic, left.version, left.msgtype, left.cmd,	\
		left.uid, left.datasize, left.response, left.seq)
#else	/* ifndef PMSG_SEQ_DEBUGGING */
#define	DPRINTF_UTIO_PMSG(level, left, msg)				\
		DPRINTF(level,						\
		"pmsg %s(magic=0x%x, version=%d, msgtype=%d, cmd=%d, uid=%d, datasize=%d, response=%d)\n", \
		msg, left.magic, left.version, left.msgtype, left.cmd,	\
		left.uid, left.datasize, left.response)
#endif	/* PMSG_SEQ_DEBUGGING */

#endif	/* CONFIG_COMPAT */


/*
 * values for msgtype
 */
#define	UTIO_MSG_OPEN		0x0001 /* user opened session; arg = sessid */
#define	UTIO_MSG_CLOSE		0x0002 /* close message */
#define	UTIO_MSG_IOCTL		0x0004 /* IOCTL message */
#define	UTIO_MSG_READ		0x0008 /* Data available to read */
#define	UTIO_MSG_WRITE		0x0010 /* Buffer space available to write */
#define	UTIO_MSG_ACK		0x0020 /* for the pending open/close/ioctl */
#define	UTIO_MSG_NACK		0x0040 /* for the pending open/close/ioctl */

/* Linux note: have to avoid ioctl definitions in <linux/usbdevice_fs.h> */

/*
 * master-side ioctls
 */
#define	UTA_IOC_BASE		'U'
#define	UTIO_GETVERSION		_IOR(UTA_IOC_BASE, 0x50, unsigned int)
#define	UTIO_GETMAJOR		_IO(UTA_IOC_BASE, 0x51)
#define	UTIO_GETDEVID		_IO(UTA_IOC_BASE, 0x52)
#define	UTIO_GETMSG		_IOR(UTA_IOC_BASE, 0x53, utio_pmsg_t)
#define	UTIO_PUTMSG		_IOW(UTA_IOC_BASE, 0x54, utio_pmsg_t)

#if defined(CONFIG_COMPAT) || defined(CONFIG_SPARC64) || defined(CONFIG_X86_64) || defined(CONFIG_PPC64)
#define	COMPAT_UTIO_GETMSG	_IOR(UTA_IOC_BASE, 0x53, compat_utio_pmsg_t)
#define	COMPAT_UTIO_PUTMSG	_IOW(UTA_IOC_BASE, 0x54, compat_utio_pmsg_t)
#define PP_IOCTL	'p'
#define COMPAT_PPGETTIME	_IOR(PP_IOCTL, 0x95, struct compat_timeval)
#endif	/* CONFIG_COMPAT */

/* Backwards compatibility definitions */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,29)
#define CURRENT_UID() (current->uid)
#else
#define CURRENT_UID() (current->cred->uid)
#endif

#ifdef __cplusplus
}
#endif	/* defined __cplusplus */

#endif /* UTIO_H__ */
