<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id: Security.jsp 1498 2011-03-08 20:25:58Z shefali $ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Util.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                    <f:verbatim>
                        <style type="text/css">
                            .RbGrp label {vertical-align: -2px;}
                        </style>
                    </f:verbatim>
                </ui:head>    
                <ui:body focus="f1:p1:a1:s1:p1:i1_editable"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="security"/>
                        <ui:alert binding ="#{securityHandler.statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1"
                                             title="#{msg.security_pageTitle}">

                            <ui:markup tag="div" styleClass="TtlHlpDiv">
                                <ui:helpInline id="h1" type="page"
                                               text="#{msg.security_pageHelpText}">
                                    <ui:helpWindow windowTitle="#{msg.helpWindow_title}" 
                                                   pageTitle="#{msg.helpWindow_pageTitle}"
                                                   mastheadImageUrl="/images/productName.png"
                                                   mastheadImageHeight="23"
                                                   mastheadImageWidth="420"   
                                                   helpFile="security.html"
                                                   toolTip="#{msg.helpWindow_link_tooltip}"
                                                   linkIcon="true" linkText="#{msg.security_help_link}" />
                                </ui:helpInline>
                            </ui:markup>                                                  
                                                 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup> 
                                    <ui:button 
                                        id="save_submit" 
                                        text="#{msg.save_button}" 
                                        primary="true"
                                        action="#{securityHandler.modify}"
                                        toolTip="#{msg.security_save_tooltip}"
                                        alt="#{msg.save_button_alt}"/>
                                    <ui:button 
                                        id="reset_submit" 
                                        text="#{msg.reset_button}" 
                                        reset="true"
                                        onClick="javascript: disableEditButtons();"
                                        toolTip="#{msg.security_reset_tooltip}"
                                        alt="#{msg.reset_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <ui:propertySheet id="a1" jumpLinks="false" requiredFields="false">
                                <ui:propertySheetSection id="s1" label="#{msg.security_encryption_section}">
                                    <ui:property id="p1">
                                        <ui:checkbox id="i1_editable"
                                            label="#{msg.security_upstream_encryption}"
                                            selected="#{securityHandler.security.encUp}"
                                            onClick="javascript: toggleEditButtons();"
                                            toolTip="#{msg.security_upstream_encryption_tooltip}"/>
                                        <f:verbatim><br/></f:verbatim>
                                        <ui:checkbox id="i2_editable"
                                            label="#{msg.security_downstream_encryption}"
                                            selected="#{securityHandler.security.encDown}"
                                            onClick="javascript: toggleEditButtons();"
                                            toolTip="#{msg.security_downstream_encryption_tooltip}"/>
                                        <f:verbatim><br/></f:verbatim>
                                        <ui:checkbox id="i3_editable"
                                            label="#{msg.security_server_authentication}"
                                            selected="#{securityHandler.security.authDown}"
                                            onClick="javascript: toggleEditButtons();"
                                            toolTip="#{msg.security_server_authentication_tooltip}"/>
                                        <ui:radioButtonGroup id="i4_editable"
                                            items="#{securityHandler.encryptionModeOptions}"
                                            label="#{msg.security_mode}"
                                            columns="1"
                                            onClick="javascript: toggleEditButtons();"
                                            selected="#{securityHandler.security.encryptionMode}"
                                            toolTip="#{msg.security_mode_encryption_tooltip}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>
                                <ui:propertySheetSection id="s2" label="#{msg.security_client_auth_section}">
                                    <ui:property id="p1">
                                        <ui:checkbox id="i1_editable"
                                            label="#{msg.security_client_authentication}"
                                            selected="#{securityHandler.security.authUp}"
                                            onClick="javascript: toggleEditButtons();"
                                            toolTip="#{msg.security_client_authentication_tooltip}"/>
                                        <f:verbatim><br/></f:verbatim>
                                        <ui:radioButtonGroup id="i4_editable"
                                            items="#{securityHandler.clientModeOptions}"
                                            label="#{msg.security_mode}"
                                            columns="1"
                                            onClick="javascript: toggleEditButtons();"
                                            selected="#{securityHandler.security.clientMode}"
                                            toolTip="#{msg.security_mode_client_tooltip}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>
                                <ui:propertySheetSection id="s3" label="#{msg.security_devices_section}">
                                    <ui:property id="p1">
                                        <ui:checkbox id="i1_editable"
                                            label="#{msg.devices_internal_serial}"
                                            selected="#{securityHandler.devices.internalSerialEnabled}"
                                            onClick="javascript: toggleEditButtons();"
                                            toolTip="#{msg.devices_internal_serial_tooltip}"/>
                                        <f:verbatim><br/></f:verbatim>
                                        <ui:checkbox id="i2_editable"
                                            label="#{msg.devices_internal_smart_card_reader}"
                                            selected="#{securityHandler.devices.internalSmartCardReaderEnabled}"
                                            onClick="javascript: toggleEditButtons();"
                                            toolTip="#{msg.devices_internal_smart_card_reader_tooltip}"/>
                                        <f:verbatim><br/></f:verbatim>
                                        <ui:checkbox id="i3_editable"
                                            label="#{msg.devices_usb}"
                                            selected="#{securityHandler.devices.usbEnabled}"
                                            onClick="javascript: toggleEditButtons();"
                                            toolTip="#{msg.devices_usb_tooltip}"/>
                                    </ui:property>
                                </ui:propertySheetSection>
                            </ui:propertySheet>
                        </ui:contentPageTitle>
                        <ui:script>
                            <f:verbatim>
                                initValues();
                                toggleEditButtons();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 


