<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id: SmartCardsEdit.jsp 1498 2011-03-08 20:25:58Z shefali $ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/SmartCards.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p1:r1_available"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="probe"/>
                        <ui:alert binding ="#{smartCardHandler.statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1"
                                             title="#{msg.probeEdit_pageTitle}"
                                             helpText="#{msg.probeEdit_pageHelpText}"> 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup id="pageButtonsGroupBottom"> 
                                    <ui:button id="ok" 
                                               text="#{msg.ok_button}" 
                                               primary="true" 
                                               action="#{smartCardHandler.save}"
                                               toolTip="#{msg.probe_order_ok_button_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel" 
                                               text="#{msg.cancel_button}" 
                                               action="viewProbeOrder" 
                                               immediate="true"
                                               toolTip="#{msg.probe_order_cancel_button_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:verbatim><br/></f:verbatim>
                            <ui:markup tag="div" styleClass="ConMgn">
                                <ui:addRemove id="r1"
                                              items="#{smartCardHandler.items}"
                                              selected="#{smartCardHandler.selected}"
                                              availableItemsLabel="#{msg.probeEdit_available}"
                                              selectedItemsLabel="#{msg.probeEdit_selected}"
                                              selectAll="true"
                                              sorted="false"
                                              moveButtons="true"
                                              vertical="false"
                                              labelOnTop="false"/>
                            </ui:markup>
                        </ui:contentPageTitle>
                        <ui:script>
                            <f:verbatim>
                                resetOnClicks();
                                initValues();
                                toggleOkButton();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root>

