<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id$ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}" />
                    <ui:script url="../../js/Util.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>
                <ui:body focus="f1:p1:a1:s1:p1:i1_editable_required"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="tokens"/>
                        <ui:alert binding ="#{statusMessage.alert}"/>
        
                        <ui:breadcrumbs>
                            <ui:hyperlink text="#{msg.tokens_tab_label}" 
                                          action="viewTokens"
                                          immediate="true"
                                          toolTip="#{msg.tokens_all_link_tooltip}"/>
                            <ui:hyperlink text="#{tokenHandler.selectedToken.id}"
                                          toolTip="#{msg.tokens_selected_link_tooltip}"/>
                        </ui:breadcrumbs>
                        
                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.tokens_edit_title} - #{tokenHandler.selectedToken.id}">

                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup id="pageButtonsGroupTop"> 
                                    <ui:button id="ok_submit" 
                                               text="#{msg.ok_button}" 
                                               primary="true" 
                                               action="#{tokenHandler.modify}" 
                                               disabled="false"
                                               toolTip="#{msg.tokens_edit_ok_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel" 
                                               text="#{msg.cancel_button}" 
                                               action="viewTokenDetails" 
                                               immediate="true"
                                               toolTip="#{msg.tokens_edit_cancel_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup id="pageButtonsGroupBottom"> 
                                    <ui:button id="ok_submit" 
                                               text="#{msg.ok_button}" 
                                               primary="true" 
                                               action="#{tokenHandler.modify}" 
                                               disabled="false"
                                               toolTip="#{msg.tokens_edit_ok_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel" 
                                               text="#{msg.cancel_button}" 
                                               action="viewTokenDetails" 
                                               immediate="true"
                                               toolTip="#{msg.tokens_edit_cancel_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 

                            <ui:propertySheet id="a1" jumpLinks="false" requiredFields="true">
                                <ui:propertySheetSection id="s1" label="#{msg.tokens_general_section}">
                                    <ui:property id="p1"
                                                 label="#{msg.tokens_owner_label}"
                                                 labelAlign="right">
                                        <ui:textField id="i1_editable_required" 
                                                      text="#{tokenHandler.selectedUser.userName}"
                                                      columns="50"
                                                      required="true"
                                                      onKeyUp="javascript: setTimeout('toggleEditButtons()', 0);"
                                                      onChange="javascript: setTimeout('toggleEditButtons()', 0);"
                                                      toolTip="#{msg.tokens_owner_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p2"
                                                 label="#{msg.tokens_description_label}"
                                                 labelAlign="right">
                                        <ui:textField id="i2_editable" 
                                                      text="#{tokenHandler.selectedUser.description}"
                                                      columns="50"
                                                      onKeyUp="javascript: setTimeout('toggleEditButtons()', 0);"
                                                      onChange="javascript: setTimeout('toggleEditButtons()', 0);"
                                                      toolTip="#{msg.tokens_description_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p3"
                                                 label="#{msg.tokens_status_label}"
                                                 labelAlign="right">
                                        <ui:checkbox id="enabled_editable"
                                                     selected="#{tokenHandler.selectedToken.enabled}"
                                                     onClick="javascript: toggleEditButtons();"
                                                     toolTip="#{msg.tokens_status_tooltip}"/>
                                        <ui:staticText text="#{msg.tokens_enabled_label}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>
                                <ui:propertySheetSection label="#{msg.tokens_advanced_section}"
                                                         id="s2"
                                                         rendered="#{tokenHandler.kioskInstalled}">
                                    <ui:property label="#{msg.tokens_session_type_label}"
                                                 id="p1"
                                                 labelAlign="right">
                                        <ui:dropDown id="z1_editable"
                                             items="#{tokenHandler.sessionTypeOptions}" 
                                             selected="#{tokenHandler.sessionType}"
                                             onChange="javascript: setTimeout('toggleEditButtons()', 0);"
                                             toolTip="#{msg.tokens_session_type_tooltip}"/> 
                                    </ui:property>                   
                                </ui:propertySheetSection>        
                            </ui:propertySheet>
                        </ui:contentPageTitle> 
                        <ui:script>
                            <f:verbatim>
                                initValues();
                                toggleEditButtons();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 

