<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id$ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}" />
                    <ui:script url="../../js/Util.js"/>
                    <ui:script url="../../js/Token.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:t1:a1:s1:p2:i2_editable_required"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="tokens"/>
                        <ui:alert binding ="#{statusMessage.alert}"/>
        
                        <ui:contentPageTitle id="t1"
                                             title="#{msg.tokens_new_user_title}"
                                             helpText="#{msg.tokens_new_title_help}">

                            <ui:propertySheet id="a1"
                                              jumpLinks="false"
                                              requiredFields="true">
                                <ui:propertySheetSection id="s1">
                                    <ui:property id="p2" labelAlign="right">
                                        <f:facet name="label">
                                            <ui:label id="l1" 
                                                  requiredIndicator="true"  
                                                  text="#{msg.tokens_identifier_label}"
                                                  for="p2"/>
                                         </f:facet>
                                         <ui:markup tag="table">
                                             <ui:markup tag="tr">
                                                 <ui:markup tag="td">
                                                     <ui:radioButton id="rb0" 
                                                            disabled="false"
                                                            name="idFromGrp" 
                                                            selected="#{newTokenHandler.isReadFromReader}" 
                                                            label="#{msg.tokens_from_reader}" 
                                                            onClick="toggleAddTokenButtons(); toggleReaderItems();" />
                                                 </ui:markup>
                                                 <ui:markup tag="td">
                                                     <ui:dropDown id="i1"
                                                                  selected="#{newTokenHandler.tokenReader}" 
                                                                  items="#{newTokenHandler.availableTokenReaders}"
                                                                  styleClass="HlpFldTxt"
                                                                  toolTip="#{msg.tokens_available_readers_tooltip}"/>
                                                     <ui:button id="b1"
                                                                text="#{msg.tokens_read_button}" 
                                                                action="#{newTokenHandler.getToken}"
                                                                mini="true"
                                                                immediate="true"
                                                                disabled="#{!newTokenHandler.tokenReaders}"
                                                                toolTip="#{msg.tokens_read_button_tooltip}"
                                                                alt="#{msg.tokens_read_button_alt}"/>
                                                 </ui:markup>
                                             </ui:markup>
                                             <ui:markup tag="tr">
                                                 <ui:markup tag="td">
                                                     <ui:radioButton id="rb1" 
                                                            name="idFromGrp" 
                                                            label="#{msg.tokens_from_manual}" 
                                                            onClick="toggleAddTokenButtons(); toggleReaderItems();" /> 
                                                 </ui:markup>
                                                 <ui:markup tag="td">
                                                     <ui:textField id="i2_editable_required"
                                                                   text="#{newTokenHandler.tokenId}"
                                                                   columns="50"
                                                                   onKeyUp="javascript: setTimeout('toggleAddTokenButtons()', 0);"
                                                                   onChange="javascript: setTimeout('toggleAddTokenButtons()', 0);"
                                                                   toolTip="#{msg.tokens_identifier_tooltip}"/>
                                                 </ui:markup>
                                             </ui:markup>
                                         </ui:markup>
                                    </ui:property>
                                    <ui:property id="p3"
                                                 label="#{msg.tokens_owner_label}"
                                                 labelAlign="right">
                                        <ui:textField id="i3_editable_required"
                                                      text="#{newTokenHandler.userName}"
                                                      columns="50"
                                                      required="true"
                                                      onKeyUp="javascript: setTimeout('toggleAddTokenButtons()', 0);"
                                                      onChange="javascript: setTimeout('toggleAddTokenButtons()', 0);"
                                                      toolTip="#{msg.tokens_owner_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p4"
                                                 label="#{msg.tokens_description_label}"
                                                 labelAlign="right">
                                        <ui:textField id="i4_editable"
                                                      text="#{newTokenHandler.description}"
                                                      columns="50"
                                                      onKeyUp="javascript: setTimeout('toggleAddTokenButtons()', 0);"
                                                      onChange="javascript: setTimeout('toggleAddTokenButtons()', 0);"
                                                      toolTip="#{msg.tokens_description_tooltip}"/>
                                        <f:verbatim><br/><br/></f:verbatim>              
                                    </ui:property>
                                </ui:propertySheetSection>
                                <ui:propertySheetSection label="#{msg.tokens_advanced_section}"
                                                         id="s2"
                                                         rendered="#{newTokenHandler.kioskInstalled}">
                                    <ui:property label="#{msg.tokens_session_type_label}"
                                                 id="p1"
                                                 labelAlign="right">
                                        <ui:dropDown id="z1_editable"
                                             items="#{newTokenHandler.sessionTypeOptions}"
                                             selected="#{newTokenHandler.sessionType}"
                                             onChange="javascript: setTimeout('toggleAddTokenButtons()', 0);"
                                             toolTip="#{msg.tokens_session_type_tooltip}"/> 
                                    </ui:property>                   
                                </ui:propertySheetSection>
                            </ui:propertySheet>
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup id="pg1"> 
                                    <ui:button id="ok_submit"
                                               text="#{msg.ok_button}"
                                               primary="true"
                                               action="#{newTokenHandler.addUser}"
                                               toolTip="#{msg.tokens_new_user_ok_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel"
                                               text="#{msg.cancel_button}"
                                               action="viewTokens"
                                               immediate="true"
                                               toolTip="#{msg.tokens_new_user_cancel_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                        </ui:contentPageTitle> 
                        <ui:script>
                            <f:verbatim>
                                toggleAddTokenButtons();
                                toggleReaderItems();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 

