<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id$ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
 
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}" />
                    <ui:script url="../../js/Tokens.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p1:z1"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="tokens"/>
                        <ui:alert binding ="#{statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.tokens_search_title}" 
                                             helpText="#{msg.tokens_search_title_help}">
                            <ui:markup tag="div" styleClass="ConMgn">

                                <f:verbatim><br/></f:verbatim>
                                <ui:dropDown id="z1"
                                             items="#{tokensSearchCriteria.options}" 
                                             selected="#{tokensSearchCriteria.filter}"
                                             toolTip="#{msg.dtu_searchCriteria_options_tooltip}"/>
                                <ui:textField id="z2"
                                              text="#{tokensSearchCriteria.searchString}" 
                                              columns="40"
                                              toolTip="#{msg.dtu_searchCriteria_searchString_tooltip}"/>
                                <ui:staticText text="&#160;" escape="false"/>
                                <ui:button id="search"
                                           text="#{msg.search_button}"
                                           primary="true"
                                           action="#{tokensSearchHandler.search}"
                                           toolTip="#{msg.dtu_search_button_tooltip}"
                                           alt="#{msg.search_button_alt}"/>
                                <f:verbatim><br/><br/></f:verbatim>
                                <ui:label text="#{msg.search_criteria}"/>
                                <ui:staticText id="s1" text="#{tokensSearchCriteria.description}"/> 
                                <ui:staticText text="&#160;" escape="false"/>
                                <ui:button id="b1"
                                           text="#{msg.reset_search_button}"
                                           action="viewTokens"
                                           toolTip="#{msg.dtu_reset_search_tooltip}"
                                           alt="#{msg.reset_search_button_alt}"/>
                                <f:verbatim><br/><br/></f:verbatim>

                                <ui:table id="t1"
                                          title="#{tokensSearchHandler.title}" 
                                          paginateButton="true"
                                          paginationControls="true"
                                          rendered="#{tokensSearchHandler.registered}"
                                          selectMultipleButton="true"
                                          selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          deselectMultipleButton="true"
                                          deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          clearSortButton="true"
                                          summary="#{msg.tokens_search_table_summary}"
                                          toolTip="#{msg.tokens_search_table_tooltip}">

                                    <ui:tableRowGroup sourceData="#{tokensSearchHandler.registeredTokens}"
                                                      rows="20"
                                                      sourceVar="tokensRowGroup"
                                                      binding="#{tokensSearchHandler.tableRowGroup}"
                                                      selected="#{tokensSearchHandler.selectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select">
                                            <ui:checkbox id="select" 
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{tokensSearchHandler.selectHelper.selected}"
                                                         selectedValue="#{tokensSearchHandler.selectHelper.selectedValue}"
                                                         toolTip="#{msg.tokens_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Token column -->
                                        <ui:tableColumn headerText="#{msg.tokens_token_header}" 
                                                        rowHeader="true"
                                                        style="width: 15%;"
                                                        sort="id">
                                            <ui:hyperlink text="#{tokensRowGroup.value.id}" 
                                                          action="#{tokensSearchHandler.selectToken}"
                                                          immediate="true"
                                                          toolTip="#{msg.tokens_table_value_tooltip}">
                                                <f:param name="selectedTokenId" 
                                                         value="#{tokensRowGroup.value.id}"/>
                                            </ui:hyperlink>
                                        </ui:tableColumn>

                                        <!-- Status column -->
                                        <ui:tableColumn headerText="#{msg.tokens_status_header}" 
                                                        rowHeader="true"
                                                        sort="status"
                                                        style="width: 10%;">
                                            <ui:image icon="#{tokensRowGroup.value.statusIcon}"
                                                      alt="#{msg.token_status_image_alt}" 
                                                      toolTip="#{tokensRowGroup.value.status}" />
                                            <ui:staticText text="&#160;" escape="false"/>
                                            <ui:staticText text="#{tokensRowGroup.value.status}"/>
                                        </ui:tableColumn>
                                        
                                        <!-- Session type column -->
                                        <ui:tableColumn headerText="#{msg.tokens_session_type_header}" 
                                                        rowHeader="true"
                                                        sort="sessionTypeDescription"
                                                        style="width: 10%;"
                                                        rendered="#{tokensSearchHandler.kioskInstalled}">
                                            <ui:staticText text="#{tokensRowGroup.value.sessionTypeDescription}"/>
                                        </ui:tableColumn>

                                        <!-- Owner column -->
                                        <ui:tableColumn headerText="#{msg.tokens_owner_header}" 
                                                        rowHeader="true"
                                                        style="width: 18%;"
                                                        sort="owner">
                                            <ui:staticText text="#{tokensRowGroup.value.owner}"/>
                                        </ui:tableColumn>

                                        <!-- Description column -->
                                        <ui:tableColumn headerText="#{msg.tokens_description_header}"
                                                        sort="description"
                                                        rowHeader="true">
                                            <ui:staticText text="#{tokensRowGroup.value.description}"/>
                                        </ui:tableColumn>
                                    </ui:tableRowGroup>

                                    <f:facet name="actionsTop">
                                        <f:subview id="actionsTop">
                                            <ui:button id="new"
                                                       disabled="false"
                                                       text="#{msg.new_button}"
                                                       action="newToken"
                                                       immediate="true"
                                                       toolTip="#{msg.tokens_new_button_tooltip}"
                                                       alt="#{msg.new_button_alt}"/>
                                            <ui:button id="delete"
                                                       disabled="true"
                                                       text="#{msg.delete_button}"
                                                       action="#{tokensSearchHandler.delete}"
                                                       toolTip="#{msg.tokens_delete_button_tooltip}"
                                                       alt="#{msg.delete_button_alt}"/>
                                            <ui:button id="enable"
                                                       disabled="true"
                                                       text="#{msg.enable_button}"
                                                       action="#{tokensSearchHandler.enable}"
                                                       toolTip="#{msg.tokens_enable_button_tooltip}"
                                                       alt="#{msg.enable_button_alt}"/>
                                            <ui:button id="disable"
                                                       disabled="true"
                                                       text="#{msg.disable_button}"
                                                       action="#{tokensSearchHandler.disable}"
                                                       toolTip="#{msg.tokens_disable_button_tooltip}"
                                                       alt="#{msg.disable_button_alt}"/>
                                            <ui:dropDown id="sessionActions"
                                                        submitForm="true"
                                                        action="#{tokensSearchHandler.modifySession}"
                                                        disabled="true"
                                                        rendered="#{tokensSearchHandler.kioskInstalled}"
                                                        items="#{tokensSearchHandler.sessionActionsOptions}"
                                                        selected="#{tokensSearchHandler.sessionType}"/>
                                        </f:subview>
                                    </f:facet>

                                </ui:table>

                                <ui:table id="t2" 
                                          title="#{tokensSearchHandler.title}" 
                                          paginateButton="true"
                                          paginationControls="true"
                                          rendered="#{tokensSearchHandler.current}"
                                          clearSortButton="true"
                                          summary="#{msg.tokens_search_current_table_summary}"
                                          toolTip="#{msg.tokens_search_current_table_tooltip}">

                                    <ui:tableRowGroup sourceData="#{tokensSearchHandler.currentTokens}" 
                                                      sourceVar="tokensRowGroup">

                                        <!-- Token column -->
                                        <ui:tableColumn headerText="#{msg.tokens_token_header}"
                                                        sort="id"
                                                        style="width: 15%;"
                                                        rowHeader="true">
                                            <ui:hyperlink text="#{tokensRowGroup.value.id}" 
                                                          action="#{tokensSearchHandler.selectToken}"
                                                          immediate="true"
                                                          toolTip="#{msg.tokens_table_value_tooltip}">
                                                <f:param name="selectedTokenId" 
                                                         value="#{tokensRowGroup.value.id}"/>
                                            </ui:hyperlink>
                                        </ui:tableColumn>
                                        <!-- Owner column -->
                                        <ui:tableColumn headerText="#{msg.tokens_owner_header}"
                                                        sort="owner"
                                                        style="width: 18%;"
                                                        rowHeader="true">
                                            <ui:staticText text="#{tokensRowGroup.value.owner}"/>
                                        </ui:tableColumn>

                                        <!-- Desktop Unit column -->
                                        <ui:tableColumn headerText="#{msg.tokens_dtu_header}"
                                                        sort="desktop"
                                                        rowHeader="true">
                                            <ui:hyperlink text="#{tokensRowGroup.value.desktop}" 
                                                          action="#{sessionList.showDesktopUnitDetails}"
                                                          immediate="true"
                                                          toolTip="#{msg.tokens_table_dtu_tooltip}">
                                                <f:param name="dtu" 
                                                         value="#{tokensRowGroup.value.desktop}"/>
                                            </ui:hyperlink>
                                        </ui:tableColumn>

                                        <!-- Location column -->
                                        <ui:tableColumn headerText="#{msg.tokens_location_header}"
                                                        sort="location"
                                                        rowHeader="true">
                                            <ui:staticText text="#{tokensRowGroup.value.location}"/>
                                        </ui:tableColumn>

                                        <!-- Server column -->
                                        <ui:tableColumn headerText="#{msg.tokens_server_header}"
                                                        sort="server"
                                                        rowHeader="true">
                                            <ui:hyperlink text="#{tokensRowGroup.value.server}" 
                                                          action="#{sessionList.showServerDetails}"
                                                          immediate="true"
                                                          toolTip="#{msg.tokens_table_server_tooltip}">
                                                <f:param name="serverName" 
                                                         value="#{tokensRowGroup.value.server}"/>
                                            </ui:hyperlink>
                                        </ui:tableColumn>

                                    </ui:tableRowGroup>
                                </ui:table>

                            </ui:markup>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 


