<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id$ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}" />
                    <ui:script url="../../js/Token.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p1:_id19:edit"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="tokens"/>
                        <ui:alert binding ="#{tokenHandler.statusMessage.alert}"/>
        
                        <ui:breadcrumbs>
                            <ui:hyperlink text="#{msg.tokens_tab_label}" 
                                          action="viewTokens"
                                          immediate="true"
                                          toolTip="#{msg.tokens_all_link_tooltip}"/>
                            <ui:hyperlink text="#{tokenHandler.selectedToken.id}"
                                          toolTip="#{msg.tokens_selected_link_tooltip}"/>
                        </ui:breadcrumbs>

                        <ui:contentPageTitle id="p1" 
                                             title="#{tokenHandler.selectedToken.id} - #{msg.tokens_properties}"
                                             helpText="#{msg.tokens_properties_help}">

                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="edit"
                                               text="#{msg.edit_button}" 
                                               primary="true" 
                                               action="#{tokenHandler.edit}"
                                               immediate="true"
                                               toolTip="#{msg.tokens_edit_button_tooltip}"
                                               alt="#{msg.edit_button_alt}"/>
                                    <ui:button id="back"
                                               text="#{msg.tokens_back_to}" 
                                               action="viewTokens"
                                               immediate="true"
                                               toolTip="#{msg.tokens_back_button_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 

                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup> 
                                    <ui:button id="edit"
                                               text="#{msg.edit_button}" 
                                               primary="true" 
                                               action="#{tokenHandler.edit}"
                                               immediate="true"
                                               toolTip="#{msg.tokens_edit_button_tooltip}"
                                               alt="#{msg.edit_button_alt}"/>
                                    <ui:button id="back"
                                               text="#{msg.tokens_back_to}" 
                                               action="viewTokens"
                                               immediate="true"
                                               toolTip="#{msg.tokens_back_button_tooltip}"
                                               alt="#{msg.back_button_alt}"/>
                                    <f:verbatim><br/><br/></f:verbatim>                                               
                                </ui:panelGroup> 
                            </f:facet> 

                            <ui:propertySheet id="s1" 
                                              jumpLinks="false">
                                <ui:propertySheetSection label="#{msg.tokens_general_section}"
                                                         id="s1">
                                    <ui:property id="p1"
                                                 label="#{msg.tokens_owner_label}" 
                                                 labelAlign="right">
                                        <ui:staticText id="i1" 
                                                       text="#{tokenHandler.selectedUser.userName}"/>
                                    </ui:property>
                                    <ui:property id="p2"
                                                 label="#{msg.tokens_description_label}" 
                                                 labelAlign="right">
                                        <ui:staticText id="i2"
                                                       text="#{tokenHandler.selectedUser.description}"/>
                                    </ui:property>
                                    <ui:property id="p3"
                                                 label="#{msg.tokens_status_label}" 
                                                 labelAlign="right">
                                        <ui:image icon="#{tokenHandler.selectedToken.statusIcon}"
                                                  alt="#{msg.token_status_image_alt}" 
                                                  toolTip="#{tokenHandler.selectedToken.status}" />
                                        <ui:staticText text="&#160;" escape="false"/>
                                        <ui:staticText text="#{tokenHandler.selectedToken.status}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>

                                <ui:propertySheetSection label="#{msg.tokens_advanced_section}"
                                                         id="s2">
                                    <ui:property label="#{msg.tokens_sessions_property}"
                                                 id="p3"
                                                 labelAlign="right">
                                        <ui:staticText id="i1"
                                                       text="#{tokenHandler.totalTokenSessions}"/>
                                        <ui:staticText text="&#160;&#160;" escape="false"/>
                                        <ui:hyperlink id="l1"
                                                      toolTip="#{msg.tokens_sessions_link_tooltip}"
                                                      action="#{tokenHandler.sessions}"
                                                      immediate="true"
                                                      rendered="#{tokenHandler.totalTokenSessions > 0}">
                                            <ui:image icon="HREF_LINK"/>
                                            <ui:staticText text="&#160;" escape="false"/> 
                                            <ui:staticText text="#{msg.tokens_sessions_link}"/>
                                        </ui:hyperlink>
                                   </ui:property>    
                                   <ui:property label="#{msg.tokens_session_type_label}"
                                                 id="p1"
                                                 labelAlign="right"
                                                 rendered="#{tokenHandler.kioskInstalled}">
                                        <ui:staticText id="i1"
                                                       text="#{tokenHandler.sessionTypeDescription}"/>
                                    </ui:property>                   
                                    <ui:property label="#{msg.tokens_alias_tokens_label}"
                                                 id="p2"
                                                 labelAlign="right"
                                                 rendered="#{!tokenHandler.unregistered}">

                                        <ui:table id="t1"
                                                  lite="true"
                                                  selectMultipleButton="true"
                                                  selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                                  deselectMultipleButton="true"
                                                  deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                                  clearSortButton="true"
                                                  summary="#{msg.tokens_alias_table_summary}"
                                                  toolTip="#{msg.tokens_alias_table_summary}">
                                            <ui:tableRowGroup sourceData="#{tokenHandler.rawTokens}"
                                                              sourceVar="tokenRowGroup"
                                                              binding="#{tokenHandler.tableRowGroup}"
                                                              selected="#{tokenHandler.selectHelper.selectedState}">

                                                <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                                extraFooterHtml="nowrap='nowrap'"
                                                                extraTableFooterHtml="nowrap='nowrap'"
                                                                selectId="select">
                                                    <ui:checkbox id="select" 
                                                                 onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                                 selected="#{tokenHandler.selectHelper.selected}"
                                                                 selectedValue="#{tokenHandler.selectHelper.selectedValue}"
                                                                 toolTip="#{msg.tokens_table_selectedValue_tooltip}"/>
                                                </ui:tableColumn>

                                                <!-- Token column -->
                                                <ui:tableColumn headerText="#{msg.tokens_token_header}" 
                                                                rowHeader="true"
                                                                sort="id"
                                                                style="width: 25em;">
                                                    <ui:hyperlink text="#{tokenRowGroup.value.id}" 
                                                                  action="#{tokensHandler.selectToken}"
                                                                  immediate="true"
                                                                  toolTip="#{msg.tokens_table_value_tooltip}">
                                                        <f:param name="selectedTokenId" 
                                                                 value="#{tokenRowGroup.value.id}"/>
                                                    </ui:hyperlink>
                                                </ui:tableColumn>

                                                <!-- Status column -->
                                                <ui:tableColumn headerText="#{msg.tokens_status_header}" 
                                                                rowHeader="true"
                                                                sort="status"
                                                                style="width: 10em;">
                                                    <ui:image icon="#{tokenRowGroup.value.statusIcon}"
                                                              alt="#{msg.token_status_image_alt}" 
                                                              toolTip="#{tokenRowGroup.value.status}" />
                                                    <ui:staticText text="&#160;" escape="false"/>
                                                    <ui:staticText text="#{tokenRowGroup.value.status}"/>
                                                </ui:tableColumn>
                                            </ui:tableRowGroup>

                                            <f:facet name="actionsTop">
                                                <f:subview id="actionsTop">
                                                    <ui:button id="new"
                                                               disabled="false"
                                                               text="#{msg.new_button}"
                                                               action="newAliasToken"
                                                               immediate="true"
                                                               toolTip="#{msg.tokens_new_alias_button_tooltip}"
                                                               alt="#{msg.new_button_alt}"/>
                                                    <ui:button id="delete"
                                                               disabled="true"
                                                               text="#{msg.delete_button}"
                                                               action="#{tokenHandler.delete}"
                                                               toolTip="#{msg.tokens_delete_button_tooltip}"
                                                               alt="#{msg.delete_button_alt}"/>
                                                    <ui:button id="enable"
                                                               disabled="true"
                                                               text="#{msg.enable_button}"
                                                               action="#{tokenHandler.enable}"
                                                               toolTip="#{msg.tokens_enable_button_tooltip}"
                                                               alt="#{msg.enable_button_alt}"/>
                                                    <ui:button id="disable"
                                                               disabled="true"
                                                               text="#{msg.disable_button}"
                                                               action="#{tokenHandler.disable}"
                                                               toolTip="#{msg.tokens_disable_button_tooltip}"
                                                               alt="#{msg.disable_button_alt}"/>
                                                </f:subview>
                                            </f:facet>
                                        </ui:table>            
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>

                                </ui:propertySheetSection>

                            </ui:propertySheet>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 

