#
# ident "@(#)sunray-models-d.x	1.6 02/09/25 SMI"
#
# Copyright 2000-2002 Sun Microsystems, Inc.  All rights reserved.
#

type = reference

_rules = { [ use PROC ]
	[ source sunray-d.rul ]
}

sunrayMib = { [ use MANAGED-OBJECT ]
    shortDesc = sunrayMib
    mediumDesc = Sun Ray
    fullDesc = A Sun Ray MIB module.
    oid = 1
    srSystem = { [ use MANAGED-OBJECT ]
        shortDesc = srSystem
        mediumDesc = Sun Ray System
        oid = 1
	consoleHint:mediumDesc = base.modules.sunray:srSystem
        srSystemHostName = { [ use MANAGED-PROPERTY STRING ]
            shortDesc = srSystemHostName
            mediumDesc = Host Name
            fullDesc = Host name of the Sun Ray system software.
            oid = 1
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srSystemHostName
        }
        srSystemContactName = { [ use MANAGED-PROPERTY STRING ]
            shortDesc = srSystemContactName
            mediumDesc = Contact Name
            fullDesc = Contact name set by admin user.
            oid = 2
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srSystemContactName
	    access = rw
	    consoleHint:editAccess = rw
	    dataFormat = unicode
	    defaultvalue = "System Administrator"
        }
        srSystemUpTime = { [ use RULE TIMETICKS MANAGED-PROPERTY _rules ]
            shortDesc = srSystemUpTime
            mediumDesc = Up Time (1/100ths sec.)
            fullDesc = Time lapse (in hundredths of a second) since Session Manager  started.
            oid = 3
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srSystemUpTime

        }
        srSoftwareVersion = { [ use MANAGED-PROPERTY STRING ]
            shortDesc = srSoftwareVersion
            mediumDesc = Version
            fullDesc = Current version of Sun Ray system software (SUNWuto).
            oid = 4
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srSoftwareVersion
        }
        srSystemInstallDate = { [ use MANAGED-PROPERTY STRING ]
            shortDesc = srSystemInstallDate
            mediumDesc = Install Date
            fullDesc = Installation date of Sun Ray system software (SUNWuto).
            oid = 5
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srSystemInstallDate
	    dataFormat = unicode
        }
        srPatchInfo = { [ use MANAGED-PROPERTY STRING ]
            shortDesc = srPatchInfo
            mediumDesc = Patch Information
            fullDesc = Installed patches of all Sun Ray packages.
            oid = 6
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srPatchInfo
        }
        srActiveSessions = { [ use MANAGED-PROPERTY INTHILO ]
            shortDesc = srActiveSessions
            mediumDesc = Active Sessions
            fullDesc = Total number of currently active sessions.
            oid = 7
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srActiveSessions
        }
        srTotalSessions = { [ use MANAGED-PROPERTY INTHILO ]
            shortDesc = srTotalSessions
            mediumDesc = Total Sessions
            fullDesc = Total number of sessions which include inactive sessions.
            oid = 8
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srTotalSessions
        }
        srActiveDesktops = { [ use MANAGED-PROPERTY INTHILO ]
            shortDesc = srActiveDesktops
            mediumDesc = Active Desktops
            fullDesc = Total number of currently connected desktops.
            oid = 9
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srActiveDesktops
        }
        srUsers = { [ use MANAGED-PROPERTY INTHILO ]
            shortDesc = srUsers
            mediumDesc = Users
            fullDesc = Total number of currently active users.
            oid = 10
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srUsers
        }
        srPolicy = { [ use MANAGED-PROPERTY STRING ]
            shortDesc = srPolicy
            mediumDesc = Policy
            fullDesc = Policies currently enforced.
            oid = 11
	    consoleHint:mediumDesc = base.modules.sunray:srSystem.srPolicy
        }
    }
    srServices = { [ use MANAGED-OBJECT ]
        shortDesc = srServices
        mediumDesc = Sun Ray Services
        oid = 2
	consoleHint:mediumDesc = base.modules.sunray:srServices
        srServicesTable = { [ use MANAGED-OBJECT-TABLE ]
            shortDesc = srServicesTable
            mediumDesc = Services Table
            fullDesc = Table of Sun Ray services.
            oid = 1
	    consoleHint:mediumDesc = base.modules.sunray:srServices.srServicesTable
            srServicesEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                shortDesc = srServicesEntry
                mediumDesc = Services Entry
                fullDesc = An entry of srServicesTable.
                index = srServiceName
                oid = 1
		consoleHint:mediumDesc = base.modules.sunray:srServices.srServicesTable.srServicesEntry
                srServiceName = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srServiceName
                    mediumDesc = Daemon
                    fullDesc = Name of the service.
                    oid = 1
		    consoleHint:mediumDesc = base.modules.sunray:srServices.srServicesTable.srServicesEntry.srServiceName
                }
                srServiceOperStatus = { [ use MANAGED-PROPERTY INTHI ]
                    shortDesc = srServiceOperStatus
                    mediumDesc = Status
                    fullDesc = Current status of the service.
                    oid = 2
		    consoleHint:mediumDesc = base.modules.sunray:srServices.srServicesTable.srServicesEntry.srServiceOperStatus
                }
                srServiceStartTime = { [ use TIMESTAMP MANAGED-PROPERTY ]
                    shortDesc = srServiceStartTime
                    mediumDesc = Started Time
                    fullDesc = Time when the service started.
                    oid = 3
		    consoleHint:mediumDesc = base.modules.sunray:srServices.srServicesTable.srServicesEntry.srServiceStartTime
		    dataFormat = timex
                }
                srServiceLastChange = { [ use TIMESTAMP MANAGED-PROPERTY ]
                    shortDesc = srServiceLastChange
                    mediumDesc = Last Changed
                    fullDesc = Last time when the service changed state tracked by the agent.
                    oid = 4
		    consoleHint:mediumDesc = base.modules.sunray:srServices.srServicesTable.srServicesEntry.srServiceLastChange
		    dataFormat = timex
                }
                srServiceInstances = { [ use MANAGED-PROPERTY INTHILO ]
                    shortDesc = srServiceInstances
                    mediumDesc = Instances
                    fullDesc = Number of service instances.
                    oid = 5
		    consoleHint:mediumDesc = base.modules.sunray:srServices.srServicesTable.srServicesEntry.srServiceInstances
                }
                srServiceDescription = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srServiceDescription
                    mediumDesc = Description
                    fullDesc = Description of the service.
                    oid = 6
		    consoleHint:mediumDesc = base.modules.sunray:srServices.srServicesTable.srServicesEntry.srServiceDescription
                }
            }
        }
    }
    srFOGroup = { [ use MANAGED-OBJECT ]
        shortDesc = srFOGroup
        mediumDesc = Fail Over Group
        fullDesc = Fail Over Group
        oid = 3
	consoleHint:mediumDesc = base.modules.sunray:srFOGroup
        srFOGTable = { [ use MANAGED-OBJECT-TABLE ]
            shortDesc = srFOGTable
            mediumDesc = Fail Over Group Table
            fullDesc = Table of currently active fail-over hosts.
            oid = 1
	    consoleHint:mediumDesc = base.modules.sunray:srFOGroup.srFOGTable
            srFOGEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                shortDesc = srFOGEntry
                mediumDesc = FOG Entry
                fullDesc = A server entry of srFOGTable.
                index = srFOGServerName
                oid = 1
		consoleHint:mediumDesc = base.modules.sunray:srFOGroup.srFOGTable.srFOGEntry
                srFOGServerName = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srFOGServerName
                    mediumDesc = Host Name
                    fullDesc = Name of the fail-over server.
                    oid = 1
		    consoleHint:mediumDesc = base.modules.sunray:srFOGroup.srFOGTable.srFOGEntry.srFOGServerName
                }
                srFOGServerType = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srFOGServerType
                    mediumDesc = Host Type
                    fullDesc = Persistent database type of the fail-over server.
                    oid = 2
		    consoleHint:mediumDesc = base.modules.sunray:srFOGroup.srFOGTable.srFOGEntry.srFOGServerType
                }
                srFOGServerOperStatus = { [ use MANAGED-PROPERTY INTHI ]
                    shortDesc = srFOGServerOperStatus
                    mediumDesc = Status
                    fullDesc = Current status of the fail-over server.
                    oid = 3
		    consoleHint:mediumDesc = base.modules.sunray:srFOGroup.srFOGTable.srFOGEntry.srFOGServerOperStatus
                }
            }
        }
    }
    srInterconnect = { [ use MANAGED-OBJECT ]
        shortDesc = srInterconnect
        mediumDesc = Interconnect
        oid = 4
	consoleHint:mediumDesc = base.modules.sunray:srInterconnect
        srDHCPTable = { [ use MANAGED-OBJECT-TABLE ]
            shortDesc = srDHCPTable
            mediumDesc = DHCP Table
            fullDesc = DHCP network table.
            oid = 1
	    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srDHCPTable
            srDHCPEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                shortDesc = srDHCPEntry
                mediumDesc = srDHCPEntry
                fullDesc = A network entry in srDHCPTable.
                index = srDHCPNetworkName
                oid = 1
		consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srDHCPTable.srDHCPEntry
                srDHCPNetworkName = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srDHCPNetworkName
                    mediumDesc = Network Name
                    fullDesc = A network name.
                    oid = 1
		    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srDHCPTable.srDHCPEntry.srDHCPNetworkName
                }
                srDHCPAvailableAddresses = { [ use MANAGED-PROPERTY INTLO ]
                    shortDesc = srDHCPAvailableAddresses
                    mediumDesc = Available Addresses
                    fullDesc = Number of IP addresses available within that network.
                    oid = 2
		    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srDHCPTable.srDHCPEntry.srDHCPAvailableAddresses
                }
            }
        }
        srIfTable = { [ use MANAGED-OBJECT-TABLE ]
            shortDesc = srIfTable
            mediumDesc = Interface Table
            fullDesc = Sun Ray interface status table.
            oid = 2
	    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srIfTable
            srIfEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                shortDesc = srIfEntry
                mediumDesc = srIfEntry
                fullDesc = An entry in the table srIfTable.
                index = srIfName
                oid = 1
		consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srIfTable.srIfEntry
                srIfName = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srIfName
                    mediumDesc = Entry Name
                    fullDesc = Network interface name of the Sun Ray server.
                    oid = 1
		    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srIfTable.srIfEntry.srIfName
                }
                srIfOperStatus = { [ use MANAGED-PROPERTY INTHI ]
                    shortDesc = srIfOperStatus
                    mediumDesc = Status
                    fullDesc = Current status of the interface.
                    oid = 2
		    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srIfTable.srIfEntry.srIfOperStatus
                }
                srIfIpAddress = { [ use MANAGED-PROPERTY IPADDRESS ]
                    shortDesc = srIfIpAddress
                    mediumDesc = Address
                    fullDesc = IP address of the interface.
                    oid = 3
		    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srIfTable.srIfEntry.srIfIpAddress
                }
                srIfNetMask = { [ use MANAGED-PROPERTY IPADDRESS ]
                    shortDesc = srIfNetMask
                    mediumDesc = Netmask
                    fullDesc = NetMask of the interface.
                    oid = 4
		    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srIfTable.srIfEntry.srIfNetMask
                }
                srIfLastPktSeen = { [ use TIMETICKS MANAGED-PROPERTY ]
                    shortDesc = srIfLastPktSeen
                    mediumDesc = Last Packet Seen (1/100ths sec.)
                    fullDesc = Time lapse (in hundredths of a second) since the last keep-alive  packet was seen from the interface.
                    oid = 5
		    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srIfTable.srIfEntry.srIfLastPktSeen
                }
                srIfLanType = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srIfLanType
                    mediumDesc = Lan Type
                    fullDesc = Whether the interface is part of the public LAN or the private Sun Ray interconnect.
                    oid = 6
		    consoleHint:mediumDesc = base.modules.sunray:srInterconnect.srIfTable.srIfEntry.srIfLanType
                }
            }
        }
    }
    srDesktops = { [ use MANAGED-OBJECT ]
        shortDesc = srDesktops
        mediumDesc = Desktops
        oid = 5
	consoleHint:mediumDesc = base.modules.sunray:srDesktops
        srMonitoredDesktopTable = { [ use MANAGED-OBJECT-TABLE ]
            shortDesc = srMonitoredDesktopTable
            mediumDesc = Monitored Desktops
            fullDesc = A table of Sun Ray desktops monitored by the administrator.
            oid = 1
	    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable
            srMonitoredDesktopEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                shortDesc = srMonitoredDesktopEntry
                mediumDesc = Desktop Entry
                fullDesc = An entry in srMonitoredDesktopTable.
                index = srMonitoredDesktopID
                oid = 1
		consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry
                srMonitoredRowStatus = { [ use GLOBROWNODE ROWSTATUS MANAGED-PROPERTY ]
                    shortDesc = srMonitoredRowStatus
                    mediumDesc = Row Status
                    fullDesc = Monitored desktop row status
                    oid = 1
		    consoleHint:hidden = true
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredRowStatus
                }
                srMonitoredDesktopID = { [ use GLOBROWNODE STRING MANAGED-PROPERTY ]
                    shortDesc = srMonitoredDesktopID
                    mediumDesc = Name
                    fullDesc = MAC address of the desktop.
		    required = true
		    dataFormat = nospace
                    oid = 2
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopID
                }
                srMonitoredDesktopIpAddress = { [ use MANAGED-PROPERTY IPADDRESS ]
                    shortDesc = srMonitoredDesktopIpAddress
                    mediumDesc = IP Address
                    fullDesc = IP address of the desktop.
                    oid = 3
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopIpAddress
                }
                srMonitoredDesktopOperStatus = { [ use MANAGED-PROPERTY INTHI ]
                    shortDesc = srMonitoredDesktopOperStatus
                    mediumDesc = Status
                    fullDesc = Current status of the desktop.
                    oid = 4
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopOperStatus
                }
                srMonitoredDesktopPackets = { [ use MANAGED-PROPERTY UINT ]
                    shortDesc = srMonitoredDesktopPackets
                    mediumDesc = Packets
                    fullDesc = Packets received by the desktop.
                    oid = 5
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopPackets
                }
                srMonitoredDesktopLostPackets = { [ use MANAGED-PROPERTY UINT ]
                    shortDesc = srMonitoredDesktopLostPackets
                    mediumDesc = Lost Packets
                    fullDesc = Packets the desktop reported lost.
                    oid = 6
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopLostPackets
                }
                srMonitoredDesktopLostPercent = { [ use MANAGED-PROPERTY FLOATHI ]
                    shortDesc = srMonitoredDesktopLostPercent
                    mediumDesc = Percent Lost
                    fullDesc = Percent of lost packets.
                    oid = 7
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopLostPercent
                }
                srMonitoredDesktopLocation = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srMonitoredDesktopLocation
                    mediumDesc = Location
                    fullDesc = Location of the desktop.
                    oid = 8
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopLocation
                }
                srMonitoredDesktopOptionalData = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srMonitoredDesktopOptionalData
                    mediumDesc = Optional Data
                    fullDesc = Optional data of the desktop.
                    oid = 9
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopOptionalData
                }
                srMonitoredDesktopServer = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srMonitoredDesktopServer
                    mediumDesc = Server
                    fullDesc = Server owning this desktop.
                    oid = 10
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopServer
                }
                srMonitoredDesktopModel = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srMonitoredDesktopModel
                    mediumDesc = Model
                    fullDesc = Hardware model of the desktop.
                    oid = 11
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopModel
                }
                srMonitoredDesktopFWRevision = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srMonitoredDesktopFWRevision
                    mediumDesc = Firmware Revision
                    fullDesc = Firmware revision of the desktop.
                    oid = 12
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srMonitoredDesktopTable.srMonitoredDesktopEntry.srMonitoredDesktopFWRevision
                }
            }
        }
        srExceptionDesktopTable = { [ use MANAGED-OBJECT-TABLE ]
            shortDesc = srExceptionDesktopTable
            mediumDesc = Desktop Exceptions
            fullDesc = A table of desktops experiencing exception. 
            oid = 2
	    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable
            srExceptionDesktopEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                shortDesc = srExceptionDesktopEntry
                mediumDesc = Exception Desktop Entry
                fullDesc = An entry in srExceptionDesktopTable.
                index = srExceptionDesktopID
                oid = 1
		consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry
                srExceptionDesktopID = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srExceptionDesktopID
                    mediumDesc = Name
                    fullDesc = MAC address of the desktop.
                    oid = 1
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopID
                }
                srExceptionDesktopIpAddress = { [ use MANAGED-PROPERTY IPADDRESS ]
                    shortDesc = srExceptionDesktopIpAddress
                    mediumDesc = IP Address
                    fullDesc = IP address of the desktop.
                    oid = 2
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopIpAddress
                }
                srExceptionDesktopOperStatus = { [ use MANAGED-PROPERTY INTHI ]
                    shortDesc = srExceptionDesktopOperStatus
                    mediumDesc = Status
                    fullDesc = Current status of the desktop.
                    oid = 3
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopOperStatus
                }
                srExceptionDesktopPackets = { [ use MANAGED-PROPERTY UINT ]
                    shortDesc = srExceptionDesktopPackets
                    mediumDesc = Packets
                    fullDesc = Packets received by the desktop.
                    oid = 4
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopPackets
                }
                srExceptionDesktopLostPackets = { [ use MANAGED-PROPERTY UINT ]
                    shortDesc = srExceptionDesktopLostPackets
                    mediumDesc = Lost Packets
                    fullDesc = Packets the desktop reported lost.
                    oid = 5
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopLostPackets
                }
                srExceptionDesktopLostPercent = { [ use MANAGED-PROPERTY FLOATHI ]
                    shortDesc = srExceptionDesktopLostPercent
                    mediumDesc = Percent Lost
                    fullDesc = Percent of lost packets.
                    oid = 6
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopLostPercent
                }
                srExceptionDesktopLocation = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srExceptionDesktopLocation
                    mediumDesc = Location
                    fullDesc = Location of the desktop.
                    oid = 7
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopLocation
                }
                srExceptionDesktopOptionalData = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srExceptionDesktopOptionalData
                    mediumDesc = Optional Data
                    fullDesc = Optional data of the desktop.
                    oid = 8
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopOptionalData
                }
                srExceptionDesktopServer = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srExceptionDesktopServer
                    mediumDesc = Server
                    fullDesc = Server owning this desktop.
                    oid = 9
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopServer
                }
                srExceptionDesktopModel = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srExceptionDesktopModel
                    mediumDesc = Model
                    fullDesc = Hardware model of the desktop.
                    oid = 10
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopModel
                }
                srExceptionDesktopFWRevision = { [ use MANAGED-PROPERTY STRING ]
                    shortDesc = srExceptionDesktopFWRevision
                    mediumDesc = Firmware Revision
                    fullDesc = Firmware revision of the desktop.
                    oid = 11
		    consoleHint:mediumDesc = base.modules.sunray:srDesktops.srExceptionDesktopTable.srExceptionDesktopEntry.srExceptionDesktopFWRevision
                }
            }
        }
    }
}

[ load sunray-ruleinit-d.x ]
[ load sunray-ruletext-d.x ]

