<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id: KioskBrowseServer.jsp 1498 2011-03-08 20:25:58Z shefali $ Oracle" -->

<!-- Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved. --> 

<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Kiosk.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body> 
                    <ui:form id="f1">
                        <ui:masthead id="Masthead" 
                            productImageURL="/images/SecondaryProductName.png"
                            productImageDescription="#{msg.product_image_tooltip}" 
                            productImageHeight="23"
                            productImageWidth="420" 
                            secondary="true">
                        </ui:masthead>
                        
                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.kiosk_browse_title}" helpText="#{msg.kiosk_browse_title_help}" >

                            <ui:fileChooser id="f1"
                                         multiple="false"
                                         rows="8"
                                         descending="false">
                                         <f:facet name="fileChooserLabel">
                                             <ui:staticText text=""/>         
                                         </f:facet>
                            </ui:fileChooser>
                                    
                                         
                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup id="pg1"> 
                                    <ui:button id="ok" 
                                        text="#{msg.ok_button}" 
                                        primary="true" 
                                        onClick="#{kioskHandler.browseOnClick}"
                                        toolTip="#{msg.kiosk_browse_ok_tooltip}"
                                        alt="#{msg.ok_button_alt}"/> 
                                    <ui:button id="cancel" 
                                        text="#{msg.cancel_button}"
                                        onClick="top.window.close(); return false" 
                                        immediate="true"
                                        toolTip="#{msg.kiosk_browse_cancel_tooltip}"
                                        alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet> 
                            <f:verbatim><br /></f:verbatim>
                            <f:verbatim>
                                <script type="text/javascript">
                                        FileChooser_f1_p1_f1.setChooseButton('f1:p1:pg1:ok');
                                </script>
                            </f:verbatim>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 
