<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "@(#)$Id: EditProperties.jsp 1498 2011-03-08 20:25:58Z shefali $ Oracle" -->

<!-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. --> 
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Util.js"/>
		    <ui:link url="../../../css/blueswan.css"/>
                </ui:head>    
                <ui:body focus="f1:p2:a1:s1:p1:i1_editable"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="dtus"/>
                        <ui:alert binding ="#{statusMessage.alert}"/>
        
                        <ui:breadcrumbs>
                            <ui:hyperlink text="#{msg.dtu_breadcrump_dtus_links}"
                                          action="viewDesktopUnits"
                                          immediate="true"
                                          toolTip="#{msg.dtu_breadcrump_dtus_tooltip}"/>
                            <ui:hyperlink text="#{dtu.id}" 
                                          toolTip="#{msg.dtu_id_link_tooltip}"/>
                        </ui:breadcrumbs>

                        <ui:contentPageTitle id="p2" title="#{msg.dtu_edit_pageTitle} - #{dtu.id}">

                            <f:facet name="pageButtonsBottom">
                                <ui:panelGroup> 
                                    <ui:button id="ok_submit"
                                               text="#{msg.ok_button}"
                                               primary="true"
                                               action="#{dtu.save}"
                                               toolTip="#{msg.dtu_edit_ok_button_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel"
                                               text="#{msg.cancel_button}"
                                               action="viewDesktopUnitDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_edit_cancel_button_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet>
                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="ok_submit"
                                               text="#{msg.ok_button}"
                                               primary="true"
                                               action="#{dtu.save}"
                                               toolTip="#{msg.dtu_edit_ok_button_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel"
                                               text="#{msg.cancel_button}"
                                               action="viewDesktopUnitDetails"
                                               immediate="true"
                                               toolTip="#{msg.dtu_edit_cancel_button_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/>
                                </ui:panelGroup> 
                            </f:facet>

                            <ui:propertySheet id="a1">
                                <ui:propertySheetSection id="s1"
                                                         label="#{msg.dtu_general_section}">
                                    <ui:property id="p1"
                                                 label="#{msg.dtu_location}"
                                                 labelAlign="right">
                                        <ui:textField id="i1_editable"
                                                      text="#{dtu.location}" 
                                                      columns="50"
                                                      onKeyUp="javascript: setTimeout('toggleEditButtons()', 0);"
                                                      onChange="javascript: setTimeout('toggleEditButtons()', 0);"
                                                      toolTip="#{msg.dtu_location_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p2"
                                                 label="#{msg.dtu_description}"
                                                 labelAlign="right">
                                        <ui:textField id="i2_editable"
                                                      text="#{dtu.description}"
                                                      columns="50"
                                                      onKeyUp="javascript: setTimeout('toggleEditButtons()', 0);"
                                                      onChange="javascript: setTimeout('toggleEditButtons()', 0);"
                                                      toolTip="#{msg.dtu_description_tooltip}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>
                                <ui:propertySheetSection id="s3"
                                                         label="#{msg.dtu_advanced_section}">
                                    <ui:property id="p1"
                                                 label="#{msg.dtu_token_reader}"
                                                 helpText="#{msg.dtu_token_reader_helpText}"
                                                 labelAlign="right">
                                        <ui:checkbox id="i1_editable" selected="#{dtu.configuredTokenReader}"
                                                     toolTip="#{msg.dtu_token_reader_tooltip}"
                                                     onClick="javascript: toggleEditButtons()" />
                                        <ui:staticText text="#{msg.dtu_token_reader_checkbox}"/>
                                    </ui:property>
                                </ui:propertySheetSection>
                            </ui:propertySheet>
                        </ui:contentPageTitle>
                        <ui:script>
                            <f:verbatim>
                                initValues();
                                toggleEditButtons();
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 

