#!/bin/sh
#
# Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# Script to map smartcard token to individual VM using either
# the "User Name" or "Other Info" field of the output from
# utuser -p <token>
#
# Look at output from utuser -p ${SUN_SUNRAY_TOKEN} and grab username
#
#  % utuser -p user.1140788210-7053
#  Current Properties:
#  User Name          = tester5
#    Other Info         = host
#    Server Name        = localhost
#  Server Port        = 7007
#  Logical Token      = user.1140788210-7053
#  User Created       = 02/24/2006 13:36:50
#
#  Token                                     Enabled?
#  ----------------------------------------  --------
#  Payflex.500af8ad00130100                  Yes
#
#  Currently Logged In:
#  Current Desktop    = 0003bad7566e
#  Desktop Location   =
#  Logged In Since    = 02/24/2006 13:36:58
#
PATH=/bin:/usr/bin
SRTOKEN=`echo $SUN_SUNRAY_TOKEN | cut -d. -f1`

USER_ID=`/opt/SUNWut/sbin/utuser -p $SUN_SUNRAY_TOKEN | grep "User Name" | cut -d= -f2-`
if [ -z "$USER_ID"  ]; then
    echo $SUN_SUNRAY_TOKEN
else
    echo $USER_ID
fi        


