/*
 * Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved.
 */

#ifndef UTADEM_H__
#define	UTADEM_H__

#pragma ident   "@(#)utadem.h	1.11    11/03/07 Oracle"

#ifdef _SCCSID
static char __attribute__ ((unused)) *_SCCSid_UTADEM_H = "@(#)utadem.h	1.11 11/03/07 Oracle";
#endif	/* defined _SCCSID */

#include <linux/version.h>

#if defined(CONFIG_COMPAT) || defined(CONFIG_SPARC64) || defined(CONFIG_X86_64) || defined(CONFIG_PPC64)
#include <asm/uaccess.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,22)
#include <linux/ioctl32.h>
#endif
#include <linux/compat.h>
#endif	/* CONFIG_COMPAT */

#ifdef __cplusplus
extern "C" {
#endif	/* defined __cplusplus */

#define	UTADEM_VERSION		0x000c

/* version interpretation */
#define	UTADEM_VER_MAJOR(x)	(((x) & 0xff00) >> 8)
#define	UTADEM_VER_MINOR(x)	(((x) & 0x00ff))

/*
 * protocol message format - sent from kernel to daemon
 */
struct utadem_msg {
	uint32_t version;	/* UTADEM_VERSION of the driver */
	uint32_t msgtype;	/* UTADEM_MSG_* */
	uint32_t arg;
};

/*
 * values for msgtype
 */
#define	UTADEM_MSG_JOINED	1 /* user opened session; arg = sessid */
#define	UTADEM_MSG_LEFT		2 /* user closed session; arg = sessid */
#define	UTADEM_MSG_PLAY		3 /* start playback; arg ignored */
#define	UTADEM_MSG_RECORD	4 /* start recording; arg ignored */
#define	UTADEM_MSG_SETFORMAT	5 /* set format; arg = negotiated format */
#define	UTADEM_MSG_SETRATE	6 /* set sampling rate; arg = Hz */
#define	UTADEM_MSG_SETCHANNELS	7 /* set number of channels; arg = nchannels */
#define	UTADEM_MSG_RESET	8 /* stop processing; arg = ACK required? */
#define	UTADEM_MSG_SYNC		9 /* drain buffers and RESET; arg ignored */
#define	UTADEM_MSG_MIXER	10 /* mixer; arg: 16MSB=value, 16LSB=channel */
#define	UTADEM_MSG_SETINSRC	11 /* set input source; arg = mask of devs */
#define	UTADEM_MSG_SETOUTSRC	12 /* set output source; arg = mask of devs */
#define	UTADEM_MSG_SETFRAGSIZE  13 /* set fragment size ; arg = # of bytes */

/*
 * daemon capabilities - sent from daemon to kernel
 */
struct utadem_dcaps {
	uint32_t version;	/* UTADEM_VERSION of the daemon */
	uint32_t formats;	/* bitmask of OSS formats supported */
	uint32_t channels;	/* bitmask of channel counts (max 32) */
	uint32_t rate_min;	/* range of sample rates */
	uint32_t rate_max;
	uint32_t def_format;	/* default format */
	uint32_t def_channels;	/* default channel count */
	uint32_t def_rate;	/* default sample rate */
};

/*
 * mixer state - sent from daemon to kernel
 */
struct utadem_mixdev {
	uint16_t channels;	/* number of channels - 0 == off */
	uint16_t level;		/* current value = 0-100 */
	uint8_t insrc;		/* is the device a recording source? */
	uint8_t outsrc;		/* is the device a playback source? */
};
#define	UTADEM_MIXER_NDEVS	32

/* Linux note: have to avoid ioctl definitions in <linux/usbdevice_fs.h> */
/* ioctls */
#define	UTA_IOC_BASE		'U'
#define	UTAIO_GETVERSION	_IOR(UTA_IOC_BASE, 0x30, unsigned int)
#define	UTAIO_NEWSESSION	_IO(UTA_IOC_BASE, 0x31)
#define	UTAIO_GETMSG		_IOR(UTA_IOC_BASE, 0x32, struct utadem_msg)
#define	UTAIO_SETDCAPS		_IOW(UTA_IOC_BASE, 0x33, struct utadem_dcaps)
#define	UTAIO_ACKRESET		_IO(UTA_IOC_BASE, 0x34)
#define	UTAIO_ACKSYNC		_IO(UTA_IOC_BASE, 0x35)
#define	UTAIO_SETMIXER		_IOW(UTA_IOC_BASE, 0x36, struct utadem_mixdev *)
#define	UTAIO_UNDERRUN		_IO(UTA_IOC_BASE, 0x37)
#define	UTAIO_OVERRUN		_IO(UTA_IOC_BASE, 0x38)

#if defined(CONFIG_COMPAT) || defined(CONFIG_SPARC64) || defined(CONFIG_X86_64) || defined(CONFIG_PPC64)
#define	COMPAT_UTAIO_SETMIXER	_IOW(UTA_IOC_BASE, 0x36, compat_uptr_t)
#endif	/* CONFIG_COMPAT */

#ifdef __cplusplus
}
#endif	/* defined __cplusplus */

#endif /* UTADEM_H__ */
