/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;

public class ConditionalExpression
extends Expression {
    Expression mCondition;
    Expression mTrueBranch;
    Expression mFalseBranch;

    public Expression getCondition() {
        return this.mCondition;
    }

    public void setCondition(Expression pCondition) {
        this.mCondition = pCondition;
    }

    public Expression getTrueBranch() {
        return this.mTrueBranch;
    }

    public void setTrueBranch(Expression pTrueBranch) {
        this.mTrueBranch = pTrueBranch;
    }

    public Expression getFalseBranch() {
        return this.mFalseBranch;
    }

    public void setFalseBranch(Expression pFalseBranch) {
        this.mFalseBranch = pFalseBranch;
    }

    public ConditionalExpression(Expression pCondition, Expression pTrueBranch, Expression pFalseBranch) {
        this.mCondition = pCondition;
        this.mTrueBranch = pTrueBranch;
        this.mFalseBranch = pFalseBranch;
    }

    public String getExpressionString() {
        return "( " + this.mCondition.getExpressionString() + " ? " + this.mTrueBranch.getExpressionString() + " : " + this.mFalseBranch.getExpressionString() + " )";
    }

    public Object evaluate(ExpressionInfo exprInfo) throws ElException {
        boolean condition = Coercions.coerceToBoolean(this.mCondition.evaluate(exprInfo));
        if (condition) {
            return this.mTrueBranch.evaluate(exprInfo);
        }
        return this.mFalseBranch.evaluate(exprInfo);
    }
}

