/*
 * Decompiled with CFR 0.152.
 */
package auth.utguiauth;

import auth.utguiauth.AbstractPamAuthCallback;
import auth.utguiauth.ConnectMessage;
import auth.utguiauth.DisconnectMessage;
import auth.utguiauth.PamDialogError;
import auth.utguiauth.PamDone;
import auth.utguiauth.UTguiauthMessage;
import auth.utguiauth.UTguiauthMessageFactory;
import com.sun.ut.utils.Prodinfo;
import com.sun.ut.utils.SimpleProcess;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

class PamDaemon {
    private static final String PIPEDIR = "/var/opt/" + Prodinfo.optInstallDir + "/tmp/pipes/";
    private static final String BASEDIR = Prodinfo.basedir((String)"uta");
    private static final String LIBDIR = BASEDIR + "/" + Prodinfo.optInstallDir + "/lib";
    private static final String utguiauthServiceName = LIBDIR + "/utguiauth";
    private SimpleProcess proc;
    private BufferedInputStream input = null;
    private BufferedOutputStream output = null;
    private String pid;
    private String serviceName;
    private AbstractPamAuthCallback pamAuthCallback;
    private String inpipeName;
    private String outpipeName;

    PamDaemon(String serviceName, AbstractPamAuthCallback pamAuthCallback) {
        boolean connected = false;
        this.serviceName = serviceName;
        this.pamAuthCallback = pamAuthCallback;
        try {
            this.daemonSetup();
            connected = true;
            while (true) {
                UTguiauthMessage msg = new UTguiauthMessageFactory().createMessage(this.input, this.output, pamAuthCallback);
                msg.parse();
                msg.dispatch();
            }
        }
        catch (PamDone pd) {
            if (pd instanceof PamDialogError) {
                pamAuthCallback.serverInterrupted();
                if (pamAuthCallback.isDone()) {
                    System.err.println("Read interrupted: " + pd.getMessage());
                }
            } else {
                connected = false;
            }
            if (connected) {
                try {
                    DisconnectMessage.send(this.output);
                }
                catch (PamDone pd2) {
                    // empty catch block
                }
            }
            pamAuthCallback.shutdownComplete();
            return;
        }
    }

    private void daemonSetup() throws PamDialogError {
        String utguiauthPipeName = null;
        this.pid = System.getProperty("pid");
        utguiauthPipeName = "register." + this.serviceName + "." + this.pid;
        this.inpipeName = PIPEDIR + utguiauthPipeName + ".in";
        this.outpipeName = PIPEDIR + utguiauthPipeName + ".out";
        try {
            String cmd = utguiauthServiceName + " -s utselfreg " + utguiauthPipeName;
            this.proc = new SimpleProcess().exec(cmd);
            if (!this.waitForPipes(this.inpipeName, this.outpipeName)) {
                throw new PamDialogError("Timeout waiting for utguiauth pipes");
            }
            this.output = new BufferedOutputStream(new FileOutputStream(this.inpipeName));
            this.input = new BufferedInputStream(new FileInputStream(this.outpipeName));
        }
        catch (Exception e) {
            throw new PamDialogError("Problem contacting daemon: " + e);
        }
        ConnectMessage.send(this.output);
    }

    boolean waitForPipes(String in, String out) throws InterruptedException {
        File fin = new File(in);
        File fout = new File(out);
        int i = 0;
        int sleepms = 500;
        while (!(fin.exists() && fout.exists() || i >= 5)) {
            Thread.sleep(sleepms);
            ++i;
            sleepms *= 2;
        }
        return fin.exists() && fout.exists();
    }

    protected void finalize() {
        new File(this.inpipeName).delete();
        new File(this.outpipeName).delete();
    }
}

