/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.dtus;

import com.sun.ut.console.I18N;
import com.sun.web.ui.model.Option;
import java.util.ArrayList;

public class SearchCriteria {
    public static final String ALL = "all";
    public static final String CURRENT_DTUS = "current";
    public static final String TOKEN_READERS = "readers";
    public static final String MULTIHEAD_GROUPS = "multiheads";
    public static final String DEFAULT_SEARCH_STRING = "*";
    private Option[] filterOptions;
    private String filter;
    private String searchString;

    public SearchCriteria() {
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(new Option((Object)ALL, I18N.getResource("dtu_title_all")));
        options.add(new Option((Object)CURRENT_DTUS, I18N.getResource("dtu_title_current")));
        options.add(new Option((Object)TOKEN_READERS, I18N.getResource("dtu_title_token_readers")));
        options.add(new Option((Object)MULTIHEAD_GROUPS, I18N.getResource("dtu_title_multihead")));
        this.filterOptions = new Option[options.size()];
        this.filterOptions = options.toArray(this.filterOptions);
        this.setFilter(ALL);
        this.setSearchString(DEFAULT_SEARCH_STRING);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString.length() == 0 ? DEFAULT_SEARCH_STRING : searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public Option[] getOptions() {
        return this.filterOptions;
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        if (this.filter.equals(CURRENT_DTUS)) {
            buffer.append(I18N.getResource("dtu_title_current"));
        } else if (this.filter.equals(TOKEN_READERS)) {
            buffer.append(I18N.getResource("dtu_title_token_readers"));
        } else if (this.filter.equals(MULTIHEAD_GROUPS)) {
            buffer.append(I18N.getResource("dtu_title_multihead"));
        } else if (this.filter.equals(ALL)) {
            buffer.append(I18N.getResource("dtu_title_all"));
        } else if (!this.searchString.equals(DEFAULT_SEARCH_STRING)) {
            buffer.append(I18N.getResource("dtu_title_all"));
        }
        if (!this.searchString.equals(DEFAULT_SEARCH_STRING)) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("\"");
            buffer.append(this.searchString);
            buffer.append("\"");
        }
        return buffer.toString();
    }

    public boolean isSearchActive() {
        if (!this.searchString.equals(DEFAULT_SEARCH_STRING)) {
            return true;
        }
        return !this.filter.equals(ALL);
    }

    public String cancelSearch() {
        this.setFilter(ALL);
        this.setSearchString(DEFAULT_SEARCH_STRING);
        return "success";
    }
}

