/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.login;

import com.sun.ut.service.AdminContext;
import java.util.Date;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionListener
implements HttpSessionListener {
    private static final long ONE_SECOND = 1000L;

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        AdminContext ctx = (AdminContext)session.getAttribute("AdminContext");
        if (ctx != null) {
            ctx.init();
            String userName = ctx.getUserName();
            if (userName != null) {
                boolean isTimeout = session.getAttribute("invalid session") == null;
                Date startTime = (Date)ctx.getEnvironment().get("Start Time");
                Date currentTime = new Date();
                long sessionLength = currentTime.getTime() - startTime.getTime();
                String clientId = (String)ctx.getEnvironment().get("Client ID");
                String duration = ctx.getAuditService().getFormattedDuration(sessionLength);
                Object[] args = new Object[]{userName, clientId, duration};
                if (isTimeout) {
                    ctx.getAuditService().publishEvent("authentication_timeout", args);
                } else {
                    ctx.getAuditService().publishEvent("authentication_logout", args);
                }
            }
            ctx.getLogger().finest("End HTTP session");
            ctx.release();
        }
    }
}

