/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.KioskDescriptor;

public class KioskApplication {
    public static final String TYPE_DESCRIPTOR = "desc";
    public static final String TYPE_EXECUTABLE = "exec";
    public static final String MODE_USER = "user";
    public static final String MODE_AUTO = "auto";
    public static final String MODE_CRITICAL = "critical";
    private KioskDescriptor descriptor;
    private String path;
    private String type;
    private String mode;
    private String descriptorId;
    private String args = "";
    private boolean customPath;

    public KioskApplication(KioskDescriptor descriptor, String mode, String args) {
        this.descriptor = descriptor;
        this.type = TYPE_DESCRIPTOR;
        this.mode = mode;
        if (args != null) {
            this.args = args;
        }
    }

    public KioskApplication(String path, String type, String mode, String args) {
        this.path = path;
        this.type = type;
        this.mode = mode;
        if (args != null) {
            this.args = args;
        }
        if (path != null) {
            this.customPath = true;
        }
    }

    public KioskApplication(KioskApplication application) {
        this.setApplication(application);
    }

    public void setApplication(KioskApplication application) {
        if (application == null) {
            return;
        }
        this.descriptor = application.descriptor;
        if (application.descriptor != null) {
            this.descriptor = new KioskDescriptor(application.descriptor);
        }
        this.path = application.path;
        this.type = application.type;
        this.mode = application.mode;
        if (application.args != null) {
            this.args = application.args;
        }
        this.customPath = false;
        if (this.path != null) {
            this.customPath = true;
        }
    }

    public KioskDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(KioskDescriptor newDescriptor) {
        this.descriptor = newDescriptor;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getId() {
        if (this.descriptor != null) {
            return this.descriptor.getId();
        }
        return this.path;
    }

    public String getLabel() {
        if (this.descriptor != null) {
            return this.descriptor.getLabel();
        }
        return this.path;
    }

    public boolean isCustomPath() {
        return this.customPath;
    }

    public void setCustomPath(boolean newCustomPath) {
        this.customPath = newCustomPath;
    }

    public boolean isPredefined() {
        return !this.customPath;
    }

    public void setPredefined(boolean newCustomPath) {
        this.customPath = !newCustomPath;
    }

    public String getDescriptorId() {
        if (this.descriptor != null) {
            this.descriptorId = this.descriptor.getId();
        }
        return this.descriptorId;
    }

    public void setDescriptorId(String newDescriptorId) {
        this.descriptorId = newDescriptorId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("descriptor={");
        sb.append(this.descriptor);
        sb.append("}");
        sb.append(", path=");
        sb.append(this.path);
        sb.append(", type=");
        sb.append(this.type);
        sb.append(", mode=");
        sb.append(this.mode);
        sb.append(", args=");
        sb.append(this.args);
        return sb.toString();
    }
}

