/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import java.util.ArrayList;
import java.util.List;

public class Policy {
    public static final String OPTION_SEPARATOR = " ";
    public static final String APPLY_POLICY = "-a";
    public static final String AUTHENTICATION_NOT_REQUIRED = "-p";
    public static final String MULTIHEAD_ENABLED = "-m";
    public static final String NSCM_ENABLED = "-M";
    public static final String NSCM_EXIT_DISABLED = "-d";
    public static final String REGISTERED_TOKENS_ACCESS = "-r";
    public static final String SELF_REGISTERED_TOKENS_ACCESS = "-s";
    public static final String UNREGISTERED_TOKENS_ACCESS = "-z";
    public static final String KIOSK_MODE = "-k";
    public static final String CARD_SESSIONS = "card";
    public static final String PSEUDO_SESSIONS = "pseudo";
    public static final String ALL_SESSIONS = "both";
    public static final String TERMINAL = "-t";
    public static final String TERMINAL_CLEAR = "clear";
    public static final String TERMINAL_ADD = "add:";
    private static final int NONE = 0;
    private static final int CARD = 1;
    private static final int PSEUDO = 2;
    private static final int ALL = 3;
    private boolean applyPolicy;
    private boolean nscmEnabled;
    private boolean nscmExitDisabled;
    private boolean multiheadEnabled;
    private boolean authenticationNotRequired;
    private int registeredTokensAccess;
    private int selfRegisteredTokensAccess;
    private int unregisteredTokensAccess;
    private int kioskMode;
    private List terminals;
    private List other;

    public Policy() {
        this.setContent(null);
    }

    public Policy(String content) {
        this.setContent(content);
    }

    public void setContent(String content) {
        this.parsePolicy(content);
    }

    public String getContent() {
        StringBuffer policy = new StringBuffer();
        this.appendOption(policy, APPLY_POLICY, this.applyPolicy);
        this.appendOption(policy, NSCM_ENABLED, this.nscmEnabled);
        this.appendOption(policy, NSCM_EXIT_DISABLED, this.nscmExitDisabled);
        this.appendOption(policy, MULTIHEAD_ENABLED, this.multiheadEnabled);
        this.appendOption(policy, REGISTERED_TOKENS_ACCESS, this.registeredTokensAccess);
        this.appendOption(policy, SELF_REGISTERED_TOKENS_ACCESS, this.selfRegisteredTokensAccess);
        this.appendOption(policy, AUTHENTICATION_NOT_REQUIRED, this.authenticationNotRequired);
        this.appendOption(policy, UNREGISTERED_TOKENS_ACCESS, this.unregisteredTokensAccess);
        this.appendOption(policy, KIOSK_MODE, this.kioskMode);
        for (int i = 0; i < this.other.size(); ++i) {
            policy.append(this.other.get(i));
            policy.append(OPTION_SEPARATOR);
        }
        int lastSeparator = policy.length() - 1;
        if (lastSeparator >= 0) {
            policy.delete(lastSeparator, lastSeparator);
        }
        return policy.toString();
    }

    private void appendOption(StringBuffer buffer, String option, boolean value) {
        if (value) {
            buffer.append(option);
            buffer.append(OPTION_SEPARATOR);
        }
    }

    private void appendOption(StringBuffer buffer, String option, int value) {
        if (value != 0) {
            buffer.append(option);
            buffer.append(OPTION_SEPARATOR);
            buffer.append(this.getAccessType(value));
            buffer.append(OPTION_SEPARATOR);
        }
    }

    private void parsePolicy(String policy) {
        this.applyPolicy = true;
        this.nscmEnabled = false;
        this.nscmExitDisabled = false;
        this.multiheadEnabled = false;
        this.authenticationNotRequired = false;
        this.registeredTokensAccess = 0;
        this.selfRegisteredTokensAccess = 0;
        this.unregisteredTokensAccess = 0;
        this.kioskMode = 0;
        this.terminals = new ArrayList();
        this.other = new ArrayList();
        if (policy != null) {
            String[] tokens = policy.split(OPTION_SEPARATOR);
            for (int i = 0; i < tokens.length; ++i) {
                if (APPLY_POLICY.equals(tokens[i])) {
                    this.applyPolicy = true;
                    continue;
                }
                if (NSCM_ENABLED.equals(tokens[i])) {
                    this.nscmEnabled = true;
                    continue;
                }
                if (NSCM_EXIT_DISABLED.equals(tokens[i])) {
                    this.nscmExitDisabled = true;
                    continue;
                }
                if (MULTIHEAD_ENABLED.equals(tokens[i])) {
                    this.multiheadEnabled = true;
                    continue;
                }
                if (REGISTERED_TOKENS_ACCESS.equals(tokens[i])) {
                    this.registeredTokensAccess = this.parseAccessType(this.registeredTokensAccess, tokens[++i]);
                    continue;
                }
                if (SELF_REGISTERED_TOKENS_ACCESS.equals(tokens[i])) {
                    this.selfRegisteredTokensAccess = this.parseAccessType(this.selfRegisteredTokensAccess, tokens[++i]);
                    continue;
                }
                if (AUTHENTICATION_NOT_REQUIRED.equals(tokens[i])) {
                    this.authenticationNotRequired = true;
                    continue;
                }
                if (UNREGISTERED_TOKENS_ACCESS.equals(tokens[i])) {
                    this.unregisteredTokensAccess = this.parseAccessType(this.unregisteredTokensAccess, tokens[++i]);
                    continue;
                }
                if (KIOSK_MODE.equals(tokens[i])) {
                    this.kioskMode = this.parseAccessType(this.kioskMode, tokens[++i]);
                    continue;
                }
                if (TERMINAL.equals(tokens[i])) {
                    this.other.add(tokens[i]);
                    this.other.add(tokens[++i]);
                    if (TERMINAL_CLEAR.equals(tokens[i])) {
                        this.terminals = new ArrayList();
                        continue;
                    }
                    if (!tokens[i].startsWith(TERMINAL_ADD)) continue;
                    this.terminals.add(tokens[i].substring(TERMINAL_ADD.length()));
                    continue;
                }
                this.other.add(tokens[i]);
            }
        }
    }

    private int parseAccessType(int currentAccess, String policy) {
        int result = currentAccess;
        if (CARD_SESSIONS.equals(policy)) {
            result |= 1;
        } else if (PSEUDO_SESSIONS.equals(policy)) {
            result |= 2;
        } else if (ALL_SESSIONS.equals(policy)) {
            result = result | 1 | 2;
        }
        return result;
    }

    private String getAccessType(int access) {
        if (access == 3) {
            return ALL_SESSIONS;
        }
        if (access == 1) {
            return CARD_SESSIONS;
        }
        if (access == 2) {
            return PSEUDO_SESSIONS;
        }
        return "";
    }

    public boolean isNscmEnabled() {
        return this.nscmEnabled;
    }

    public void setNscm(boolean enabled) {
        this.nscmEnabled = enabled;
    }

    public boolean isNscmExitAllowed() {
        return !this.nscmExitDisabled;
    }

    public void setNscmExit(boolean allowed) {
        this.nscmExitDisabled = !allowed;
    }

    public boolean isMultiheadEnabled() {
        return this.multiheadEnabled;
    }

    public void setMultihead(boolean enabled) {
        this.multiheadEnabled = enabled;
    }

    public boolean isUnixAuthenticationRequired() {
        return !this.authenticationNotRequired;
    }

    public void setUnixAuthentication(boolean required) {
        this.authenticationNotRequired = !required;
    }

    public String getRegisteredTokensAccess() {
        return this.getAccessType(this.registeredTokensAccess);
    }

    public void setRegisteredTokensAccess(String value) {
        this.registeredTokensAccess = this.parseAccessType(0, value);
    }

    public String getSelfRegisteredTokensAccess() {
        return this.getAccessType(this.selfRegisteredTokensAccess);
    }

    public void setSelfRegisteredTokensAccess(String value) {
        this.selfRegisteredTokensAccess = this.parseAccessType(0, value);
    }

    public String getUnregisteredTokensAccess() {
        return this.getAccessType(this.unregisteredTokensAccess);
    }

    public void setUnregisteredTokensAccess(String value) {
        this.unregisteredTokensAccess = this.parseAccessType(0, value);
    }

    public String getKioskMode() {
        return this.getAccessType(this.kioskMode);
    }

    public void setKioskMode(String value) {
        this.kioskMode = this.parseAccessType(0, value);
    }

    public List getTerminalReaders() {
        return this.terminals;
    }

    public boolean isTerminalReader(String id) {
        if (this.terminals.isEmpty()) {
            return false;
        }
        String search = id;
        if (id.indexOf(".") < 0) {
            search = "IEEE802." + id;
        }
        return this.terminals.contains(search);
    }
}

