/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import java.io.Serializable;
import java.util.StringTokenizer;

public class Security
implements Serializable {
    public static final int MODE_SOFT = 0;
    public static final int MODE_HARD = 1;
    private static final String KEY_ENC_UP = "enc_up_type";
    private static final String KEY_ENC_DOWN = "enc_down_type";
    private static final String KEY_AUTH_UP = "auth_up_type";
    private static final String KEY_AUTH_DOWN = "auth_down_type";
    private static final String KEY_MODE = "mode";
    private boolean encUp;
    private boolean encDown;
    private boolean authUp;
    private boolean authDown;
    private int mode;

    public Security() {
    }

    public Security(boolean encUp, boolean encDown, boolean authUp, boolean authDown, int mode) {
        this.encUp = encUp;
        this.encDown = encDown;
        this.authUp = authUp;
        this.authDown = authDown;
        this.mode = mode;
    }

    public Security(String content) {
        this.setContent(content);
    }

    public Security(Security security) {
        this.encUp = security.encUp;
        this.encDown = security.encDown;
        this.authUp = security.authUp;
        this.authDown = security.authDown;
        this.mode = security.mode;
    }

    public void setEncUp(boolean encUp) {
        this.encUp = encUp;
    }

    public boolean isEncUp() {
        return this.encUp;
    }

    public void setEncDown(boolean encDown) {
        this.encDown = encDown;
    }

    public boolean isEncDown() {
        return this.encDown;
    }

    public void setAuthUp(boolean authUp) {
        this.authUp = authUp;
    }

    public boolean isAuthUp() {
        return this.authUp;
    }

    public void setAuthDown(boolean authDown) {
        this.authDown = authDown;
    }

    public boolean isAuthDown() {
        return this.authDown;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public String getContent() {
        StringBuffer sb = new StringBuffer();
        if (this.isEncUp()) {
            this.appendContent(sb, KEY_ENC_UP, "ARCFOUR");
        } else {
            this.appendContent(sb, KEY_ENC_UP, "none");
        }
        if (this.isEncDown()) {
            this.appendContent(sb, KEY_ENC_DOWN, "ARCFOUR");
        } else {
            this.appendContent(sb, KEY_ENC_DOWN, "none");
        }
        this.appendContent(sb, KEY_AUTH_UP, "none");
        if (this.isAuthDown()) {
            this.appendContent(sb, KEY_AUTH_DOWN, "simple");
        } else {
            this.appendContent(sb, KEY_AUTH_DOWN, "none");
        }
        if (this.getMode() == 0) {
            this.appendContent(sb, KEY_MODE, "soft");
        }
        if (this.getMode() == 1) {
            this.appendContent(sb, KEY_MODE, "hard");
        }
        return sb.toString();
    }

    protected void appendContent(StringBuffer buffer, String key, String value) {
        buffer.append(key);
        buffer.append("=");
        buffer.append(value);
        buffer.append("\n");
    }

    public void setContent(String contents) {
        this.encUp = false;
        this.encDown = false;
        this.authUp = false;
        this.authDown = false;
        this.mode = 0;
        StringTokenizer strtok = new StringTokenizer(contents, "\n");
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            int index = token.indexOf("=");
            if (index <= 0 || token.length() <= index + 1) continue;
            String key = token.substring(0, index);
            String value = token.substring(index + 1);
            if (key.equals(KEY_ENC_UP) && value.equals("ARCFOUR")) {
                this.encUp = true;
                continue;
            }
            if (key.equals(KEY_ENC_DOWN) && value.equals("ARCFOUR")) {
                this.encDown = true;
                continue;
            }
            if (key.equals(KEY_AUTH_DOWN) && value.equals("simple")) {
                this.authDown = true;
                continue;
            }
            if (!key.equals(KEY_MODE) || !value.equals("hard")) continue;
            this.mode = 1;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("encUp=");
        sb.append(this.encUp);
        sb.append(", encDown=");
        sb.append(this.encDown);
        sb.append(", authUp=");
        sb.append(this.authUp);
        sb.append(", authDown=");
        sb.append(this.authDown);
        sb.append(", mode=");
        sb.append(this.mode);
        return sb.toString();
    }
}

