/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.Kiosk;
import com.sun.ut.service.KioskApplication;
import com.sun.ut.service.KioskDescriptor;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.KioskDesc;
import com.sun.ut.service.jni.Datastore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class KioskDescTest
extends TestCase {
    private static final String KIOSK_PATH = "/etc/opt/SUNWkio/";
    private static final String KIOSK_SESSIONS_DIR = "/etc/opt/SUNWkio/sessions";
    private static final String KIOSK_APPLICATIONS_DIR = "/etc/opt/SUNWkio/applications";
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private Datastore ds;
    private String backupKiosk;
    private ArrayList sessionDescs;
    private ArrayList appDescs;
    private Kiosk testKiosk;
    private static final String[] TEST_SESSION_DESCRIPTOR = new String[]{"unittest", "\"Unit Test\"", "/path/to/icon", "\"Unit Test Descriptor Description\""};
    private static final String[] TEST_APP_DESCRIPTOR = new String[]{"unittestapp", "\"Unit Test App\"", "/path/to/app/icon", "\"Unit Test App Descriptor Description\""};
    private static final String[] TEST_KIOSK = new String[]{"15000", "1000", "2000", "3000", "4000", "en", "-args"};
    private static final String[] TEST_RECOMMENDATIONS = new String[]{"500", "1000", "1500", "200", "2500", "en-US", "\"-a -b\""};
    private static final String[] TEST_APPLICATION = new String[]{"/path/to/app", "exec", "auto", "-args"};

    protected final void setUp() throws ServiceException {
        KioskDesc cmd = new KioskDesc();
        KioskDescriptor sessionDesc = cmd.getKioskDescriptor(TEST_SESSION_DESCRIPTOR[0], this.getSessionDescriptor(), "-s");
        this.sessionDescs = new ArrayList();
        this.sessionDescs.add(sessionDesc);
        KioskDescriptor appDesc = cmd.getKioskDescriptor(TEST_APP_DESCRIPTOR[0], this.getApplicationDescriptor(), "-a");
        this.appDescs = new ArrayList();
        this.appDescs.add(appDesc);
    }

    protected final void tearDown() throws ServiceException {
        this.sessionDescs = null;
        this.appDescs = null;
    }

    public void testGetKioskSessionDescriptors() throws ServiceException {
        KioskDesc cmd = new KioskDesc();
        KioskDescriptor testDesc = null;
        Iterator it = this.sessionDescs.iterator();
        while (it.hasNext()) {
            KioskDescriptor desc = (KioskDescriptor)it.next();
            if (desc.getId() != TEST_SESSION_DESCRIPTOR[0]) continue;
            testDesc = desc;
            break;
        }
        KioskDescTest.assertNotNull((String)"No Session Descriptors Found!.", testDesc);
        this.testSessionDescriptorEquality(testDesc);
    }

    public void testGetKioskApplicationDescriptors() throws ServiceException {
        KioskDesc cmd = new KioskDesc();
        KioskDescriptor testDesc = null;
        Iterator it = this.appDescs.iterator();
        while (it.hasNext()) {
            KioskDescriptor desc = (KioskDescriptor)it.next();
            if (desc.getId() != TEST_APP_DESCRIPTOR[0]) continue;
            testDesc = desc;
            break;
        }
        KioskDescTest.assertNotNull((String)"No Application Descriptors Found!.", testDesc);
        this.testApplicationDescriptorEquality(testDesc);
    }

    public void testGetKiosk() throws ServiceException {
        KioskDesc cmd = new KioskDesc();
        Kiosk kiosk = cmd.getKiosk(this.sessionDescs, this.appDescs, this.getKioskContents(true, true));
        KioskDescTest.assertNotNull((String)"No Kiosk Info Found!.", (Object)kiosk);
        this.testSessionDescriptorEquality(kiosk.getDescriptor());
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk Timeout value!", (boolean)TEST_KIOSK[0].equals(kiosk.getTimeout()));
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk Max CPU value!", (boolean)TEST_KIOSK[1].equals(kiosk.getMaxCPU()));
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk Max VM value!", (boolean)TEST_KIOSK[2].equals(kiosk.getMaxVM()));
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk Max Files value!", (boolean)TEST_KIOSK[3].equals(kiosk.getMaxFiles()));
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk Max File Size value!", (boolean)TEST_KIOSK[4].equals(kiosk.getMaxFileSize()));
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk Locale value!", (boolean)TEST_KIOSK[5].equals(kiosk.getLocale()));
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk Args value!", (boolean)TEST_KIOSK[6].equals(kiosk.getArgs()));
        List kioskApps = kiosk.getApplications();
        KioskDescTest.assertNotNull((String)"No Kiosk Applications Found!.", (Object)kioskApps);
        KioskDescTest.assertTrue((String)"Returned wrong number of Kiosk Applications!.", (kioskApps.size() == 2 ? 1 : 0) != 0);
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk App Path value!", (boolean)((KioskApplication)kioskApps.get(0)).getPath().equals(TEST_APPLICATION[0]));
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk App Type value!", (boolean)((KioskApplication)kioskApps.get(0)).getType().equals(TEST_APPLICATION[1]));
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk App Mode value!", (boolean)((KioskApplication)kioskApps.get(0)).getMode().equals(TEST_APPLICATION[2]));
        KioskDescTest.assertTrue((String)"Returned wrong Kiosk App Args value!", (boolean)((KioskApplication)kioskApps.get(0)).getArgs().equals(TEST_APPLICATION[3]));
        this.testApplicationDescriptorEquality(((KioskApplication)kioskApps.get(1)).getDescriptor());
    }

    public void testGetKioskExceptions() throws ServiceException {
        Kiosk kiosk;
        KioskDesc cmd = new KioskDesc();
        try {
            kiosk = cmd.getKiosk(this.sessionDescs, this.appDescs, this.getKioskContents(false, true));
            KioskDescTest.fail((String)"Non existing session descriptor should raise a ServiceException");
        }
        catch (ServiceException se) {
            System.out.println(cmd.getSyntax());
            System.out.println(se.getMessage());
        }
        try {
            kiosk = cmd.getKiosk(this.sessionDescs, this.appDescs, this.getKioskContents(true, false));
            KioskDescTest.fail((String)"Non existing application descriptor should raise a ServiceException");
        }
        catch (ServiceException se) {
            System.out.println(cmd.getSyntax());
            System.out.println(se.getMessage());
        }
    }

    private void testSessionDescriptorEquality(KioskDescriptor testDesc) {
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Id!.", (boolean)TEST_SESSION_DESCRIPTOR[0].equals(testDesc.getId()));
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Label!.", (boolean)TEST_SESSION_DESCRIPTOR[1].equals(testDesc.getLabel()));
        KioskDescTest.assertTrue((String)"Returned wrong value for whether Session Descriptor is a Launcher!.", (boolean)testDesc.isLauncher());
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Icon!.", (boolean)TEST_SESSION_DESCRIPTOR[2].equals(testDesc.getIcon()));
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Description!.", (boolean)TEST_SESSION_DESCRIPTOR[3].equals(testDesc.getDescription()));
        Kiosk recommendations = testDesc.getRecommendations();
        KioskDescTest.assertNotNull((String)"Session Descriptor Recommendations are not Null!.", (Object)recommendations);
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Recommendations for Timeout!.", (boolean)TEST_RECOMMENDATIONS[0].equals(recommendations.getTimeout()));
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Recommendations for Max CPU!.", (boolean)TEST_RECOMMENDATIONS[1].equals(recommendations.getMaxCPU()));
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Recommendations for Max VM!.", (boolean)TEST_RECOMMENDATIONS[2].equals(recommendations.getMaxVM()));
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Recommendations for Max Files!.", (boolean)TEST_RECOMMENDATIONS[3].equals(recommendations.getMaxFiles()));
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Recommendations for Max File Size!.", (boolean)TEST_RECOMMENDATIONS[4].equals(recommendations.getMaxFileSize()));
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Recommendations for Locale!.", (boolean)TEST_RECOMMENDATIONS[5].equals(recommendations.getLocale()));
        KioskDescTest.assertTrue((String)"Returned wrong Session Descriptor Recommendations for Args!.", (boolean)TEST_RECOMMENDATIONS[6].equals(recommendations.getArgs()));
    }

    private void testApplicationDescriptorEquality(KioskDescriptor testDesc) {
        KioskDescTest.assertTrue((String)"Returned wrong Application Descriptor Id!.", (boolean)TEST_APP_DESCRIPTOR[0].equals(testDesc.getId()));
        KioskDescTest.assertTrue((String)"Returned wrong Application Descriptor Label!.", (boolean)TEST_APP_DESCRIPTOR[1].equals(testDesc.getLabel()));
        KioskDescTest.assertFalse((String)"Returned wrong value for whether Application Descriptor is a Launcher!.", (boolean)testDesc.isLauncher());
        KioskDescTest.assertTrue((String)"Returned wrong Application Descriptor Icon!.", (boolean)TEST_APP_DESCRIPTOR[2].equals(testDesc.getIcon()));
        KioskDescTest.assertTrue((String)"Returned wrong Application Descriptor Description!.", (boolean)TEST_APP_DESCRIPTOR[3].equals(testDesc.getDescription()));
    }

    private String getKioskContents(boolean sessionDescExists, boolean appDescExists) {
        KioskDesc cmd = new KioskDesc();
        KioskDescriptor sessionDesc = cmd.getKioskDescriptor("unmatchedsession", this.getSessionDescriptor(), "-s");
        if (sessionDescExists) {
            sessionDesc = cmd.getKioskDescriptor(TEST_SESSION_DESCRIPTOR[0], this.getSessionDescriptor(), "-s");
        }
        KioskDescriptor appDesc = cmd.getKioskDescriptor("unmatchedapp", this.getApplicationDescriptor(), "-a");
        if (appDescExists) {
            appDesc = cmd.getKioskDescriptor(TEST_APP_DESCRIPTOR[0], this.getApplicationDescriptor(), "-a");
        }
        KioskApplication descApp = new KioskApplication(appDesc, "user", null);
        KioskApplication execApp = new KioskApplication(TEST_APPLICATION[0], TEST_APPLICATION[1], TEST_APPLICATION[2], TEST_APPLICATION[3]);
        ArrayList<KioskApplication> applications = new ArrayList<KioskApplication>();
        applications.add(execApp);
        applications.add(descApp);
        Kiosk kiosk = new Kiosk(sessionDesc, TEST_KIOSK[0], TEST_KIOSK[1], TEST_KIOSK[2], TEST_KIOSK[3], TEST_KIOSK[4], TEST_KIOSK[5], TEST_KIOSK[6], applications);
        return kiosk.getContents();
    }

    private String getSessionDescriptor() {
        StringBuffer buf = new StringBuffer();
        buf.append("KIOSK_SESSION_EXEC=/etc/opt/SUNWbb/sessions/unittest").append("\nKIOSK_SESSION_LABEL=\"Unit Test\"").append("\nKIOSK_SESSION_PRE=").append("\nKIOSK_SESSION_POST=").append("\nKIOSK_SESSION_APPLAUNCHER=/etc/opt/SUNWbb/session/unittest").append("\nKIOSK_SESSION_APPLIST=unittest").append("\nKIOSK_SESSION_DESCRIPTION=\"Unit Test Descriptor Description\"").append("\nKIOSK_SESSION_ICON=/path/to/icon").append("\n").append("\n# Default values").append("\nKIOSK_SESSION_TIMEOUT_DETACHED=500").append("\nKIOSK_SESSION_LIMIT_CPU=1000").append("\nKIOSK_SESSION_LIMIT_VMSIZE=1500").append("\nKIOSK_SESSION_LIMIT_DESCRIPTORS=200").append("\nKIOSK_SESSION_LIMIT_FILESIZE=2500").append("\nKIOSK_SESSION_LOCALE=en-US").append("\nKIOSK_SESSION_ARGS=\"-a -b\"");
        return buf.toString();
    }

    private String getApplicationDescriptor() {
        StringBuffer buf = new StringBuffer();
        buf.append("KIOSK_APP_EXEC=/path/to/app").append("\nKIOSK_APP_LABEL=\"Unit Test App\"").append("\nKIOSK_APP_PROTOTYPE=").append("\nKIOSK_APP_DESCRIPTION=\"Unit Test App Descriptor Description\"").append("\nKIOSK_APP_PRE=").append("\nKIOSK_APP_ICON=/path/to/app/icon");
        return buf.toString();
    }
}

