/*
 * Decompiled with CFR 0.152.
 */
package auth.utguiauth;

import auth.utguiauth.PamDialogError;
import auth.utguiauth.PamDone;
import auth.utguiauth.UTguiauthMessage;
import java.io.BufferedOutputStream;

class DataMessage
extends UTguiauthMessage {
    int style;
    String message;

    DataMessage() {
    }

    void parse() throws PamDialogError {
        String[] typeAndMessageFields = this.data.split(" ", 2);
        if (typeAndMessageFields.length != 2) {
            throw new PamDialogError("error: PAM DATA message poorly constructed (field count)");
        }
        try {
            this.style = Integer.parseInt(typeAndMessageFields[0]);
        }
        catch (NumberFormatException e) {
            throw new PamDialogError("error: PAM DATA message poorly constructed (number)");
        }
        this.message = typeAndMessageFields[1];
    }

    void dispatch() throws PamDone {
        this.pamAuthCallback.pamMsgCallback(this.message, this.style);
        switch (this.style) {
            case 1: 
            case 2: {
                String response;
                try {
                    response = this.pamAuthCallback.getPamResponse();
                }
                catch (InterruptedException intEx) {
                    throw new PamDialogError("wait for user response interrupted");
                }
                DataMessage.send(response, this.output);
            }
        }
    }

    static void send(String response, BufferedOutputStream output) throws PamDialogError {
        DataMessage.msgout(output, "DATA", response);
    }
}

