/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.model.scheduler.RepeatInterval;
import com.sun.web.ui.model.scheduler.RepeatUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

public class ScheduledEvent
implements Serializable {
    private Date startTime = null;
    private Date endTime = null;
    private ArrayList dateList = null;
    private boolean repeatingEvent = false;
    private static final boolean DEBUG = false;
    private RepeatInterval frequency = null;
    private RepeatUnit durationUnit = null;
    private Integer duration = null;

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.dateList = null;
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        this.dateList = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.getClass().getName());
        buffer.append(": Start time: ");
        buffer.append(this.startTime.toString());
        if (this.endTime != null) {
            buffer.append("\tEnd time: ");
            buffer.append(this.endTime.toString());
            buffer.append(" ");
        } else {
            buffer.append("\tNo end time. ");
        }
        if (this.isRepeatingEvent()) {
            buffer.append("\tThis is a repeating event. ");
            buffer.append("\t Repeat frequency (Calendar.field): ");
            buffer.append(String.valueOf(this.frequency));
            if (this.duration != null) {
                buffer.append("\tLimited duration of repeats.");
                buffer.append("\tDuration is ");
                buffer.append(String.valueOf(this.duration));
                buffer.append(" of unit (in Calendar.field) ");
                buffer.append(String.valueOf(this.durationUnit));
            }
        } else {
            buffer.append("\tThis is not a repeating event. ");
        }
        return buffer.toString();
    }

    public boolean isRepeatingEvent() {
        return this.repeatingEvent;
    }

    public void setRepeatingEvent(boolean repeatingEvent) {
        this.repeatingEvent = repeatingEvent;
    }

    public RepeatInterval getRepeatInterval() {
        return this.frequency;
    }

    public void setRepeatInterval(RepeatInterval frequency) {
        this.frequency = frequency;
        this.dateList = null;
    }

    public RepeatUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(RepeatUnit durationUnit) {
        this.durationUnit = durationUnit;
        this.dateList = null;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
        this.dateList = null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ScheduledEvent)) {
            return false;
        }
        ScheduledEvent event = (ScheduledEvent)object;
        if (this.getStartTime() == null ? event.getStartTime() != null : !this.getStartTime().equals(event.getStartTime())) {
            return false;
        }
        if (this.getEndTime() == null ? event.getEndTime() != null : !this.getEndTime().equals(event.getEndTime())) {
            return false;
        }
        if (this.getDuration() == null ? event.getDuration() != null : !this.getDuration().equals(event.getDuration())) {
            return false;
        }
        if (this.getDurationUnit() == null ? event.getDurationUnit() != null : !this.getDurationUnit().equals(event.getDurationUnit())) {
            return false;
        }
        return !(this.getRepeatInterval() == null ? event.getRepeatInterval() != null : !this.getRepeatInterval().equals(event.getRepeatInterval()));
    }

    public Iterator getDates(Calendar untilDate) {
        return this.getDates(null, untilDate);
    }

    public Iterator getDates(Calendar fromDate, Calendar untilDate) {
        if (this.dateList != null) {
            return this.dateList.iterator();
        }
        this.dateList = new ArrayList();
        Date date = this.getStartTime();
        Date from = null;
        if (fromDate != null) {
            from = fromDate.getTime();
        }
        if (date != null && date.before(untilDate.getTime())) {
            int interval;
            Calendar startDate = (Calendar)untilDate.clone();
            startDate.setTime(date);
            this.dateList.add(startDate.clone());
            if (this.isRepeatingEvent() && (interval = this.getRepeatInterval().getCalendarField().intValue()) > -1) {
                Calendar endCalendar = (Calendar)untilDate.clone();
                Integer duration = this.getDuration();
                RepeatUnit repeatUnit = this.getDurationUnit();
                Integer durationUnit = null;
                if (repeatUnit != null) {
                    durationUnit = repeatUnit.getCalendarField();
                }
                if (duration != null && durationUnit != null) {
                    int durationValue = duration;
                    int durationField = durationUnit;
                    if (durationValue > 0) {
                        endCalendar = (Calendar)startDate.clone();
                        endCalendar.add(durationField, durationValue - 1);
                        endCalendar.getTime();
                    }
                }
                Date end = endCalendar.getTime();
                Date current = startDate.getTime();
                int dayOfMonth = startDate.get(5);
                while (current.before(end)) {
                    startDate.add(interval, 1);
                    if (interval == 2 && startDate.get(5) != dayOfMonth) {
                        int difference = dayOfMonth - startDate.get(5);
                        startDate.setLenient(false);
                        try {
                            startDate.set(5, dayOfMonth);
                            startDate.getTime();
                        }
                        catch (Exception e) {
                            startDate.set(5, dayOfMonth - difference);
                        }
                    }
                    startDate.setLenient(true);
                    current = startDate.getTime();
                    if (from != null) {
                        if (!current.after(from)) continue;
                        this.dateList.add(startDate.clone());
                        continue;
                    }
                    this.dateList.add(startDate.clone());
                }
            }
        }
        return this.dateList.iterator();
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }
}

