/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console;

import com.sun.ut.console.Context;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class I18N {
    public static final String RESOURCE_BUNDLE = "com.sun.ut.console.resource.ConsoleLabels";

    public static ResourceBundle getResourceBundle(Locale locale) {
        StringBuffer buffer = new StringBuffer(RESOURCE_BUNDLE);
        buffer.append(locale);
        ResourceBundle bundle = (ResourceBundle)Context.getRequestAttribute(buffer.toString());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
            Context.setRequestAttribute(buffer.toString(), bundle);
        }
        return bundle;
    }

    public static String getResource(ResourceBundle bundle, String key, Object[] args) {
        String resource = null;
        try {
            if (key != null) {
                resource = bundle.getString(key);
                if (args != null) {
                    MessageFormat formatter = new MessageFormat(resource);
                    resource = formatter.format(args).toString();
                }
            }
        }
        catch (MissingResourceException e) {
            resource = key;
        }
        return resource;
    }

    public static String getResource(String key) {
        return I18N.getResource(I18N.getResourceBundle(Context.getLocale()), key, null);
    }

    public static String getResource(String key, Object[] args) {
        return I18N.getResource(I18N.getResourceBundle(Context.getLocale()), key, args);
    }

    public static String getDefaultResource(String key) {
        return I18N.getResource(I18N.getResourceBundle(Locale.ENGLISH), key, null);
    }

    public static String getDefaultResource(String key, Object[] args) {
        return I18N.getResource(I18N.getResourceBundle(Locale.ENGLISH), key, args);
    }

    private I18N() {
    }
}

