/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console;

import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;

public class MastheadNotification {
    public static final String NOTIFICATION = "notification";
    public static final String INFO = "ALERT_INFO_MEDIUM";
    public static final String WARNING = "ALERT_WARNING_MEDIUM";
    public static final String ERROR = "ALERT_ERROR_MEDIUM";
    private String type;
    private String summary;
    private String details;
    private String alertDetails;
    private boolean restartRequired;
    private boolean coldRestartRequired;

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getAlertDetails() {
        return this.alertDetails;
    }

    public void setAlertDetails(String alertDetails) {
        this.alertDetails = alertDetails;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRestartRequired(boolean restartRequired) {
        boolean pendingColdRestart = MastheadNotification.getNotification().isColdRestartRequired();
        if (!pendingColdRestart) {
            this.restartRequired = restartRequired;
            if (restartRequired) {
                this.setType(WARNING);
                this.setSummary(I18N.getResource("alert_restart_summary"));
                this.setDetails(I18N.getResource("alert_changes_require_restart"));
                this.setAlertDetails(I18N.getResource("servers_restart_alert_detail"));
            } else {
                this.setSummary(null);
                this.setDetails(null);
                this.setAlertDetails(null);
            }
        }
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public void setColdRestartRequired(boolean coldRestartRequired) {
        this.coldRestartRequired = coldRestartRequired;
        if (coldRestartRequired) {
            this.setType(WARNING);
            this.setSummary(I18N.getResource("alert_cold_restart_summary"));
            this.setDetails(I18N.getResource("alert_changes_require_cold_restart"));
            this.setAlertDetails(I18N.getResource("servers_cold_restart_alert_detail"));
        } else {
            this.setSummary(null);
            this.setDetails(null);
            this.setAlertDetails(null);
        }
    }

    public boolean isColdRestartRequired() {
        return this.coldRestartRequired;
    }

    public boolean isVisible() {
        return this.summary != null;
    }

    public static MastheadNotification getNotification() {
        MastheadNotification msg = (MastheadNotification)Context.getSessionAttribute(NOTIFICATION);
        if (msg == null) {
            msg = new MastheadNotification();
            Context.setSessionAttribute(NOTIFICATION, msg);
        }
        return msg;
    }
}

