/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.advanced;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.I18N;
import com.sun.ut.service.Devices;
import com.sun.ut.service.Security;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.model.Option;
import java.util.ArrayList;
import java.util.List;

public class SecurityHandler
extends BaseHandler {
    private ArrayList modeOptions;
    private Security security;
    private Devices devices;

    public SecurityHandler() {
        this.getSecurity();
        this.getDevices();
    }

    public Security getSecurity() {
        if (this.security == null) {
            try {
                this.security = this.getProvider().getSecurity();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("security_alert_get", se);
            }
        }
        return this.security;
    }

    public Devices getDevices() {
        if (this.devices == null) {
            try {
                this.devices = this.getProvider().getDevices();
            }
            catch (ServiceException se) {
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("devices_alert_get", se);
                this.devices = new Devices();
            }
        }
        return this.devices;
    }

    public List getModeOptions() {
        if (this.modeOptions == null) {
            this.modeOptions = new ArrayList();
            Option soft = new Option((Object)new Integer(0), I18N.getResource("security_mode_soft"));
            soft.setTooltip(I18N.getResource("security_mode_soft_tooltip"));
            Option hard = new Option((Object)new Integer(1), I18N.getResource("security_mode_hard"));
            hard.setTooltip(I18N.getResource("security_mode_hard_tooltip"));
            this.modeOptions.add(soft);
            this.modeOptions.add(hard);
        }
        return this.modeOptions;
    }

    public String modify() {
        try {
            boolean deviceChanges = this.hasDevicesChanges();
            if (deviceChanges) {
                this.getProvider().saveDevices(this.devices);
            }
            this.getProvider().saveSecurity(this.security);
            if (deviceChanges) {
                this.getNotification().setColdRestartRequired(true);
                this.getStatusMessage().coldRestartRequired();
            } else {
                this.getNotification().setRestartRequired(true);
                this.getStatusMessage().restartRequired();
            }
            this.getAuditService().publishEvent("Security", "security_updated", this.getAuditValues(this.security, this.devices), 0);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("security_alert_save", se);
        }
        return "success";
    }

    private boolean hasDevicesChanges() throws ServiceException {
        Devices old = this.getProvider().getDevices();
        return old.isInternalSerialEnabled() != this.devices.isInternalSerialEnabled() || old.isInternalSmartCardReaderEnabled() != this.devices.isInternalSmartCardReaderEnabled() || old.isUsbEnabled() != this.devices.isUsbEnabled();
    }

    private String[] getAuditValues(Security sec, Devices devs) {
        boolean upEnc = sec.isEncUp();
        boolean downEnc = sec.isEncDown();
        boolean isAuth = sec.isAuthDown();
        int mode = sec.getMode();
        boolean serialPort = devs.isInternalSerialEnabled();
        boolean reader = devs.isInternalSmartCardReaderEnabled();
        boolean usb = devs.isUsbEnabled();
        String upEncValue = "disabled";
        String downEncValue = "disabled";
        String isAuthValue = "disabled";
        String modeValue = "soft";
        String serialPortValue = "disabled";
        String readerValue = "disabled";
        String usbValue = "disabled";
        if (upEnc) {
            upEncValue = "enabled";
        }
        if (downEnc) {
            downEncValue = "enabled";
        }
        if (isAuth) {
            isAuthValue = "enabled";
        }
        if (mode == 1) {
            modeValue = "hard";
        }
        if (serialPort) {
            serialPortValue = "enabled";
        }
        if (reader) {
            readerValue = "enabled";
        }
        if (usb) {
            usbValue = "enabled";
        }
        String[] args = new String[]{upEncValue, downEncValue, isAuthValue, modeValue, serialPortValue, readerValue, usbValue};
        return args;
    }
}

