/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.dtus;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.console.RawTokenWrapper;
import com.sun.ut.console.dtus.DesktopUnitHelper;
import com.sun.ut.console.server.ServerHelper;
import com.sun.ut.service.DesktopUnit;
import com.sun.ut.service.LogicalToken;
import com.sun.ut.service.MultiheadGroup;
import com.sun.ut.service.Policy;
import com.sun.ut.service.RawToken;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.Session;
import com.sun.ut.service.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DesktopUnitHandler
extends BaseHandler {
    private String id;
    private String location;
    private String description;
    private String model;
    private String firmware;
    private String token;
    private String server;
    private String readerToken;
    private String userId;
    private String user;
    private String userComment;
    private String display;
    private Date firstConnection;
    private Date lastUpdate;
    private boolean isRegistered;
    private boolean isTokenReader;
    private boolean isConfiguredTokenReader;
    private boolean isNewReader;
    private MultiheadGroup multiheadGroup;

    public DesktopUnitHandler() {
        if (Context.getRequestParameter("id") != null) {
            DesktopUnitHelper.setSelectedId(Context.getRequestParameter("id"));
        }
        this.id = DesktopUnitHelper.getSelectedId();
        try {
            DesktopUnit dtu = this.getProvider().getDTU(this.id, true);
            if (dtu != null) {
                this.location = dtu.getLocation();
                this.description = dtu.getDescription();
                this.model = dtu.getModel();
                this.firmware = dtu.getFirmwareRev();
                this.server = dtu.getServer();
                this.isTokenReader = dtu.isTokenReader();
                this.isRegistered = dtu.isRegistered();
                this.firstConnection = dtu.getFirstConnection();
                this.lastUpdate = dtu.getLastUpdate();
                if (dtu.getGroup() != null) {
                    this.multiheadGroup = this.getProvider().getMultiheadGroup(dtu.getGroup());
                }
            }
            Policy policy = this.getProvider().getPolicy();
            this.isConfiguredTokenReader = policy.isTerminalReader(this.id);
            if (this.isConnected()) {
                this.token = this.getProvider().getTokenFromDTU(this.server, this.id);
                List sessions = this.getProvider().getSessions(this.token, this.server);
                Iterator it = sessions.iterator();
                while (it.hasNext()) {
                    Session session = (Session)it.next();
                    if (!this.id.equals(session.getDesktopUnit()) || session.getUnixID() == null || session.getUnixID().length() <= 0) continue;
                    this.user = session.getUnixID();
                    this.display = session.getDisplay();
                    this.userComment = this.getProvider().getUnixUserComment(this.user);
                }
                if (this.isTokenReader) {
                    this.readerToken = this.getProvider().getTokenFromReader(this.id);
                    if (this.readerToken.length() == 0) {
                        this.readerToken = I18N.getResource("dtu_no_smart_card_found");
                    }
                }
            }
            if (!this.isRegistered()) {
                this.getStatusMessage().info("dtu_alert_unregistered_summary", "dtu_alert_unregistered_details");
            }
            this.userId = null;
            List registeredTokens = this.getRegisteredTokens();
            for (int i = 0; i < registeredTokens.size(); ++i) {
                RawToken rawToken = (RawToken)registeredTokens.get(i);
                if (this.token == null || !this.token.equals(rawToken.getId())) continue;
                if (rawToken.getLogicalToken() != null) {
                    User tokenUser = rawToken.getLogicalToken().getUser();
                    this.userId = tokenUser.getId();
                }
                break;
            }
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error(se);
        }
    }

    public boolean isConnected() {
        return this.server != null;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public boolean isMultiheadGroupMember() {
        return this.multiheadGroup != null;
    }

    public String getId() {
        return this.id;
    }

    public String getServer() {
        return this.server;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModel() {
        return this.model;
    }

    public String getFirmware() {
        return this.firmware;
    }

    public String getToken() {
        return this.token;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isUserLoggedIn() {
        return this.user != null;
    }

    public String getUserComment() {
        return this.userComment;
    }

    public String getFirstConnection() {
        if (this.firstConnection != null) {
            return this.firstConnection.toString();
        }
        return "";
    }

    public String getLastStatusUpdate() {
        if (this.lastUpdate != null) {
            return this.lastUpdate.toString();
        }
        return "";
    }

    public String getTokenReader() {
        if (this.isTokenReader()) {
            return I18N.getResource("yes");
        }
        return I18N.getResource("no");
    }

    public String getReaderToken() {
        return this.readerToken;
    }

    public boolean isTokenReader() {
        return this.isTokenReader;
    }

    public boolean isConfiguredTokenReader() {
        return this.isConfiguredTokenReader;
    }

    public void setConfiguredTokenReader(boolean isNewTokenReader) {
        this.isNewReader = isNewTokenReader;
    }

    public String getMultiheadGroupName() {
        return this.multiheadGroup.getName();
    }

    public String getMultiheadGroupGeometry() {
        StringBuffer buffer = new StringBuffer();
        String alt = I18N.getResource("dtu_monitor_alt");
        String primaryAlt = I18N.getResource("dtu_primary_monitor_alt");
        String geometry = "";
        if (this.multiheadGroup != null) {
            geometry = this.multiheadGroup.getGeometry();
        }
        buffer.append(geometry);
        buffer.append("<br><table border='0'><tr>");
        if (this.multiheadGroup != null) {
            String[] members = this.multiheadGroup.getMembers();
            int counter = 0;
            for (int i = 0; i < members.length; ++i) {
                Object[] args = new String[]{members[i]};
                String tooltip = I18N.getResource("dtu_monitor_tooltip", args);
                String primaryTooltip = I18N.getResource("dtu_primary_monitor_tooltip", args);
                buffer.append("<td>");
                if (this.multiheadGroup.getPrimaryDTU().equals(members[i])) {
                    buffer.append("<img src=\"../../images/monitorCheckSmall.gif\" alt=\"").append(primaryAlt).append("\" title=\"").append(primaryTooltip).append("\" height=\"38\" width=\"38\" border=\"0\" />");
                } else {
                    buffer.append("<img src=\"../../images/monitorWhiteSmall.gif\" alt=\"").append(alt).append("\" title=\"").append(tooltip).append("\" height=\"38\" width=\"38\" border=\"0\" />");
                }
                buffer.append("</td> ");
                if (++counter != this.multiheadGroup.getColumns()) continue;
                buffer.append("</tr><tr>");
                counter = 0;
            }
        }
        buffer.append("</tr></table>");
        return buffer.toString();
    }

    public String getMultiheadGroupMembers() {
        StringBuffer buffer = new StringBuffer();
        String tooltip = I18N.getResource("dtu_monitor_link_tooltip");
        buffer.append("<table border='0'><tr>");
        if (this.multiheadGroup != null) {
            String[] members = this.multiheadGroup.getMembers();
            int counter = 0;
            for (int i = 0; i < members.length; ++i) {
                buffer.append("<td>");
                buffer.append("<a id=\"mhg_member");
                buffer.append(i);
                buffer.append("\" class=\"BcmLnk\" title=\"");
                buffer.append(tooltip);
                buffer.append("\" href=\"#\" onclick=\"return hyperlink_submit(this, 'f1', new Array('id', '");
                buffer.append(members[i]);
                buffer.append("'))\">");
                buffer.append(members[i]);
                buffer.append("</a>");
                buffer.append("</td> ");
                if (++counter != this.multiheadGroup.getColumns()) continue;
                buffer.append("</tr><tr>");
                counter = 0;
            }
        }
        buffer.append("</tr></table>");
        return buffer.toString();
    }

    public String save() {
        Object[] auditArgs = new Object[]{this.id, this.location, this.description};
        try {
            if (this.isRegistered) {
                this.getProvider().modifyDTU(this.id, this.location, this.description);
                this.getStatusMessage().info("alert_stored_changes", "dtu_modify", true);
                this.getAuditService().publishEvent("Desktop", "dtu_edit", auditArgs, 0);
            } else if (this.location != null || this.description != null) {
                this.getProvider().addDTU(this.id, this.location, this.description);
                this.getStatusMessage().info("alert_stored_changes", "dtu_add", true);
                this.getAuditService().publishEvent("Desktop", "dtu_added", auditArgs, 0);
            }
            if (this.isConfiguredTokenReader != this.isNewReader) {
                Object[] args = new Object[]{this.id};
                if (this.isNewReader) {
                    this.getProvider().addTokenReader(this.id);
                    this.getAuditService().publishEvent("Desktop", "dtu_tokenReader_yes", args, 0);
                } else {
                    this.getProvider().removeTokenReader(this.id);
                    this.getAuditService().publishEvent("Desktop", "dtu_tokenReader_no", args, 0);
                }
                if (this.isTokenReader != this.isNewReader) {
                    this.getStatusMessage().coldRestartRequired(true);
                    this.getNotification().setColdRestartRequired(true);
                } else {
                    this.getStatusMessage().info("alert_stored_changes", "dtu_modify", true);
                }
            }
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error(se);
            return "success";
        }
        return "viewDesktopUnitDetails";
    }

    public String readTokenFromReader() {
        return "success";
    }

    public String viewTokenDetails() {
        Context.setSessionAttribute("selectedTokenId", this.token);
        Context.setSessionAttribute("selectedUserId", this.userId);
        return "viewTokenDetails";
    }

    public String viewServerDetails() {
        ServerHelper.setSelectedId(this.getServer());
        return "viewServerDetails";
    }

    public String terminate() {
        try {
            this.getProvider().terminateSession(this.server, this.display, this.token);
            Object[] args = new Object[]{this.token, this.display, this.server};
            this.getAuditService().publishEvent("Sessions", "session_terminated", args, 0);
            this.getStatusMessage().info("sessions_terminate", "");
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("sessions_terminate_error", se);
        }
        this.user = null;
        this.userComment = null;
        this.display = null;
        return "success";
    }

    public String getTerminateLabel() {
        String label = "dtu_terminate_button";
        if (!this.isUserLoggedIn()) {
            label = "dtu_terminate_idle_button";
        }
        return I18N.getResource(label);
    }

    public String getTerminateTooltip() {
        String tooltip = "dtu_terminate_button_toolTip";
        if (!this.isUserLoggedIn()) {
            tooltip = "dtu_terminate_idle_button_toolTip";
        }
        return I18N.getResource(tooltip);
    }

    public String getTerminateOnClick() {
        return "if (confirm(\"" + I18N.getResource("sessions_terminate_popup2") + "\") == false) return false;";
    }

    private List getRegisteredTokens() throws ServiceException {
        List registeredUsers = this.getProvider().getUsers(null);
        ArrayList<RawTokenWrapper> registeredTokens = new ArrayList<RawTokenWrapper>();
        for (int i = 0; i < registeredUsers.size(); ++i) {
            User registeredUser = (User)registeredUsers.get(i);
            List logicalTokens = registeredUser.getLogicalTokens();
            if (logicalTokens == null) continue;
            for (int j = 0; j < logicalTokens.size(); ++j) {
                LogicalToken logicalToken = (LogicalToken)logicalTokens.get(j);
                List rawTokens = logicalToken.getRawTokens();
                if (rawTokens == null) continue;
                for (int k = 0; k < rawTokens.size(); ++k) {
                    RawToken rawToken = (RawToken)rawTokens.get(k);
                    rawToken.setOwner(registeredUser.getUserName());
                    rawToken.setDescription(registeredUser.getDescription());
                    rawToken.setSessionType(logicalToken.getSessionType());
                    registeredTokens.add(new RawTokenWrapper(rawToken));
                }
            }
        }
        return registeredTokens;
    }
}

