/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.login;

import com.sun.ut.console.I18N;
import com.sun.ut.console.StatusMessage;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthenticationFilter
implements Filter {
    private static final String CONTEXT_PATH = "/ut/faces";
    private static final String LOGIN_PAGE = "/jsp/login/Login.jsp";
    private static final String WELCOME_PAGE = "/jsp/server/Servers.jsp";
    private static final String IGNORE_PATHS = "ignore-paths";
    public static final String SECURITY_SUBJECT = "security-subject";
    public static final String INVALID_SESSION = "invalid session";
    private HashSet ignorePathSet = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        String ignorePaths = filterConfig.getInitParameter(IGNORE_PATHS);
        this.ignorePathSet = new HashSet();
        if (ignorePaths != null && ignorePaths.length() != 0) {
            StringTokenizer st = new StringTokenizer(ignorePaths, "\n");
            while (st.hasMoreTokens()) {
                this.ignorePathSet.add(st.nextToken().trim());
            }
        }
    }

    public void destroy() {
        if (this.ignorePathSet != null) {
            this.ignorePathSet.clear();
            this.ignorePathSet = null;
        }
    }

    private boolean ignorePath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String requestURI = request.getRequestURI();
        int offset = 0;
        if (requestURI.startsWith(contextPath)) {
            offset = contextPath.length();
        }
        Iterator it = this.ignorePathSet.iterator();
        while (it.hasNext()) {
            String ignorePath = (String)it.next();
            if (!ignorePath.regionMatches(true, 0, requestURI, offset, ignorePath.length() - 1)) continue;
            return true;
        }
        return false;
    }

    private boolean isLoggedIn(HttpServletRequest request) {
        Object subj;
        HttpSession session = request.getSession(false);
        return session != null && (subj = session.getAttribute(SECURITY_SUBJECT)) != null;
    }

    private void printError(HttpServletRequest request, Throwable ex) {
        Locale locale = request.getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle("com.sun.ut.console.resource.ConsoleLabels", locale);
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
            session = request.getSession(true);
            StatusMessage status = new StatusMessage();
            session.setAttribute("statusMessageData", (Object)status.createContent("error", I18N.getResource(bundle, "alert_exception_summary", null), I18N.getResource(bundle, "alert_exception_details", null), I18N.getResource(bundle, "alert_exception_link", null), "_blank", "../misc/Error.jsp"));
            session.setAttribute("ConsoleError", (Object)ex);
        }
    }

    private void printSessionTimeout(HttpServletRequest request) {
        Locale locale = request.getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle("com.sun.ut.console.resource.ConsoleLabels", locale);
        HttpSession session = request.getSession(true);
        if (session.getAttribute("statusMessageData") == null) {
            StatusMessage status = new StatusMessage();
            session.setAttribute("statusMessageData", (Object)status.createContent("information", I18N.getResource(bundle, "timeout_alert_summary", null), I18N.getResource(bundle, "timeout_alert_details", null), null, null, null));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (this.ignorePath(req)) {
            if (LOGIN_PAGE.equals(req.getPathInfo()) && this.isLoggedIn(req)) {
                resp.sendRedirect(resp.encodeRedirectURL("/ut/faces/jsp/server/Servers.jsp"));
                return;
            }
            chain.doFilter(request, response);
            return;
        }
        try {
            if (this.isLoggedIn(req) && req.getPathInfo() != null) {
                chain.doFilter(request, response);
                return;
            }
        }
        catch (Throwable ex) {
            this.printError(req, ex);
        }
        if (this.isLoggedIn(req)) {
            resp.sendRedirect(resp.encodeRedirectURL("/ut/faces/jsp/server/Servers.jsp"));
        } else {
            if (req.getPathInfo() != null && !LOGIN_PAGE.equals(req.getPathInfo())) {
                this.printSessionTimeout(req);
            }
            resp.sendRedirect(resp.encodeRedirectURL("/ut/faces/jsp/login/Login.jsp"));
        }
    }
}

