/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.AdminContext;
import com.sun.ut.service.AuditServiceMockup;
import com.sun.ut.service.ProviderMockup;
import com.sun.ut.service.authentication.LoginModuleMockup;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class AdminContextMockup
extends AdminContext {
    private static Logger mockupLogger;

    public AdminContextMockup() {
        super(new Hashtable());
    }

    public AdminContextMockup(Hashtable env) {
        super(env);
    }

    public void init() {
        if (!this.isInitialized()) {
            this.setHostName(this.determineHostName());
            this.setAuditService(new AuditServiceMockup());
            this.setProvider(new ProviderMockup());
            this.getProvider().init(this);
            this.getAuditService().init(this);
            this.setLoginModule(new LoginModuleMockup());
            this.setInitialized(true);
        }
    }

    public Logger getLogger() {
        if (mockupLogger == null) {
            mockupLogger = Logger.getAnonymousLogger();
            mockupLogger.setUseParentHandlers(false);
            mockupLogger.setLevel(this.getLogLevel());
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            mockupLogger.addHandler(consoleHandler);
            try {
                FileHandler fileHandler = new FileHandler("%tutwebadmin.log", 0, 1, false);
                fileHandler.setLevel(Level.ALL);
                fileHandler.setFormatter(new SimpleFormatter());
                mockupLogger.addHandler(fileHandler);
            }
            catch (IOException ex) {
                mockupLogger.warning("Could not create log file: " + ex.getMessage());
            }
        }
        return mockupLogger;
    }
}

