/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

public class ServiceException
extends Exception {
    public static final int UT_SUCCESS = 0;
    public static final int UT_ERROR = -1;
    public static final int UT_NO_CHANGE = -2;
    public static final int UT_AUTH_FAILED = -3;
    public static final int UT_NOTFOUND = -4;
    public static final int UT_NOPERM = -5;
    public static final int UT_INVARGS = -6;
    public static final int UT_EXISTS = -7;
    public static final int UT_DTUINUSE = -8;
    public static final int UT_NOTOKENENTRY = -9;
    public static final int UT_NOMEM = -10;
    public static final int UT_DUPCID = -11;
    public static final int UT_SERVER_NOT_REACHABLE = -12;
    public static final int UT_SOCKET_OPENING_FAILED = -13;
    public static final int UT_SOCKET_WRITE_FAILED = -14;
    public static final int UT_AUTH_TIMEOUT = -15;
    public static final int UT_FILEERR = -16;
    public static final int UT_INVSEQ = -17;
    public static final int UT_NOMORE = -18;
    public static final int UT_NOENT = -19;
    public static final int UT_UTAFAILED = -20;
    public static final int UT_DETACHED = -22;
    public static final int UT_NOSESSION = -23;
    public static final int UT_TIMEOUT = -24;
    public static final int UT_NETPROBLEM = -25;
    public static final int UT_CONFIGERR = -26;
    public static final int UT_ENOBUFS = -27;
    public static final int UT_DBMFAILED = -28;
    public static final int UT_DSREFERRAL = -29;
    public static final int UT_OPENFAILED = -30;
    public static final int UT_REJECT = -31;
    public static final int UT_DISCONNECT = -32;
    public static final int UT_SYNCTIMEOUT = -33;
    private String key;
    private Object[] keyArgs;
    private String reason;
    private int error;

    public ServiceException(String reason, int error) {
        this.key = null;
        this.reason = reason;
        this.error = error;
    }

    public ServiceException(String key, String reason, int error) {
        this.key = key;
        this.reason = reason;
        this.error = error;
    }

    public ServiceException(String key, Object[] args, String reason, int error) {
        this.key = key;
        this.keyArgs = args;
        this.reason = reason;
        this.error = error;
    }

    public String getMessage() {
        String description = this.getErrorCodeDescription();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.reason);
        buffer.append(", ErrorCode: ");
        buffer.append(this.error);
        if (description != null) {
            buffer.append(" (");
            buffer.append(description);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getMessageKey() {
        return this.key;
    }

    public Object[] getMessageArgs() {
        return this.keyArgs;
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorCodeDescription() {
        if (this.reason.startsWith("ut_")) {
            switch (this.error) {
                case 0: {
                    return "UT_SUCCESS";
                }
                case -1: {
                    return "UT_ERROR - generic error";
                }
                case -2: {
                    return "UT_NO_CHANGE - no change was made";
                }
                case -3: {
                    return "UT_AUTH_FAILED - authentication failed";
                }
                case -4: {
                    return "UT_NOTFOUND - entry not found";
                }
                case -5: {
                    return "UT_NOPERM - no permission";
                }
                case -6: {
                    return "UT_INVARGS - invalid argument passed";
                }
                case -7: {
                    return "UT_EXISTS - entry already exists";
                }
                case -8: {
                    return "UT_DTUINUSE - DTU already in use";
                }
                case -9: {
                    return "UT_NOTOKENENTRY - no token entry found";
                }
                case -10: {
                    return "UT_NOMEM - not enough memory";
                }
                case -11: {
                    return "UT_DUPCID";
                }
                case -12: {
                    return "UT_SERVER_NOT_REACHABLE";
                }
                case -13: {
                    return "UT_SOCKET_OPENING_FAILED";
                }
                case -14: {
                    return "UT_SOCKET_WRITE_FAILED";
                }
                case -15: {
                    return "UT_AUTH_TIMEOUT";
                }
                case -16: {
                    return "UT_FILEERR - file access error";
                }
                case -17: {
                    return "UT_INVSEQ - invalid call sequence";
                }
                case -18: {
                    return "UT_NOMORE - no more data";
                }
                case -19: {
                    return "UT_NOENT - no such file or directory";
                }
                case -20: {
                    return "UT_UTAFAILED - failed to open connection to DB";
                }
                case -22: {
                    return "UT_DETACHED - session detached";
                }
                case -23: {
                    return "UT_NOSESSION - not currently in a Sun Ray session";
                }
                case -24: {
                    return "UT_TIMEOUT - operation timed out";
                }
                case -25: {
                    return "UT_NETPROBLEM - failed to contact remote service";
                }
                case -26: {
                    return "UT_CONFIGERR - configuration error";
                }
                case -27: {
                    return "UT_ENOBUFS - no buffer space available";
                }
                case -28: {
                    return "UT_DBMFAILED - failed to open DBM files";
                }
                case -29: {
                    return "UT_DSREFERRAL - got referral from DS";
                }
                case -30: {
                    return "UT_OPENFAILED - open failed";
                }
                case -31: {
                    return "UT_REJECT - rejected by peer";
                }
                case -32: {
                    return "UT_DISCONNECT - connection disconnected";
                }
                case -33: {
                    return "UT_SYNCTIMEOUT - timeout waiting for replication";
                }
            }
            return null;
        }
        return null;
    }
}

