/*
 * Decompiled with CFR 0.152.
 */
package auth.protocol;

import auth.sdk.Log;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Protocol {
    private static void putCanonical(BufferedWriter out, String data) {
        try {
            block9: for (int i = 0; i < data.length(); ++i) {
                char c = data.charAt(i);
                switch (c) {
                    case '\\': {
                        out.write(92);
                        out.write(92);
                        continue block9;
                    }
                    case '=': {
                        out.write(92);
                        out.write(48);
                        out.write(55);
                        out.write(53);
                        continue block9;
                    }
                    case ' ': {
                        out.write(92);
                        out.write(48);
                        out.write(52);
                        out.write(48);
                        continue block9;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(48);
                        out.write(49);
                        out.write(50);
                        continue block9;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(48);
                        out.write(49);
                        out.write(53);
                        continue block9;
                    }
                    default: {
                        out.write(c);
                    }
                }
            }
        }
        catch (Exception e) {
            Log.unexpectedError((String)"Impossible error in putCanonical");
            return;
        }
    }

    private static String getOctal(PushbackReader pbr) {
        byte[] out = new byte[]{0};
        block9: for (int i = 1; i <= 3; ++i) {
            int la;
            try {
                la = pbr.read();
            }
            catch (IOException ioe) {
                la = -1;
            }
            if (la == -1) break;
            switch (la) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    try {
                        pbr.unread(la);
                    }
                    catch (IOException ioe) {
                        Log.unexpectedError((String)"cannot pushback");
                    }
                    break block9;
                }
            }
            out[0] = (byte)(out[0] * 8 + Character.digit((char)la, 8));
        }
        if (out[0] == 0) {
            out[0] = 32;
        }
        try {
            return new String(out, "8859_1");
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getCanonical(String data) {
        StringWriter out;
        block9: {
            if (data == null) {
                return null;
            }
            PushbackReader pbr = new PushbackReader(new StringReader(data));
            out = new StringWriter();
            try {
                int c;
                block6: while ((c = pbr.read()) != -1) {
                    switch (c) {
                        case 92: {
                            c = pbr.read();
                            if (c == -1 || c == 92) {
                                out.write(92);
                                break;
                            }
                            if (!Character.isDigit((char)c)) continue block6;
                            pbr.unread(c);
                            String ch = Protocol.getOctal(pbr);
                            if (ch == null) continue block6;
                            out.write(ch.charAt(0));
                            break;
                        }
                        case 10: 
                        case 13: {
                            break block9;
                        }
                        default: {
                            out.write(c);
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.unexpectedError((String)"Impossible error in putCanonical");
                return null;
            }
        }
        out.flush();
        return out.toString();
    }

    public static ByteArrayOutputStream format(String command, Hashtable param) throws IOException {
        ByteArrayOutputStream packet = new ByteArrayOutputStream(1500);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)packet, "8859_1"));
            out.write(command);
            if (param != null) {
                Enumeration e = param.keys();
                while (e.hasMoreElements()) {
                    String p = (String)e.nextElement();
                    String v = (String)param.get(p);
                    if (p.equals("redirectProps") && v.length() > 512) {
                        v = "";
                        Log.unexpectedError((String)"protocolViolation: The length of the redirectProps is exceeded 512 bytes, hence redirectProps is set to NULL");
                    }
                    out.write(" ");
                    Protocol.putCanonical(out, p);
                    out.write("=");
                    Protocol.putCanonical(out, v);
                    if (e.hasMoreElements()) continue;
                    break;
                }
            }
            out.write("\n");
            out.flush();
        }
        catch (Exception e) {
            throw new IOException("format failed");
        }
        return packet;
    }

    public static Hashtable parse(String input) {
        Hashtable<String, String> param = new Hashtable<String, String>();
        if (input == null) {
            return param;
        }
        StringTokenizer st = new StringTokenizer(input, " \t");
        String command = st.nextToken();
        param.put("_command", command);
        while (st.hasMoreTokens()) {
            String keyValue = st.nextToken();
            String key = null;
            String value = "true";
            int index = keyValue.indexOf(61);
            if (index < 0) {
                key = keyValue;
                value = "true";
            } else {
                if (index == 0) {
                    Log.clientError((String)("invalid key: " + keyValue));
                    return null;
                }
                key = keyValue.substring(0, index);
                value = Protocol.getCanonical(keyValue.substring(index + 1));
                if (key.equals("redirectProps")) {
                    Protocol.addRedirectPropsValues(value, param);
                    continue;
                }
            }
            if (param.containsKey(key)) {
                Log.clientError((String)("duplicate key: " + key));
                return null;
            }
            param.put(key, value);
        }
        return param;
    }

    private static void addRedirectPropsValues(String set, Hashtable param) {
        Hashtable<String, String> redirProps = new Hashtable<String, String>();
        String convertedSet = Protocol.processEscapes(set);
        StringTokenizer st1 = new StringTokenizer(convertedSet, " ");
        while (st1.hasMoreTokens()) {
            String value;
            String key;
            String keyValue = st1.nextToken();
            int index = keyValue.indexOf("=");
            if (index < 0) {
                key = keyValue;
                value = "true";
            } else {
                if (index == 0) {
                    Log.clientError((String)("invalid key: " + keyValue));
                    return;
                }
                key = keyValue.substring(0, index);
                value = Protocol.getCanonical(keyValue.substring(index + 1));
            }
            redirProps.put(key, value);
        }
        param.putAll(redirProps);
    }

    private static String processEscapes(String set) {
        StringBuffer processed = new StringBuffer();
        for (int i = 0; i < set.length(); ++i) {
            char ch = set.charAt(i);
            if (ch == '\\') {
                int value = 0;
                int count = 0;
                if ((ch = set.charAt(++i)) >= '0' && ch <= '7') {
                    while (ch >= '0' && ch <= '7' && value * 8 + (ch - 48) <= 255) {
                        value = value * 8 + (ch - 48);
                        if (++count >= 3) break;
                        ch = set.charAt(++i);
                    }
                }
                if (value == 0) {
                    value = 32;
                }
                processed.append((char)value);
                continue;
            }
            processed.append(ch);
        }
        return processed.toString();
    }
}

