/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.AlertBase;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.IconHyperlink;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;

public class Alert
extends AlertBase
implements NamingContainer {
    public static final String ALERT_IMAGE_FACET = "alertImage";
    public static final String ALERT_LINK_FACET = "alertLink";

    public UIComponent getAlertIcon() {
        UIComponent imageFacet = this.getFacet(ALERT_IMAGE_FACET);
        if (imageFacet != null) {
            return imageFacet;
        }
        Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        String iconidentifier = this.getIconIdentifier();
        Icon icon = theme.getIcon(iconidentifier);
        icon.setId(ALERT_IMAGE_FACET);
        icon.setParent((UIComponent)this);
        String iconalt = this.getAlt();
        if (iconalt != null) {
            icon.setAlt(iconalt);
        }
        return icon;
    }

    public UIComponent getAlertLink() {
        UIComponent linkFacet = this.getFacet(ALERT_LINK_FACET);
        if (linkFacet != null) {
            return linkFacet;
        }
        String linktext = this.getLinkText();
        if (linktext == null) {
            return ComponentUtilities.getPrivateFacet((UIComponent)this, ALERT_LINK_FACET, false);
        }
        IconHyperlink h = new IconHyperlink();
        h.setId(ALERT_LINK_FACET);
        h.setIcon("HREF_LINK");
        h.setTarget(this.getLinkTarget());
        h.setText(this.getLinkText());
        h.setToolTip(this.getLinkToolTip());
        h.setUrl(this.getLinkURL());
        MethodBinding action = this.getLinkAction();
        if (action != null) {
            h.setAction(action);
        }
        ComponentUtilities.putPrivateFacet((UIComponent)this, ALERT_LINK_FACET, (UIComponent)h);
        return h;
    }

    private String getIconIdentifier() {
        String type = this.getType();
        if (type != null) {
            String lower = type.toLowerCase();
            if (lower.startsWith("warn")) {
                return "ALERT_WARNING_LARGE";
            }
            if (lower.startsWith("ques")) {
                return "ALERT_HELP_LARGE";
            }
            if (lower.startsWith("info")) {
                return "ALERT_INFO_LARGE";
            }
            if (lower.startsWith("succ")) {
                return "ALERT_SUCCESS_LARGE";
            }
        }
        return "ALERT_ERROR_LARGE";
    }
}

