//<!--
//
// ident "$Id$ SMI"
//
// Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
// Use is subject to license terms.
//

var cardSectionId = "f1:p1:policyTabPropSheet:cardSection";
var nonCardSectionId = "f1:p1:policyTabPropSheet:nonCardSection";
var multiheadSectionId = "f1:p1:policyTabPropSheet:multiheadSection";


var kioskCardId = cardSectionId + ":kioskCardProp:kioskCard_editable";
var kioskPseudoId = nonCardSectionId + ":kioskPseudoProp:kioskPseudo_editable";
var mobileSessionsEnabledId = nonCardSectionId + ":mobileSessionsEnabledProp:mobileSessionsEnabled_editable";
var exitMobileSessionsAllowedId = nonCardSectionId + ":exitMobileSessionsAllowedProp:exitMobileSessionsAllowed_editable";
var accessCardNoneId = cardSectionId + ":accessCardProp:accessCard_editable:accessCard_editable_0";
var accessCardAllId = cardSectionId + ":accessCardProp:accessCard_editable:accessCard_editable_1";
var accessCardRegisteredId = cardSectionId + ":accessCardProp:accessCard_editable:accessCard_editable_2";
var accessPseudoNoneId = nonCardSectionId + ":accessPseudoProp:accessPseudo_editable:accessPseudo_editable_0";
var accessPseudoAllId = nonCardSectionId + ":accessPseudoProp:accessPseudo_editable:accessPseudo_editable_1";
var accessPseudoRegisteredId = nonCardSectionId + ":accessPseudoProp:accessPseudo_editable:accessPseudo_editable_2";
var selfRegistrationAllowedCardId = cardSectionId + ":accessCardProp:selfRegistrationAllowedCard_editable";
var selfRegistrationAllowedPseudoId = nonCardSectionId + ":accessPseudoProp:selfRegistrationAllowedPseudo_editable";
var unixAuthenticationRequiredCardId = cardSectionId + ":accessCardProp:unixAuthenticationRequired_editable";
var unixAuthenticationRequiredPseudoId = nonCardSectionId + ":accessPseudoProp:unixAuthenticationRequired_editable";
var multiheadEnabledId = multiheadSectionId + ":multiheadAllowedProp:multiheadAllowed_editable";

//var accessCardHelpId = cardSectionId + ":accessCardProp:accessCardProp_help";
//var accessNonCardHelpId = nonCardSectionId + ":accessPseudoProp:accessPseudoProp_help";
var kioskCardHelpId = cardSectionId + ":kioskCardProp:kioskCardProp_help";
var kioskPseudoHelpId = nonCardSectionId + ":kioskPseudoProp:kioskPseudoProp_help";
var mobileSessionsEnabledHelpId = nonCardSectionId + ":mobileSessionsEnabledProp:mobileSessionsEnabledProp_help";
var mobileSessionsEnableExitHelpId = nonCardSectionId + ":mobileSessionsEnabledProp:helpExitEnabled";
//var exitMobileSessionsAllowedHelpId = nonCardSectionId + ":exitMobileSessionsAllowedProp:exitMobileSessionsAllowedHelp";


function toggleElement(elem, help, isEnabled) {
    if (isEnabled) {
        elem.disabled = false;
        if (help != null) {
            help.style.display='none';
        }
    } else {
        elem.checked = false;
        elem.disabled = true;
        if (help != null) {
            help.style.display='';
            help.style.color='#999999';
            help.style.fontSize='11px';
        }
    }
}

function setOriginalValues() {
    var kioskCard = document.getElementById(kioskCardId);
    var kioskPseudo = document.getElementById(kioskPseudoId);
    var mobileSessionsEnabled = document.getElementById(mobileSessionsEnabledId);
    var exitMobileSessionsAllowed = document.getElementById(exitMobileSessionsAllowedId);
    var accessCardNone = document.getElementById(accessCardNoneId);
    var accessCardAll = document.getElementById(accessCardAllId);
    var accessCardRegistered = document.getElementById(accessCardRegisteredId);
    var accessPseudoNone = document.getElementById(accessPseudoNoneId);
    var accessPseudoAll = document.getElementById(accessPseudoAllId);
    var accessPseudoRegistered = document.getElementById(accessPseudoRegisteredId);
    var selfRegistrationAllowedCard = document.getElementById(selfRegistrationAllowedCardId);
    var selfRegistrationAllowedPseudo = document.getElementById(selfRegistrationAllowedPseudoId);
    var unixAuthenticationRequiredCard = document.getElementById(unixAuthenticationRequiredCardId);   
    var unixAuthenticationRequiredPseudo = document.getElementById(unixAuthenticationRequiredPseudoId);   
    var multiheadEnabled = document.getElementById(multiheadEnabledId);

    var allElements = new Array(kioskCard, kioskPseudo, mobileSessionsEnabled, exitMobileSessionsAllowed,  
                       accessCardNone, accessCardAll, accessCardRegistered,
                       accessPseudoNone, accessPseudoAll, accessPseudoRegistered,
                       selfRegistrationAllowedCard, selfRegistrationAllowedPseudo, unixAuthenticationRequiredCard,
                       unixAuthenticationRequiredPseudo, multiheadEnabled);
                       
    var hiddenOriginalValues = document.getElementById("f1:p1:originalValues");
    var originalValuesString = "";
    for (var i = 0; i < allElements.length; i++) {
       if (allElements[i] != null) {
           if (allElements[i].checked) {
                originalValuesString += "true;";
            } else {
                originalValuesString += "false;";
            }
        } else {
            originalValuesString += "null;";
        }
    }
    hiddenOriginalValues.value = originalValuesString;
    
}


function resetValues() {
    var kioskCard = document.getElementById(kioskCardId);
    var kioskPseudo = document.getElementById(kioskPseudoId);
    var mobileSessionsEnabled = document.getElementById(mobileSessionsEnabledId);
    var exitMobileSessionsAllowed = document.getElementById(exitMobileSessionsAllowedId);
    var accessCardNone = document.getElementById(accessCardNoneId);
    var accessCardAll = document.getElementById(accessCardAllId);
    var accessCardRegistered = document.getElementById(accessCardRegisteredId);
    var accessPseudoNone = document.getElementById(accessPseudoNoneId);
    var accessPseudoAll = document.getElementById(accessPseudoAllId);
    var accessPseudoRegistered = document.getElementById(accessPseudoRegisteredId);
    var selfRegistrationAllowedCard = document.getElementById(selfRegistrationAllowedCardId);
    var selfRegistrationAllowedPseudo = document.getElementById(selfRegistrationAllowedPseudoId);
    var unixAuthenticationRequiredCard = document.getElementById(unixAuthenticationRequiredCardId);   
    var unixAuthenticationRequiredPseudo = document.getElementById(unixAuthenticationRequiredPseudoId);   
    var multiheadEnabled = document.getElementById(multiheadEnabledId);

    var allElements = new Array(kioskCard, kioskPseudo, mobileSessionsEnabled, exitMobileSessionsAllowed,  
                       accessCardNone, accessCardAll, accessCardRegistered,
                       accessPseudoNone, accessPseudoAll, accessPseudoRegistered,
                       selfRegistrationAllowedCard, selfRegistrationAllowedPseudo, unixAuthenticationRequiredCard,
                       unixAuthenticationRequiredPseudo, multiheadEnabled);
                       
    var hiddenOriginalValues = document.getElementById("f1:p1:originalValues");
    var originalValuesString = hiddenOriginalValues.value;
    var originalValuesArray = originalValuesString.split(";");
    for (var i = 0; i < allElements.length; i++) {
        if (allElements[i] != null) {
            if (originalValuesArray[i] == "true") {
                allElements[i].checked = true;
            } else {
                allElements[i].checked = false;
            }
        }
    }
    
}
function disableElements() {
    var kioskCard = document.getElementById(kioskCardId);
    var kioskPseudo = document.getElementById(kioskPseudoId);
    var mobileSessionsEnabled = document.getElementById(mobileSessionsEnabledId);
    var exitMobileSessionsAllowed = document.getElementById(exitMobileSessionsAllowedId);
    var accessCardNone = document.getElementById(accessCardNoneId);
    var accessCardAll = document.getElementById(accessCardAllId);
    var accessCardRegistered = document.getElementById(accessCardRegisteredId);
    var accessPseudoNone = document.getElementById(accessPseudoNoneId);
    var accessPseudoAll = document.getElementById(accessPseudoAllId);
    var accessPseudoRegistered = document.getElementById(accessPseudoRegisteredId);
    var selfRegistrationAllowedCard = document.getElementById(selfRegistrationAllowedCardId);
    var selfRegistrationAllowedPseudo = document.getElementById(selfRegistrationAllowedPseudoId);
    var unixAuthenticationRequiredCard = document.getElementById(unixAuthenticationRequiredCardId);   
    var unixAuthenticationRequiredPseudo = document.getElementById(unixAuthenticationRequiredPseudoId);     
    
//    var accessCardHelp = document.getElementById(accessCardHelpId);
//    var accessNonCardHelp = document.getElementById(accessNonCardHelpId);
    var kioskCardHelp = document.getElementById(kioskCardHelpId);
    var kioskPseudoHelp = document.getElementById(kioskPseudoHelpId);
    var mobileSessionsEnabledHelp = document.getElementById(mobileSessionsEnabledHelpId);
    var mobileSessionsEnableExitHelp = document.getElementById(mobileSessionsEnableExitHelpId);
//    var exitMobileSessionsAllowedHelp = document.getElementById(exitMobileSessionsAllowedHelpId);

    // Trick to cater for elements that are not rendered...
    if (kioskCard == null) {
        kioskCard = {checked:false, disabled:true};
        kioskCardHelp = {style:'none'};
        kioskCardHelp.style = {display:'none'};
    }
    if (kioskPseudo == null) {
        kioskPseudo = {checked:false, disabled:true};
        kioskPseudoHelp = {style:'none'};
        kioskPseudoHelp.style = {display:'none'};
    }
    if (mobileSessionsEnabled == null) {
        mobileSessionsEnabled = {checked:false, disabled:true};
        mobileSessionsEnabledHelp = {style:'none'};
        mobileSessionsEnabledHelp.style = {display:'none'};
        mobileSessionsEnableExitHelp = {style:'none'};
        mobileSessionsEnableExitHelp.style = {display:'none'};
    }
    if (exitMobileSessionsAllowed == null) {
        exitMobileSessionsAllowed = {checked:false, disabled:true};
//        exitMobileSessionsAllowedHelp = {style:'none'};
//        exitMobileSessionsAllowedHelp.style = {display:'none'};
    }

//    accessCardHelp.style.display='none';
//    accessNonCardHelp.style.display='none';
    kioskCardHelp.style.display='none';
    kioskPseudoHelp.style.display='none';
    mobileSessionsEnabledHelp.style.display='none';
    mobileSessionsEnableExitHelp.style.display='none';
//    exitMobileSessionsAllowedHelp.style.display='none';
 
    // If Card Access=None: disable Non-Card Access=None option and Kiosk Card Checkbox
    // Uncheck Non-Card Access=None if its checked and check the All option if necessary)
    if (accessCardNone.checked == true) {
        if (accessPseudoNone.checked == true) {
            accessPseudoNone.checked = false;
            accessPseudoAll.checked = true;
        }
        toggleElement(accessPseudoNone, null, false);
        toggleElement(kioskCard, kioskCardHelp, false);
    } else {
        toggleElement(kioskCard, kioskCardHelp, true);
        toggleElement(accessPseudoNone, null, true);
    }

    // If Non-Card Access=None: disable Card Access=None option, Kiosk Non-Card Checkbox and Mobile-Sessions checkbox
    // Uncheck Card Access=None if its checked and check the All option if necessary)
    if (accessPseudoNone.checked == true) {
        if (accessCardNone.checked == true) {
            accessCardNone.checked = false;
            accessCardAll.checked = true;
        }
        toggleElement(accessCardNone, null, false);
        toggleElement(kioskPseudo, kioskPseudoHelp, false);
        toggleElement(mobileSessionsEnabled, mobileSessionsEnabledHelp, false);
        mobileSessionsEnableExitHelp.style.display='none';
    } else {
        toggleElement(kioskPseudo, kioskPseudoHelp, true);
        toggleElement(mobileSessionsEnabled, mobileSessionsEnabledHelp, true);
        toggleElement(accessCardNone, null, true);
        mobileSessionsEnableExitHelp.style.display='';
    }

    // Toggle remaining settings using their 'parent' settings '.checked' value
    toggleElement(exitMobileSessionsAllowed, null, mobileSessionsEnabled.checked);
    toggleElement(selfRegistrationAllowedCard, null, accessCardRegistered.checked);
    toggleElement(selfRegistrationAllowedPseudo, null, accessPseudoRegistered.checked);

    var toggleUnixAuthCard = (selfRegistrationAllowedCard.checked == false);
    var toggleUnixAuthPseudo = (selfRegistrationAllowedPseudo.checked == false);
    toggleElement(unixAuthenticationRequiredCard, null, !toggleUnixAuthCard);
    toggleElement(unixAuthenticationRequiredPseudo, null, !toggleUnixAuthPseudo);

}

function syncUnixAuth(newValue) {
    // unixAuthenticationRequiredCard and unixAuthenticationRequiredPseudo are really
    // the same setting when stored - therefore sync checkboxes. 
    var unixAuthenticationRequiredCard = document.getElementById(unixAuthenticationRequiredCardId);   
    var unixAuthenticationRequiredPseudo = document.getElementById(unixAuthenticationRequiredPseudoId);  
    unixAuthenticationRequiredCard.checked = newValue;
    unixAuthenticationRequiredPseudo.checked = newValue;
}

function syncUnixAuthByParent() {
    // unixAuthenticationRequiredCard and unixAuthenticationRequiredPseudo are really
    // the same setting when stored - therefore sync checkboxes. 
    var unixAuthenticationRequiredCard = document.getElementById(unixAuthenticationRequiredCardId);   
    var unixAuthenticationRequiredPseudo = document.getElementById(unixAuthenticationRequiredPseudoId);  
    if ((unixAuthenticationRequiredCard.checked == true) ^ (unixAuthenticationRequiredPseudo.checked == true)) {
        unixAuthenticationRequiredCard.checked = true;
        unixAuthenticationRequiredPseudo.checked = true;
    }
}

function handleMobileSessionsChange() {
    // Deal with special case in which the exitMobileSessionsAllowed check box
    // is automatically checked when the mobileSessionsEnabled is checked
    var mobileSessionsEnabled = document.getElementById(mobileSessionsEnabledId);
    var exitMobileSessionsAllowed = document.getElementById(exitMobileSessionsAllowedId);
    if (mobileSessionsEnabled.checked) {
        exitMobileSessionsAllowed.checked = true;
    } 
}

//-->
