//<!--
//
// ident "$Id$ SMI"
//
// Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
// Use is subject to license terms.
//

var tokenTableId = "f1:p1:s1:s2:p2:t1";
var sessionTableId = "f1:p1:t1";

function initAllRows() {
    var table = document.getElementById(tokenTableId);
    table.initAllRows();
}

function disableActions() {
    var table = document.getElementById(tokenTableId);
    var selections = table.getAllSelectedRowsCount();
    document.getElementById(tokenTableId + ":actionsTop:new").setDisabled(selections > 0 ? true : false);
    document.getElementById(tokenTableId + ":actionsTop:delete").setDisabled((selections > 0) ? false : true);
    document.getElementById(tokenTableId + ":actionsTop:enable").setDisabled((selections > 0) ? false : true);
    document.getElementById(tokenTableId + ":actionsTop:disable").setDisabled((selections > 0) ? false : true);
}

function initAllSessionRows() {
    var table = document.getElementById(sessionTableId);
    table.initAllRows();
}

function disableSessionActions() {
    var table = document.getElementById(sessionTableId);
    var selections = table.getAllSelectedRowsCount();
    var terminateDisabled = (selections > 0) ? false : true;
    document.getElementById(sessionTableId + ":actionsTop:terminate").setDisabled(terminateDisabled);
}

function confirmSelectedRowsForTermination(message) {
    var table = document.getElementById(sessionTableId);
    return table.confirmSelectedRows(message);
}

function toggleAddTokenButtons() {
    var okBtn = document.getElementById("f1:t1:pg1:ok_submit");
    var fromManualBtn = document.getElementById("f1:t1:a1:s1:p2:rb1");
    var fromReaderBtn = document.getElementById("f1:t1:a1:s1:p2:rb0");
    var idField = document.getElementById("f1:t1:a1:s1:p2:i2_editable_required");
    var ownerField = document.getElementById("f1:t1:a1:s1:p3:i3_editable_required");
    var hasId = (idField.value != null && idField.value.length > 0);
    var hasOwner = true;
    if (ownerField != null) {
        hasOwner = (ownerField.value != null && ownerField.value.length > 0);
    }
    if (fromReaderBtn.checked) {
        okBtn.setDisabled(!hasOwner);
    } else {
        okBtn.setDisabled(!hasId || !hasOwner);
    }
}

function toggleReaderItems() {
    var fromReaderBtn = document.getElementById("f1:t1:a1:s1:p2:rb0");
    var fromReaderBtnSpan = document.getElementById("f1:t1:a1:s1:p2:rb0_span");
    var fromManualBtn = document.getElementById("f1:t1:a1:s1:p2:rb1");
    var dropDownId = "f1:t1:a1:s1:p2:i1";
    if (document.getElementById(dropDownId).options.length == 0) {
        fromReaderBtn.checked = false;
        fromManualBtn.checked = true;
    };
    var readBtn = document.getElementById("f1:t1:a1:s1:p2:b1");
    var idFieldId = "f1:t1:a1:s1:p2:i2_editable_required";
    var idField = document.getElementById(idFieldId);
    var okBtn = document.getElementById("f1:t1:pg1:ok_submit");
    // special case if no readers are configured - switch the default
    if (document.getElementById(dropDownId).options.length == 0) {
        dropDown_setDisabled(dropDownId, true);
        readBtn.setDisabled(true);
        idField.readOnly = false; 
        fromManualBtn.checked = true;
        fromReaderBtn.checked = false;
        fromReaderBtn.disabled = true;
        okBtn.setDisabled(true);
    } else {
        dropDown_setDisabled(dropDownId, !(fromReaderBtn.checked));
        readBtn.setDisabled(!(fromReaderBtn.checked));
        idField.readOnly = fromReaderBtn.checked;
    }
}

//-->
