<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<ui:masthead id="Masthead" 
             productImageURL="../../images/productName.png"
             productImageDescription="#{msg.product_image_tooltip}" 
             productImageHeight="40"
             productImageWidth="204" 
             userInfo="#{login.userName}" 
             serverInfo="#{login.serverName}"
             dateTime="false">
    <f:facet name="helpLink">
        <ui:helpWindow windowTitle="#{msg.helpWindow_title}" 
                       pageTitle="#{msg.helpWindow_pageTitle}"
                       helpFile="start.html"
                       mastheadImageUrl="/images/productName.png"
                       mastheadImageHeight="40"
                       mastheadImageWidth="204"

                       toolTip="#{msg.helpWindow_link_tooltip}"/>
    </f:facet>
    <f:facet name="versionLink">
        <ui:hyperlink
            id="version"
            url="../misc/Version.jsp" 
            target="versionWindow" 
            toolTip="#{msg.versionWindow_link_tooltip}"
            onClick="javascript:var win = window.open('','versionWindow','height=500,width=650,top='+((screen.height-(screen.height/1.618))-(500/2))+',left='+((screen.width-650)/2)+',scrollbars,resizable');win.focus()"/>
    </f:facet>
    <f:facet name="logoutLink">
        <ui:hyperlink id="logout" 
                      action="#{login.logout}"
                      immediate="true"
                      onClick="#{login.logoutMessage}"
                      toolTip="#{msg.masthead_logout_link_tooltip}"
                      target="_top"/>
    </f:facet>
    <f:facet name="statusArea">
        <ui:panelGroup rendered="#{notification.visible}">
            <ui:markup tag="div" styleClass="MstStatDiv">
                <ui:notificationPhrase id="a1"
                                       icon="#{notification.type}" 
                                       text="#{notification.summary}"
                                       action="viewServers"
                                       toolTip="#{notification.summary}"
                                       alt="#{notification.summary}"
                                       immediate="true"/>
                <f:verbatim><br/></f:verbatim>
                <ui:staticText id="a2"
                               text="#{notification.details}" 
                               styleClass="MstTxt"/>
            </ui:markup>
        </ui:panelGroup>    
    </f:facet> 
</ui:masthead>
