<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <html>
        <!-- Masthead and tab page description/layout generated via JSF -->
        <f:view>
            <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
            <ui:head title="#{login.serverName} - #{msg.default_pageTitle}"/>
            <ui:form id="f1">
                <jsp:directive.include file="../misc/Masthead.jsp"/>
                <ui:tabSet binding="#{tabs.tabSet}" selected="mount"/>
                <ui:alert binding ="#{statusMessage.alert}"/>
                <ui:contentPageTitle id="p1"
                                     title="#{msg.logs_mount_pageTitle}"
                                     helpText="#{msg.logs_mount_pageHelpText}">
                    <f:verbatim><br/></f:verbatim>
                    <ui:markup tag="div" styleClass="ConMgn">
                        <ui:panelGroup id="s1" separator="&#160;">
                            <ui:label text="#{msg.logs_file}"/>
                            <ui:dropDown id="d1"
                                         submitForm="true"
                                         items="#{logFilesHandler.mountOptions}" 
                                         selected="#{logFilesHandler.selectedLogFileName}" 
                                         toolTip="#{msg.logs_file_adminOptions_tooltip}"
                                         action="viewMountLogs"/>
                            <ui:label text="#{msg.logs_size}"/>
                            <ui:staticText text="#{logFilesHandler.selectedLogFile.size}"/>
                        </ui:panelGroup>
                        <f:verbatim><br/></f:verbatim>
                    </ui:markup>
                </ui:contentPageTitle> 
            </ui:form>
            <f:verbatim>
                <script type="text/javascript">
                    document.getElementById("f1:p1:s1:d1").focus();
                </script>
            </f:verbatim>
        </f:view>

        <!-- Log file content generated via plain JSP -->
        <div class="ConMgn">
            <span style="font-family: monospace; font-size:8pt;">
                <pre>
                    <jsp:include page="../../logs"/>
                </pre>    
            </span>
        </div>
        
    </html>                    
</jsp:root> 

