<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->

<!-- Identifier column -->
<ui:tableColumn sort="tokenID">
    <ui:staticText text="#{sessionRowGroup.value.tokenID}"/>
</ui:tableColumn>

<!-- User name column -->
<ui:tableColumn sort="userName">
    <ui:staticText text="#{sessionRowGroup.value.userName}"/>
</ui:tableColumn>

<!-- Unix id column -->
<ui:tableColumn sort="unixID">
    <ui:staticText text="#{sessionRowGroup.value.unixID}"/>
</ui:tableColumn>

<!-- Server column -->
<ui:tableColumn sort="server">
    <ui:hyperlink text="#{sessionRowGroup.value.server}" 
                  action="#{sessionList.showServerDetails}"
                  immediate="true"
                  toolTip="#{msg.session_server_link_tooltip}">
        <f:param name="serverName" 
                 value="#{sessionRowGroup.value.server}"/>
    </ui:hyperlink>
</ui:tableColumn>

<!-- Display column -->
<ui:tableColumn sort="display">
    <ui:staticText text="#{sessionRowGroup.value.display}"/>
</ui:tableColumn>

<!-- Status column -->
<ui:tableColumn sort="connected">
    <ui:image icon="ALERT_OK_SMALL"
              rendered="#{sessionRowGroup.value.connected}"
              alt="#{msg.session_ok_image_alt}" 
              toolTip="#{msg.session_ok_image_alt}" />
    <ui:image icon="ALARM_DOWN_MEDIUM"
              rendered="#{!sessionRowGroup.value.connected}"
              alt="#{msg.session_down_image_alt}" 
              toolTip="#{msg.session_down_image_alt}" />
    <ui:staticText text="&#160;" escape="false"/>               
    <ui:staticText text="#{msg.sessions_connected}"
                   rendered="#{sessionRowGroup.value.connected}"/>
    <ui:staticText text="#{msg.sessions_disconnected}"
                   rendered="#{!sessionRowGroup.value.connected}"/>
</ui:tableColumn>

<!-- DTU column -->
<ui:tableColumn sort="desktopUnit">
    <ui:hyperlink text="#{sessionRowGroup.value.desktopUnit}" 
                  action="#{sessionList.showDesktopUnitDetails}"
                  immediate="true"
                  toolTip="#{msg.session_dtu_link_tooltip}">
        <f:param name="dtu" 
                 value="#{sessionRowGroup.value.desktopUnit}"/>
    </ui:hyperlink>
</ui:tableColumn>
